/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.errors.internals;

import java.util.Optional;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.streams.errors.ErrorHandlerContext;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.TaskId;

public class DefaultErrorHandlerContext
implements ErrorHandlerContext {
    private final String topic;
    private final int partition;
    private final long offset;
    private final Headers headers;
    private final String processorNodeId;
    private final TaskId taskId;
    private final byte[] sourceRawKey;
    private final byte[] sourceRawValue;
    private final long timestamp;
    private final ProcessorContext processorContext;

    public DefaultErrorHandlerContext(ProcessorContext processorContext, String topic, int partition, long offset, Headers headers, String processorNodeId, TaskId taskId, long timestamp, byte[] sourceRawKey, byte[] sourceRawValue) {
        this.topic = topic;
        this.partition = partition;
        this.offset = offset;
        this.headers = headers;
        this.processorNodeId = processorNodeId;
        this.taskId = taskId;
        this.processorContext = processorContext;
        this.timestamp = timestamp;
        this.sourceRawKey = sourceRawKey;
        this.sourceRawValue = sourceRawValue;
    }

    @Override
    public String topic() {
        return this.topic;
    }

    @Override
    public int partition() {
        return this.partition;
    }

    @Override
    public long offset() {
        return this.offset;
    }

    @Override
    public Headers headers() {
        return this.headers;
    }

    @Override
    public String processorNodeId() {
        return this.processorNodeId;
    }

    @Override
    public TaskId taskId() {
        return this.taskId;
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    @Override
    public byte[] sourceRawKey() {
        return this.sourceRawKey;
    }

    @Override
    public byte[] sourceRawValue() {
        return this.sourceRawValue;
    }

    public String toString() {
        return "ErrorHandlerContext{topic='" + this.topic + "', partition=" + this.partition + ", offset=" + this.offset + ", processorNodeId='" + this.processorNodeId + "', taskId=" + String.valueOf(this.taskId) + "}";
    }

    public Optional<ProcessorContext> processorContext() {
        return Optional.ofNullable(this.processorContext);
    }
}

