/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.jpa.store;

import jakarta.persistence.EntityManager;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.MapJoin;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hibernate.Session;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.fgap.AdminPermissionsSchema;
import org.keycloak.authorization.jpa.entities.PolicyEntity;
import org.keycloak.authorization.jpa.store.PolicyAdapter;
import org.keycloak.authorization.jpa.store.ResourceServerAdapter;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.models.jpa.PaginationUtils;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.utils.StreamsUtil;

public class JPAPolicyStore
implements PolicyStore {
    private final EntityManager entityManager;
    private final AuthorizationProvider provider;

    public JPAPolicyStore(EntityManager entityManager, AuthorizationProvider provider) {
        this.entityManager = entityManager;
        this.provider = provider;
    }

    public Policy create(ResourceServer resourceServer, AbstractPolicyRepresentation representation) {
        PolicyEntity entity = new PolicyEntity();
        if (representation.getId() == null) {
            entity.setId(KeycloakModelUtils.generateId());
        } else {
            entity.setId(representation.getId());
        }
        entity.setType(representation.getType());
        entity.setName(representation.getName());
        entity.setResourceServer(ResourceServerAdapter.toEntity(this.entityManager, resourceServer));
        this.entityManager.persist((Object)entity);
        this.entityManager.flush();
        PolicyAdapter model = new PolicyAdapter(entity, this.entityManager, this.provider.getStoreFactory());
        return model;
    }

    public void delete(String id) {
        PolicyEntity policy = (PolicyEntity)this.entityManager.find(PolicyEntity.class, (Object)id, LockModeType.PESSIMISTIC_WRITE);
        if (policy != null) {
            this.entityManager.remove((Object)policy);
        }
    }

    public Policy findById(ResourceServer resourceServer, String id) {
        if (id == null) {
            return null;
        }
        PolicyEntity policyEntity = (PolicyEntity)this.entityManager.find(PolicyEntity.class, (Object)id);
        if (policyEntity == null) {
            return null;
        }
        return new PolicyAdapter(policyEntity, this.entityManager, this.provider.getStoreFactory());
    }

    public Policy findByName(ResourceServer resourceServer, String name) {
        TypedQuery query = this.entityManager.createNamedQuery("findPolicyIdByName", PolicyEntity.class);
        query.setFlushMode(FlushModeType.COMMIT);
        query.setParameter("serverId", (Object)resourceServer.getId());
        query.setParameter("name", (Object)name);
        try {
            PolicyEntity policy = (PolicyEntity)query.getSingleResult();
            return this.provider.getStoreFactory().getPolicyStore().findById(resourceServer, policy.getId());
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    public List<Policy> findByResourceServer(ResourceServer resourceServer) {
        TypedQuery query = this.entityManager.createNamedQuery("findPolicyIdByServerId", String.class);
        query.setParameter("serverId", (Object)resourceServer.getId());
        List result = query.getResultList();
        LinkedList<Policy> list = new LinkedList<Policy>();
        for (String id : result) {
            Policy policy = this.provider.getStoreFactory().getPolicyStore().findById(resourceServer, id);
            if (!Objects.nonNull(policy)) continue;
            list.add(policy);
        }
        return list;
    }

    public List<Policy> find(ResourceServer resourceServer, Map<Policy.FilterOption, String[]> attributes, Integer firstResult, Integer maxResults) {
        CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery querybuilder = builder.createQuery(String.class);
        Root root = querybuilder.from(PolicyEntity.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        querybuilder.select((Selection)root.get("id"));
        if (resourceServer != null) {
            predicates.add(builder.equal((Expression)root.get("resourceServer").get("id"), (Object)resourceServer.getId()));
        }
        attributes.forEach((filterOption, value) -> {
            switch (filterOption) {
                case ID: 
                case OWNER: {
                    predicates.add(root.get(filterOption.getName()).in((Object[])value));
                    break;
                }
                case SCOPE_ID: 
                case RESOURCE_ID: {
                    String[] predicateValues = filterOption.getName().split("\\.");
                    predicates.add(root.join(predicateValues[0]).get(predicateValues[1]).in((Object[])value));
                    break;
                }
                case PERMISSION: {
                    if (Boolean.parseBoolean(value[0])) {
                        predicates.add(root.get("type").in(new Object[]{"resource", "scope", "uma"}));
                        break;
                    }
                    predicates.add(builder.not((Expression)root.get("type").in(new Object[]{"resource", "scope", "uma"})));
                    break;
                }
                case ANY_OWNER: {
                    break;
                }
                case CONFIG: {
                    if (((String[])value).length != 2) {
                        throw new IllegalArgumentException("Config filter option requires value with two items: [config_name, expected_config_value]");
                    }
                    predicates.add(root.joinMap("config").key().in(new Object[]{value[0]}));
                    predicates.add(builder.like(root.joinMap("config").value().as(String.class), "%" + value[1] + "%"));
                    break;
                }
                case TYPE: 
                case NAME: {
                    predicates.add(builder.like(builder.lower((Expression)root.get(filterOption.getName())), "%" + value[0].toLowerCase() + "%"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported filter [" + String.valueOf(filterOption) + "]");
                }
            }
        });
        if (!attributes.containsKey(Policy.FilterOption.OWNER) && !attributes.containsKey(Policy.FilterOption.ANY_OWNER)) {
            predicates.add(builder.isNull((Expression)root.get("owner")));
        }
        querybuilder.where(predicates.toArray(new Predicate[predicates.size()])).orderBy(new Order[]{builder.asc((Expression)root.get("name"))});
        TypedQuery query = this.entityManager.createQuery(querybuilder);
        List result = PaginationUtils.paginateQuery(query, firstResult, maxResults).getResultList();
        LinkedList<Policy> list = new LinkedList<Policy>();
        PolicyStore policyStore = this.provider.getStoreFactory().getPolicyStore();
        for (String id : result) {
            Policy policy = policyStore.findById(resourceServer, id);
            if (!Objects.nonNull(policy)) continue;
            list.add(policy);
        }
        return list;
    }

    public void findByResource(ResourceServer resourceServer, Resource resource, Consumer<Policy> consumer) {
        TypedQuery query = this.entityManager.createNamedQuery("findPolicyIdByResource", PolicyEntity.class);
        query.setFlushMode(FlushModeType.COMMIT);
        query.setParameter("resourceId", (Object)resource.getId());
        query.setParameter("serverId", (Object)resourceServer.getId());
        PolicyStore storeFactory = this.provider.getStoreFactory().getPolicyStore();
        StreamsUtil.closing(query.getResultStream().map(entity -> storeFactory.findById(resourceServer, entity.getId())).filter(Objects::nonNull)).forEach(consumer::accept);
    }

    public void findByResourceType(ResourceServer resourceServer, String resourceType, Consumer<Policy> consumer) {
        TypedQuery query = this.entityManager.createNamedQuery("findPolicyIdByResourceType", PolicyEntity.class);
        query.setFlushMode(FlushModeType.COMMIT);
        query.setParameter("type", (Object)resourceType);
        query.setParameter("serverId", (Object)resourceServer.getId());
        StreamsUtil.closing(query.getResultStream().map(id -> new PolicyAdapter((PolicyEntity)id, this.entityManager, this.provider.getStoreFactory())).filter(Objects::nonNull)).forEach(consumer::accept);
    }

    public List<Policy> findByScopes(ResourceServer resourceServer, List<Scope> scopes) {
        if (scopes == null || scopes.isEmpty()) {
            return Collections.emptyList();
        }
        TypedQuery query = this.entityManager.createNamedQuery("findPolicyIdByScope", PolicyEntity.class);
        query.setFlushMode(FlushModeType.COMMIT);
        query.setParameter("scopeIds", scopes.stream().map(Scope::getId).collect(Collectors.toSet()));
        query.setParameter("serverId", (Object)resourceServer.getId());
        LinkedList<Policy> list = new LinkedList<Policy>();
        PolicyStore storeFactory = this.provider.getStoreFactory().getPolicyStore();
        for (PolicyEntity entity : query.getResultList()) {
            list.add(storeFactory.findById(resourceServer, entity.getId()));
        }
        return list;
    }

    public void findByScopes(ResourceServer resourceServer, Resource resource, List<Scope> scopes, Consumer<Policy> consumer) {
        TypedQuery query;
        if (resource == null) {
            query = this.entityManager.createNamedQuery("findPolicyIdByNullResourceScope", PolicyEntity.class);
        } else {
            query = this.entityManager.createNamedQuery("findPolicyIdByResourceScope", PolicyEntity.class);
            query.setParameter("resourceId", (Object)resource.getId());
        }
        query.setFlushMode(FlushModeType.COMMIT);
        query.setParameter("scopeIds", scopes.stream().map(Scope::getId).collect(Collectors.toSet()));
        query.setParameter("serverId", (Object)resourceServer.getId());
        StoreFactory storeFactory = this.provider.getStoreFactory();
        StreamsUtil.closing(query.getResultStream().map(id -> new PolicyAdapter((PolicyEntity)id, this.entityManager, storeFactory)).filter(Objects::nonNull)).forEach(consumer::accept);
    }

    public List<Policy> findByType(ResourceServer resourceServer, String type) {
        TypedQuery query = this.entityManager.createNamedQuery("findPolicyIdByType", String.class);
        query.setFlushMode(FlushModeType.COMMIT);
        query.setParameter("serverId", (Object)resourceServer.getId());
        query.setParameter("type", (Object)type);
        List result = query.getResultList();
        LinkedList<Policy> list = new LinkedList<Policy>();
        for (String id : result) {
            Policy policy = this.provider.getStoreFactory().getPolicyStore().findById(resourceServer, id);
            if (!Objects.nonNull(policy)) continue;
            list.add(policy);
        }
        return list;
    }

    public List<Policy> findDependentPolicies(ResourceServer resourceServer, String policyId) {
        TypedQuery query = this.entityManager.createNamedQuery("findPolicyIdByDependentPolices", String.class);
        query.setFlushMode(FlushModeType.COMMIT);
        query.setParameter("serverId", (Object)resourceServer.getId());
        query.setParameter("policyId", (Object)policyId);
        List result = query.getResultList();
        LinkedList<Policy> list = new LinkedList<Policy>();
        for (String id : result) {
            Policy policy = this.provider.getStoreFactory().getPolicyStore().findById(resourceServer, id);
            if (!Objects.nonNull(policy)) continue;
            list.add(policy);
        }
        return list;
    }

    public Stream<Policy> findDependentPolicies(ResourceServer resourceServer, String resourceType, String groupResourceType, String associatedPolicyType, String configKey, String configValue) {
        return this.findDependentPolicies(resourceServer, resourceType, groupResourceType, associatedPolicyType, configKey, List.of(configValue));
    }

    public Stream<Policy> findDependentPolicies(ResourceServer resourceServer, String resourceType, String groupResourceType, String associatedPolicyType, String configKey, List<String> configValues) {
        String dbProductName = (String)((Session)this.entityManager.unwrap(Session.class)).doReturningWork(connection -> connection.getMetaData().getDatabaseProductName());
        if (dbProductName.equals("Oracle")) {
            Stream<Policy> result = Stream.empty();
            for (String value : configValues) {
                TypedQuery query = this.entityManager.createNamedQuery("findDependentPolicyByResourceTypeAndConfig", String.class);
                query.setParameter("serverId", (Object)resourceServer.getId());
                query.setParameter("resourceType", (Object)resourceType);
                query.setParameter("associatedPolicyType", (Object)associatedPolicyType);
                query.setParameter("configKey", (Object)configKey);
                query.setParameter("configValue", (Object)("%" + value + "%"));
                if (AdminPermissionsSchema.GROUPS.getType().equals(groupResourceType)) {
                    query.setParameter("scopeName", (Object)"view-members");
                } else {
                    query.setParameter("scopeName", (Object)"view");
                }
                PolicyStore policyStore = this.provider.getStoreFactory().getPolicyStore();
                result = Stream.concat(result, query.getResultStream().map(id -> policyStore.findById(resourceServer, id)).filter(Objects::nonNull));
            }
            return result;
        }
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(String.class);
        Root from = query.from(PolicyEntity.class);
        query.select((Selection)from.get("id"));
        Join scope = from.join("scopes");
        MapJoin config = from.joinMap("config");
        Join associatedPolicy = from.join("associatedPolicies");
        MapJoin associatedPolicyConfig = associatedPolicy.joinMap("config");
        LinkedList<Predicate> predicates = new LinkedList<Predicate>();
        predicates.add(cb.equal((Expression)from.get("resourceServer").get("id"), (Object)resourceServer.getId()));
        if (AdminPermissionsSchema.GROUPS.getType().equals(groupResourceType)) {
            predicates.add(cb.equal((Expression)scope.get("name"), (Object)"view-members"));
        } else {
            predicates.add(cb.equal((Expression)scope.get("name"), (Object)"view"));
        }
        predicates.add(cb.equal((Expression)associatedPolicy.get("type"), (Object)associatedPolicyType));
        predicates.add(cb.equal((Expression)config.key(), (Object)"defaultResourceType"));
        predicates.add(cb.equal((Expression)config.value(), (Object)resourceType));
        LinkedList<Predicate> configValuePredicates = new LinkedList<Predicate>();
        predicates.add(cb.equal((Expression)associatedPolicyConfig.key(), (Object)configKey));
        for (String value : configValues) {
            configValuePredicates.add(cb.like(associatedPolicyConfig.value().as(String.class), "%" + value + "%"));
        }
        predicates.add(cb.or(configValuePredicates.toArray(new Predicate[0])));
        query.where(predicates.toArray(new Predicate[0]));
        PolicyStore policyStore = this.provider.getStoreFactory().getPolicyStore();
        return this.entityManager.createQuery(query).getResultStream().map(id -> policyStore.findById(resourceServer, id)).filter(Objects::nonNull);
    }
}

