/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.nodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.PhpModifiers;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.ParameterElement;
import org.netbeans.modules.php.editor.api.elements.TypeResolver;
import org.netbeans.modules.php.editor.elements.ParameterElementImpl;
import org.netbeans.modules.php.editor.elements.TypeResolverImpl;
import org.netbeans.modules.php.editor.model.nodes.ASTNodeInfo;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocMethodTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTypeNode;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocVarTypeTag;
import org.openide.util.Pair;

public class MagicMethodDeclarationInfo
extends ASTNodeInfo<PHPDocMethodTag> {
    private final List<ParameterElement> parameters = new LinkedList<ParameterElement>();
    private String returnType;
    private String methodName;
    private int offset;
    private int typeOffset;
    private final boolean isStatic;
    private static final Pattern SPLIT_METHOD_NAMES_PATTERN = Pattern.compile("[(, ]");

    MagicMethodDeclarationInfo(PHPDocMethodTag node) {
        super(node);
        String[] parts = CodeUtils.WHITE_SPACES_PATTERN.split(node.getValue().trim(), 3);
        boolean bl = this.isStatic = parts.length >= 1 && parts[0].equals("static");
        assert (this.isStatic == node.isStatic()) : "PHPDocMethodTag static: " + node.isStatic();
        if (this.isStatic) {
            parts = Arrays.copyOfRange(parts, 1, parts.length);
        }
        String mtdName = node.getMethodName().getValue();
        if (parts.length == 1 || parts.length > 0 && parts[0].trim().startsWith(mtdName)) {
            this.returnType = "void";
            methodNames = SPLIT_METHOD_NAMES_PATTERN.split(parts[0], 2);
            if (methodNames.length > 0) {
                this.methodName = methodNames[0];
                this.offset = ((PHPDocMethodTag)this.getOriginalNode()).getStartOffset() + PHPDocTag.Type.METHOD.toString().length() + 1 + node.getValue().indexOf(this.methodName);
            }
        } else if (parts.length >= 2) {
            methodNames = SPLIT_METHOD_NAMES_PATTERN.split(parts[1], 2);
            if (parts[0].length() > 0 && methodNames.length > 0) {
                this.returnType = parts[0];
                this.methodName = methodNames[0];
                this.offset = ((PHPDocMethodTag)this.getOriginalNode()).getStartOffset() + PHPDocTag.Type.METHOD.toString().length() + 1 + node.getValue().indexOf(this.methodName);
                this.typeOffset = ((PHPDocMethodTag)this.getOriginalNode()).getStartOffset() + PHPDocTag.Type.METHOD.toString().length() + 1 + node.getValue().indexOf(this.returnType);
            }
        }
        for (PHPDocVarTypeTag parameter : node.getParameters()) {
            String[] paramValues;
            LinkedList<Pair<QualifiedName, Boolean>> names = new LinkedList<Pair<QualifiedName, Boolean>>();
            String declaredType = null;
            if (!parameter.getTypes().isEmpty() && !(paramValues = CodeUtils.WHITE_SPACES_PATTERN.split(parameter.getValue().trim(), 2))[0].trim().startsWith("$")) {
                declaredType = paramValues[0].trim();
                assert (!declaredType.isEmpty()) : parameter.getValue();
            }
            paramValues = parameter.getTypes().iterator();
            while (paramValues.hasNext()) {
                PHPDocTypeNode type = (PHPDocTypeNode)paramValues.next();
                String typeName = type.getValue();
                boolean isNullableType = CodeUtils.isNullableType(typeName);
                if (isNullableType) {
                    typeName = typeName.substring(1);
                }
                QualifiedName qualifiedName = QualifiedName.create(typeName);
                names.add((Pair<QualifiedName, Boolean>)Pair.of((Object)qualifiedName, (Object)isNullableType));
            }
            Set<TypeResolver> types = TypeResolverImpl.forNames(names);
            String name = parameter.getVariable().getValue();
            String[] split = parameter.getValue().split("=");
            String defaultValue = null;
            if (split.length > 1) {
                defaultValue = split[1].trim();
            }
            boolean isMandatory = defaultValue == null;
            boolean isReference = name.startsWith("&");
            boolean isVariadic = name.startsWith("...");
            boolean isRawType = declaredType != null;
            this.parameters.add(new ParameterElementImpl(name, defaultValue, 0, declaredType, declaredType, types, isMandatory, isRawType, isReference, isVariadic, false, 0, false));
        }
    }

    @CheckForNull
    public static MagicMethodDeclarationInfo create(PHPDocMethodTag node) {
        MagicMethodDeclarationInfo retval = new MagicMethodDeclarationInfo(node);
        return retval.methodName != null && retval.returnType != null ? retval : null;
    }

    public ASTNodeInfo<PHPDocMethodTag> getClassInfo() {
        return new ASTNodeInfo<PHPDocMethodTag>((PHPDocMethodTag)this.getOriginalNode()){

            @Override
            public String getName() {
                return MagicMethodDeclarationInfo.this.getReturnType();
            }

            @Override
            public OffsetRange getRange() {
                return MagicMethodDeclarationInfo.this.getTypeRange();
            }

            @Override
            public ASTNodeInfo.Kind getKind() {
                return ASTNodeInfo.Kind.CLASS;
            }

            @Override
            public QualifiedName getQualifiedName() {
                return QualifiedName.create(this.getName());
            }

            @Override
            public PhpElementKind getPhpElementKind() {
                return PhpElementKind.CLASS;
            }
        };
    }

    @Override
    public ASTNodeInfo.Kind getKind() {
        return this.isStatic ? ASTNodeInfo.Kind.STATIC_METHOD : ASTNodeInfo.Kind.METHOD;
    }

    @Override
    public String getName() {
        return this.getQualifiedName().toName().toString();
    }

    public String getReturnType() {
        return this.returnType;
    }

    @Override
    public QualifiedName getQualifiedName() {
        return QualifiedName.create(this.methodName).toName();
    }

    @Override
    public OffsetRange getRange() {
        return new OffsetRange(this.offset, this.offset + this.getName().length());
    }

    public OffsetRange getTypeRange() {
        return new OffsetRange(this.typeOffset, this.typeOffset + this.getReturnType().length());
    }

    public List<? extends ParameterElement> getParameters() {
        return new ArrayList<ParameterElement>(this.parameters);
    }

    public PhpModifiers getAccessModifiers() {
        int modifiers = this.isStatic ? 9 : 1;
        return PhpModifiers.fromBitMask(modifiers);
    }
}

