/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.diff;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.netbeans.modules.git.GitStatusNode;
import org.netbeans.modules.git.ui.diff.DiffFileViewComponent;
import org.netbeans.modules.git.ui.diff.DiffNode;
import org.netbeans.modules.git.ui.diff.MultiDiffPanelController;
import org.netbeans.modules.versioning.diff.DiffUtils;
import org.netbeans.modules.versioning.util.FilePathCellRenderer;
import org.netbeans.modules.versioning.util.status.VCSStatusNode;
import org.netbeans.modules.versioning.util.status.VCSStatusTable;
import org.netbeans.modules.versioning.util.status.VCSStatusTableModel;
import org.openide.cookies.EditorCookie;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.Mutex;
import org.openide.util.WeakListeners;

class DiffFileTable
extends VCSStatusTable<DiffNode>
implements DiffFileViewComponent<DiffNode> {
    private Map<File, EditorCookie> editorCookies;
    private PropertyChangeListener changeListener;
    private final MultiDiffPanelController controller;

    public DiffFileTable(VCSStatusTableModel<DiffNode> model, MultiDiffPanelController controller) {
        super(model);
        this.controller = controller;
        this.setDefaultRenderer(new DiffTableCellRenderer());
    }

    protected void setModelProperties() {
        Node.Property[] properties = new Node.Property[]{new ColumnDescriptor<String>("name", String.class, VCSStatusNode.NameProperty.DISPLAY_NAME, VCSStatusNode.NameProperty.DESCRIPTION), new ColumnDescriptor<String>("gitstatus", String.class, GitStatusNode.GitStatusProperty.DISPLAY_NAME, GitStatusNode.GitStatusProperty.DESCRIPTION), new ColumnDescriptor<String>("path", String.class, VCSStatusNode.PathProperty.DISPLAY_NAME, VCSStatusNode.PathProperty.DESCRIPTION)};
        this.tableModel.setProperties(properties);
    }

    protected JPopupMenu getPopup() {
        return this.controller.getPopupFor((Node[])this.getSelectedNodes(), this.getSelectedFiles());
    }

    public void setNodes(DiffNode[] nodes) {
        throw new UnsupportedOperationException("Do not call this method.");
    }

    public void updateNodes(List<DiffNode> toRemove, List<DiffNode> toRefresh, List<DiffNode> toAdd) {
        throw new UnsupportedOperationException("Do not call this method.");
    }

    void updateNodes(Map<File, EditorCookie> editorCookies, List<DiffNode> toRemove, List<DiffNode> toRefresh, List<DiffNode> toAdd) {
        this.setEditorCookies(editorCookies);
        super.updateNodes(toRemove, toRefresh, toAdd);
        if (this.getTable().getRowCount() == 1) {
            this.getTable().getSelectionModel().addSelectionInterval(0, 0);
        }
    }

    private void setEditorCookies(Map<File, EditorCookie> editorCookies) {
        this.editorCookies = editorCookies;
        this.changeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Object source = e.getSource();
                String propertyName = e.getPropertyName();
                if ("modified".equals(propertyName) && source instanceof EditorCookie.Observable) {
                    final EditorCookie.Observable cookie = (EditorCookie.Observable)source;
                    Mutex.EVENT.readAccess(new Runnable(){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void run() {
                            for (int i = 0; i < this.this$1.DiffFileTable.this.tableModel.getRowCount(); ++i) {
                                if (this.this$1.DiffFileTable.this.editorCookies.get(((DiffNode)this.this$1.DiffFileTable.this.tableModel.getNode(i)).getFile()) != cookie) continue;
                                this.this$1.DiffFileTable.this.tableModel.fireTableCellUpdated(i, 0);
                                break;
                            }
                        }
                    });
                }
            }
        };
        for (Map.Entry<File, EditorCookie> e : editorCookies.entrySet()) {
            EditorCookie editorCookie = e.getValue();
            if (!(editorCookie instanceof EditorCookie.Observable)) continue;
            ((EditorCookie.Observable)editorCookie).addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.changeListener, (Object)editorCookie));
        }
    }

    protected JTable getDiffTable() {
        return super.getTable();
    }

    public Object prepareModel(DiffNode[] nodes) {
        return null;
    }

    public void setModel(DiffNode[] nodes, EditorCookie[] editorCookies, Object modelData) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setModel(DiffNode[] nodes, Map<File, EditorCookie> editorCookies, Object modelData) {
        this.setEditorCookies(editorCookies);
        super.setNodes((VCSStatusNode[])nodes);
    }

    private class DiffTableCellRenderer
    extends DefaultTableCellRenderer {
        private FilePathCellRenderer pathRenderer = new FilePathCellRenderer();

        private DiffTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component renderer;
            int modelColumnIndex = table.convertColumnIndexToModel(column);
            DiffNode node = null;
            if (modelColumnIndex == 0) {
                node = (DiffNode)DiffFileTable.this.tableModel.getNode(table.convertRowIndexToModel(row));
                Object htmlDisplayName = DiffUtils.getHtmlDisplayName((Node)node, (boolean)this.isModified(node.getFile()), (boolean)isSelected);
                if (node.isExcluded()) {
                    htmlDisplayName = "<s>" + (String)(htmlDisplayName == null ? node.getFileNode().getName() : htmlDisplayName) + "</s>";
                }
                if (htmlDisplayName != null) {
                    value = "<html>" + (String)htmlDisplayName;
                }
            }
            if ((renderer = modelColumnIndex == 2 ? this.pathRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column) : super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column)) instanceof JComponent) {
                if (node == null) {
                    node = (DiffNode)DiffFileTable.this.tableModel.getNode(table.convertRowIndexToModel(row));
                }
                String path = node.getFile().getAbsolutePath();
                ((JComponent)renderer).setToolTipText(path);
            }
            return renderer;
        }

        private boolean isModified(File file) {
            EditorCookie editorCookie = DiffFileTable.this.editorCookies.get(file);
            return editorCookie != null ? editorCookie.isModified() : false;
        }
    }

    private static class ColumnDescriptor<T>
    extends PropertySupport.ReadOnly<T> {
        public ColumnDescriptor(String name, Class<T> type, String displayName, String shortDescription) {
            super(name, type, displayName, shortDescription);
        }

        public T getValue() throws IllegalAccessException, InvocationTargetException {
            return null;
        }
    }
}

