/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.run;

import java.awt.EventQueue;
import java.awt.Toolkit;
import java.io.IOException;
import java.net.URL;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.module.AntModule;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.util.UserQuestionException;
import org.openide.util.WeakSet;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public final class Hyperlink
implements OutputListener {
    static final Set<Hyperlink> hyperlinks = new WeakSet();
    private static final RequestProcessor RP = new RequestProcessor(Hyperlink.class);
    private final URL url;
    private final String message;
    private final int line1;
    private int col1;
    private final int line2;
    private final int col2;
    private Line liveLine;
    private static final Logger ERR = Logger.getLogger("org.apache.tools.ant.module.run.Hyperlink");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hyperlink(URL url, String message, int line1, int col1, int line2, int col2) {
        this.url = url;
        this.message = message;
        this.line1 = line1;
        this.col1 = col1;
        this.line2 = line2;
        this.col2 = col2;
        Set<Hyperlink> set = hyperlinks;
        synchronized (set) {
            hyperlinks.add(this);
        }
    }

    public void setColumn1(int col1) {
        if (this.col1 == -1) {
            this.col1 = col1;
        }
    }

    public void outputLineAction(OutputEvent ev) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                block12: {
                    FileObject file = URLMapper.findFileObject((URL)Hyperlink.this.url);
                    if (file == null) {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                    try {
                        DataObject dob = DataObject.find((FileObject)file);
                        EditorCookie ed = (EditorCookie)dob.getLookup().lookup(EditorCookie.class);
                        if (ed != null && file == dob.getPrimaryFile()) {
                            block13: {
                                if (Hyperlink.this.line1 == -1) {
                                    ed.open();
                                    break block12;
                                }
                                try {
                                    ed.openDocument();
                                }
                                catch (UserQuestionException exc) {
                                    if (Hyperlink.this.askUserAndDoOpen(exc, ed)) break block13;
                                    return;
                                }
                            }
                            AntModule.err.log("opened document for " + file);
                            try {
                                final Line line = Hyperlink.this.updateLines(ed);
                                if (!line.isDeleted()) {
                                    EventQueue.invokeLater(new Runnable(){
                                        final /* synthetic */ 1 this$1;
                                        {
                                            this.this$1 = this$1;
                                        }

                                        @Override
                                        public void run() {
                                            line.show(Line.ShowOpenType.REUSE, Line.ShowVisibilityType.FOCUS, this.this$1.Hyperlink.this.col1 == -1 ? -1 : this.this$1.Hyperlink.this.col1 - 1);
                                        }
                                    });
                                }
                                break block12;
                            }
                            catch (IndexOutOfBoundsException ioobe) {
                                ed.open();
                            }
                            break block12;
                        }
                        Toolkit.getDefaultToolkit().beep();
                    }
                    catch (DataObjectNotFoundException donfe) {
                        ErrorManager.getDefault().notify(16, (Throwable)donfe);
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().notify(16, (Throwable)ioe);
                    }
                }
                if (Hyperlink.this.message != null) {
                    StatusDisplayer.getDefault().setStatusText(Hyperlink.this.message);
                }
            }
        });
    }

    private boolean askUserAndDoOpen(UserQuestionException e, EditorCookie cookie) {
        while (e != null) {
            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)e.getLocalizedMessage(), 0);
            nd.setOptions(new Object[]{NotifyDescriptor.YES_OPTION, NotifyDescriptor.NO_OPTION});
            Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            if (NotifyDescriptor.OK_OPTION.equals(res)) {
                try {
                    e.confirmed();
                }
                catch (IOException ex1) {
                    Exceptions.printStackTrace((Throwable)ex1);
                    return true;
                }
            } else {
                return false;
            }
            e = null;
            try {
                cookie.openDocument();
            }
            catch (UserQuestionException ex) {
                e = ex;
            }
            catch (IOException ex) {
                ERR.log(Level.INFO, null, ex);
            }
            catch (Exception ex) {
                ERR.log(Level.SEVERE, null, ex);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Line updateLines(EditorCookie ed) {
        Line.Set lineset = ed.getLineSet();
        Set<Hyperlink> set = hyperlinks;
        synchronized (set) {
            assert (this.line1 != -1);
            boolean ran = false;
            boolean encounteredThis = false;
            boolean modifiedThis = false;
            if (this.liveLine == null) {
                ran = true;
                for (Hyperlink h : hyperlinks) {
                    if (h == this) {
                        encounteredThis = true;
                    }
                    if (h.liveLine != null || !h.url.equals(this.url) || h.line1 == -1) continue;
                    Line l = lineset.getOriginal(h.line1 - 1);
                    assert (l != null) : h;
                    h.liveLine = l;
                    if (h != this) continue;
                    modifiedThis = true;
                }
            }
            assert (this.liveLine != null) : "this=" + this + " ran=" + ran + " encounteredThis=" + encounteredThis + " modifiedThis=" + modifiedThis + " hyperlinks=" + hyperlinks + " hyperlinks.contains(this)=" + hyperlinks.contains(this);
            return this.liveLine;
        }
    }

    public void outputLineSelected(OutputEvent ev) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                FileObject file = URLMapper.findFileObject((URL)Hyperlink.this.url);
                if (file == null) {
                    return;
                }
                try {
                    DataObject dob = DataObject.find((FileObject)file);
                    EditorCookie ed = (EditorCookie)dob.getLookup().lookup(EditorCookie.class);
                    if (ed != null) {
                        Line line;
                        if (ed.getDocument() == null) {
                            AntModule.err.log("no document for " + file);
                            return;
                        }
                        AntModule.err.log("got document for " + file);
                        if (Hyperlink.this.line1 != -1 && !(line = Hyperlink.this.updateLines(ed)).isDeleted()) {
                            EventQueue.invokeLater(new Runnable(){
                                final /* synthetic */ 2 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                @Override
                                public void run() {
                                    line.show(Line.ShowOpenType.NONE, Line.ShowVisibilityType.NONE, this.this$1.Hyperlink.this.col1 == -1 ? -1 : this.this$1.Hyperlink.this.col1 - 1);
                                }
                            });
                        }
                    }
                }
                catch (DataObjectNotFoundException donfe) {
                    ErrorManager.getDefault().notify(16, (Throwable)donfe);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputLineCleared(OutputEvent ev) {
        Set<Hyperlink> set = hyperlinks;
        synchronized (set) {
            this.liveLine = null;
        }
    }

    public String toString() {
        return "Hyperlink[" + this.url + ":" + this.line1 + ":" + this.col1 + ":" + this.line2 + ":" + this.col2 + "]";
    }
}

