/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.libs.git.GitRevisionInfo;

public final class GitRevertResult {
    private Status status;
    private GitRevisionInfo revertCommit;
    private final List<File> conflicts;
    private final List<File> failures;

    GitRevertResult(Status status, GitRevisionInfo commit, List<File> conflicts, List<File> failures) {
        this.status = status;
        this.revertCommit = commit;
        this.conflicts = conflicts == null ? Collections.emptyList() : conflicts;
        this.failures = failures == null ? Collections.emptyList() : failures;
    }

    public Status getStatus() {
        return this.status;
    }

    public GitRevisionInfo getNewHead() {
        return this.revertCommit;
    }

    public Collection<File> getConflicts() {
        return this.conflicts;
    }

    public Collection<File> getFailures() {
        return this.failures;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Status {
        REVERTED{

            public String toString() {
                return "Reverted";
            }
        }
        ,
        REVERTED_IN_INDEX{

            public String toString() {
                return "Reverted In Index";
            }
        }
        ,
        CONFLICTING{

            public String toString() {
                return "Conflicting";
            }
        }
        ,
        FAILED{

            public String toString() {
                return "Failed";
            }
        }
        ,
        NO_CHANGE{

            public String toString() {
                return "No Change";
            }
        };

    }
}

