/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.refactoring.dependency;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.namespace.QName;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.model.pom.Build;
import org.netbeans.modules.maven.model.pom.Configuration;
import org.netbeans.modules.maven.model.pom.POMExtensibilityElement;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Plugin;
import org.netbeans.modules.maven.options.MavenVersionSettings;
import org.netbeans.modules.maven.refactoring.dependency.Bundle;
import org.netbeans.modules.maven.refactoring.dependency.RewriteContext;
import org.netbeans.modules.project.dependency.ArtifactSpec;
import org.netbeans.modules.project.dependency.Dependency;
import org.netbeans.modules.project.dependency.DependencyChange;
import org.netbeans.modules.project.dependency.DependencyChangeException;
import org.netbeans.modules.project.dependency.DependencyResult;
import org.netbeans.modules.project.dependency.ProjectDependencies;
import org.netbeans.modules.project.dependency.ProjectOperationException;
import org.netbeans.modules.project.dependency.Scope;
import org.netbeans.modules.project.dependency.Scopes;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class DependencyAdder {
    private static final String ELEMENT_VERSION = "version";
    private static final String ELEMENT_ARTIFACT_ID = "artifactId";
    private static final String ELEMENT_GROUP_ID = "groupId";
    private static final String ELEMENT_PATH = "path";
    private static final String ELEMENT_PROCESSOR_PATHS = "annotationProcessorPaths";
    private final Project project;
    private final DependencyChange request;
    private final RewriteContext rewrite;
    private POMModel mutableModel;
    private List<Dependency> accepted = new ArrayList<Dependency>();
    protected Map<Dependency, Dependency> offending = new HashMap<Dependency, Dependency>();
    DependencyResult current;

    public DependencyAdder(Project project, DependencyChange request, RewriteContext rewrite) {
        this.project = project;
        this.request = request;
        this.rewrite = rewrite;
    }

    protected void throwDependencyConflicts() throws DependencyChangeException {
        if (!this.offending.isEmpty()) {
            throw new DependencyChangeException(this.request, DependencyChangeException.Reason.CONFLICT, this.offending);
        }
    }

    protected void throwUnknownScope(Dependency d) throws DependencyChangeException {
        throw new DependencyChangeException(this.request, d, DependencyChangeException.Reason.MALFORMED);
    }

    protected void recordConflict(Dependency requested, Dependency existing) {
        if (!this.request.getOptions().contains(DependencyChange.Options.skipConflicts)) {
            this.offending.putIfAbsent(requested, existing);
        }
    }

    private ArtifactSpec mavenToArtifactSpec(Artifact a) {
        FileObject f;
        FileObject fileObject = f = a.getFile() == null ? null : FileUtil.toFileObject((File)a.getFile());
        if (a.isSnapshot()) {
            return ArtifactSpec.createSnapshotSpec((String)a.getGroupId(), (String)a.getArtifactId(), (String)a.getType(), (String)a.getClassifier(), (String)a.getVersion(), (boolean)a.isOptional(), (FileObject)f, (Object)a);
        }
        return ArtifactSpec.createVersionSpec((String)a.getGroupId(), (String)a.getArtifactId(), (String)a.getType(), (String)a.getClassifier(), (String)a.getVersion(), (boolean)a.isOptional(), (FileObject)f, (Object)a);
    }

    protected boolean checkDependencyConflicts(ArtifactSpec existingA, ArtifactSpec toAdd) throws DependencyChangeException {
        if (!existingA.getGroupId().equals(toAdd.getGroupId()) || !existingA.getArtifactId().equals(toAdd.getArtifactId())) {
            return true;
        }
        String existingC = existingA.getClassifier();
        return existingC != null && !Objects.equals(existingC, toAdd.getClassifier());
    }

    protected boolean checkDependencyConflicts(Dependency existing, Dependency d) throws DependencyChangeException {
        String existingScope;
        if (this.checkDependencyConflicts(existing.getArtifact(), d.getArtifact())) {
            return true;
        }
        String mavenScope = this.rewrite.mavenScope(d);
        if (!mavenScope.equals(existingScope = this.rewrite.mavenScope(existing))) {
            return true;
        }
        this.recordConflict(d, existing);
        return false;
    }

    private void addProcessorDependency(Dependency d) {
        Configuration config;
        Plugin plg;
        ArtifactSpec a = d.getArtifact();
        Build pBuild = this.mutableModel.getProject().getBuild();
        if (pBuild == null) {
            pBuild = this.mutableModel.getFactory().createBuild();
            this.mutableModel.getProject().setBuild(pBuild);
        }
        if ((plg = pBuild.findPluginById("org.apache.maven.plugins", "maven-compiler-plugin")) == null) {
            plg = this.mutableModel.getFactory().createPlugin();
            plg.setGroupId("org.apache.maven.plugins");
            plg.setArtifactId("maven-compiler-plugin");
            plg.setVersion(MavenVersionSettings.getDefault().getVersion("org.apache.maven.plugins", "maven-compiler-plugin"));
            pBuild.addPlugin(plg);
        }
        if ((config = plg.getConfiguration()) == null) {
            config = this.mutableModel.getFactory().createConfiguration();
            plg.setConfiguration(config);
        }
        Configuration fConfig = config;
        POMExtensibilityElement annoPathList = config.getConfigurationElements().stream().filter(e -> e.getQName().getLocalPart().equals(ELEMENT_PROCESSOR_PATHS)).findAny().orElseGet(() -> {
            POMExtensibilityElement e = this.mutableModel.getFactory().createPOMExtensibilityElement(new QName(ELEMENT_PROCESSOR_PATHS));
            fConfig.addExtensibilityElement(e);
            return e;
        });
        POMExtensibilityElement path = this.mutableModel.getFactory().createPOMExtensibilityElement(new QName(ELEMENT_PATH));
        path.setChildElementText(null, a.getGroupId(), new QName(ELEMENT_GROUP_ID));
        path.setChildElementText(null, a.getArtifactId(), new QName(ELEMENT_ARTIFACT_ID));
        if (a.getVersionSpec() != null) {
            path.setChildElementText(null, a.getVersionSpec(), new QName(ELEMENT_VERSION));
        }
        annoPathList.addExtensibilityElement(path);
    }

    private void addCodeDependency(Dependency d) {
        String scope;
        ArtifactSpec a = d.getArtifact();
        org.netbeans.modules.maven.model.pom.Dependency mavenDep = this.mutableModel.getFactory().createDependency();
        mavenDep.setGroupId(a.getGroupId());
        mavenDep.setArtifactId(a.getArtifactId());
        if (a.getVersionSpec() != null && !a.getVersionSpec().isEmpty()) {
            mavenDep.setVersion(a.getVersionSpec());
        }
        if (a.getClassifier() != null) {
            mavenDep.setClassifier(a.getClassifier());
        }
        if (!"compile".equals(scope = this.rewrite.mavenScope(d))) {
            mavenDep.setScope(scope);
        }
        this.mutableModel.getProject().addDependency(mavenDep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws DependencyChangeException {
        this.current = ProjectDependencies.findDependencies((Project)this.project, (ProjectDependencies.DependencyQuery)ProjectDependencies.newQuery((Scope[])new Scope[]{Scopes.DECLARED}));
        NbMavenProject nbmp = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        MavenProject mp = nbmp.getMavenProject();
        Map plugins = mp.getBuild().getPluginsAsMap();
        List<Object> annotationPath = null;
        try {
            this.mutableModel = this.rewrite.getWriteModel();
            for (Dependency d : this.request.getDependencies()) {
                boolean toAccept = true;
                for (Dependency c : this.current.getRoot().getChildren()) {
                    if (this.checkDependencyConflicts(c, d)) continue;
                    toAccept = false;
                    break;
                }
                if (d.getScope().equals((Object)Scopes.PROCESS)) {
                    if (annotationPath == null) {
                        PluginPropertyUtils.PluginConfigPathParams params = new PluginPropertyUtils.PluginConfigPathParams("org.apache.maven.plugins", "maven-compiler-plugin", ELEMENT_PROCESSOR_PATHS, ELEMENT_PATH);
                        List arts = PluginPropertyUtils.getPluginPathProperty((Project)this.project, (PluginPropertyUtils.PluginConfigPathParams)params, (boolean)true, null);
                        if (arts != null) {
                            annotationPath = PluginPropertyUtils.getPluginPathProperty((Project)this.project, (PluginPropertyUtils.PluginConfigPathParams)params, (boolean)true, null).stream().map(this::mavenToArtifactSpec).toList();
                        }
                        if (annotationPath == null) {
                            annotationPath = Collections.emptyList();
                        }
                    }
                    for (ArtifactSpec a : annotationPath) {
                        if (d.getArtifact() == null || this.checkDependencyConflicts(a, d.getArtifact())) continue;
                        toAccept = false;
                        break;
                    }
                }
                if (!toAccept) continue;
                this.accepted.add(d);
            }
            this.throwDependencyConflicts();
            this.mutableModel.sync();
            this.mutableModel.startTransaction();
            boolean ok = false;
            try {
                for (Dependency d : this.accepted) {
                    if (d.getScope().equals((Object)Scopes.PROCESS)) {
                        this.addProcessorDependency(d);
                        continue;
                    }
                    this.addCodeDependency(d);
                }
                this.mutableModel.endTransaction();
                ok = true;
            }
            finally {
                if (!ok) {
                    this.mutableModel.rollbackTransaction();
                }
            }
        }
        catch (IOException ex) {
            throw new ProjectOperationException(this.project, ProjectOperationException.State.UNSUPPORTED, Bundle.ERR_CannotModifyProject(this.rewrite.getPomFile()));
        }
        catch (IllegalArgumentException | IllegalStateException | UnsupportedOperationException ex) {
            throw new ProjectOperationException(this.project, ProjectOperationException.State.ERROR, Bundle.ERR_AddingDependency(), (Throwable)ex);
        }
    }
}

