/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.actions;

import java.io.IOException;
import java.util.List;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.api.support.AddOperationCookie;
import org.netbeans.modules.websvc.api.support.java.SourceUtils;
import org.netbeans.modules.websvc.core.AddWsOperationHelper;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class JaxWsAddOperation
implements AddOperationCookie {
    private Service service;
    private DataObject dataObject;

    public JaxWsAddOperation(FileObject implClassFo) {
        try {
            this.dataObject = DataObject.find((FileObject)implClassFo);
        }
        catch (DataObjectNotFoundException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        this.service = this.getService(implClassFo);
    }

    public void addOperation() {
        final AddWsOperationHelper strategy = new AddWsOperationHelper(NbBundle.getMessage(JaxWsAddOperation.class, (String)"TITLE_OperationAction"));
        RequestProcessor.getDefault().post(new Runnable(){
            final /* synthetic */ JaxWsAddOperation this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    FileObject primaryFile = this.this$0.dataObject.getPrimaryFile();
                    String className = JaxWsAddOperation.getMainClassName(primaryFile);
                    if (className != null) {
                        strategy.addMethod(primaryFile, className);
                    }
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
        });
    }

    public boolean isEnabledInEditor(Lookup nodeLookup) {
        return this.isJaxWsImplementationClass() && !this.isFromWSDL() && !this.isProvider();
    }

    private boolean isJaxWsImplementationClass() {
        return this.service != null;
    }

    private Service getService(FileObject fileObject) {
        JAXWSSupport jaxWsSupport = JAXWSSupport.getJAXWSSupport((FileObject)fileObject);
        if (jaxWsSupport != null) {
            List services = jaxWsSupport.getServices();
            for (int i = 0; i < services.size(); ++i) {
                String implClass;
                Service serv = (Service)services.get(i);
                if (serv.getWsdlUrl() != null || !(implClass = serv.getImplementationClass()).equals(this.getPackageName(fileObject))) continue;
                return serv;
            }
        }
        return null;
    }

    private boolean isFromWSDL() {
        if (this.service != null) {
            return this.service.getWsdlUrl() != null;
        }
        return false;
    }

    private boolean isProvider() {
        if (this.service != null) {
            return this.service.isUseProvider();
        }
        return false;
    }

    private String getPackageName(FileObject fo) {
        SourceGroup[] groups;
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        Sources sources = (Sources)project.getLookup().lookup(Sources.class);
        if (sources != null && (groups = sources.getSourceGroups("java")) != null) {
            for (SourceGroup group : groups) {
                FileObject rootFolder = group.getRootFolder();
                if (!FileUtil.isParentOf((FileObject)rootFolder, (FileObject)fo)) continue;
                String relativePath = FileUtil.getRelativePath((FileObject)rootFolder, (FileObject)fo).replace('/', '.');
                return relativePath.endsWith(".java") ? relativePath.substring(0, relativePath.length() - 5) : relativePath;
            }
        }
        return null;
    }

    @SuppressWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public static String getMainClassName(FileObject classFO) throws IOException {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)classFO);
        final String[] result = new String[1];
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController controller) throws IOException {
                controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                TypeElement classEl = SourceUtils.getPublicTopLevelElement((CompilationController)controller);
                if (classEl != null) {
                    result[0] = classEl.getQualifiedName().toString();
                }
            }
        }, true);
        return result[0];
    }
}

