/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly.config;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.j2ee.dd.api.common.ServiceRef;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.DatasourceConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.DeploymentPlanConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ModuleConfiguration;
import org.netbeans.modules.javaee.wildfly.config.ResourceConfigurationHelper;
import org.netbeans.modules.javaee.wildfly.config.WildflyDeploymentConfiguration;
import org.netbeans.modules.javaee.wildfly.config.gen.EjbRef;
import org.netbeans.modules.javaee.wildfly.config.gen.JbossClient;
import org.netbeans.modules.javaee.wildfly.config.gen.ResourceRef;
import org.netbeans.modules.javaee.wildfly.ide.ui.WildflyPluginUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class CarDeploymentConfiguration
extends WildflyDeploymentConfiguration
implements ModuleConfiguration,
DatasourceConfiguration,
DeploymentPlanConfiguration,
PropertyChangeListener {
    private File jbossClientFile;
    private JbossClient jbossClient;

    public CarDeploymentConfiguration(J2eeModule j2eeModule) {
        this(j2eeModule, null, true);
    }

    public CarDeploymentConfiguration(J2eeModule j2eeModule, WildflyPluginUtils.Version version, boolean isWildFly) {
        super(j2eeModule, version, isWildFly);
        this.jbossClientFile = j2eeModule.getDeploymentConfigurationFile("META-INF/jboss-client.xml");
        this.getJbossClient();
        if (this.deploymentDescriptorDO == null) {
            try {
                this.deploymentDescriptorDO = DataObject.find((FileObject)FileUtil.toFileObject((File)this.jbossClientFile));
                this.deploymentDescriptorDO.addPropertyChangeListener((PropertyChangeListener)this);
            }
            catch (DataObjectNotFoundException donfe) {
                Exceptions.printStackTrace((Throwable)donfe);
            }
        }
    }

    public void dispose() {
    }

    public Lookup getLookup() {
        return Lookups.fixed((Object[])new Object[]{this});
    }

    public synchronized JbossClient getJbossClient() {
        if (this.jbossClient == null) {
            try {
                if (this.jbossClientFile.exists()) {
                    try {
                        this.jbossClient = JbossClient.createGraph(this.jbossClientFile);
                    }
                    catch (IOException ioe) {
                        Exceptions.printStackTrace((Throwable)ioe);
                    }
                    catch (RuntimeException ioe) {}
                } else {
                    this.jbossClient = this.generateJbossClient();
                    ResourceConfigurationHelper.writeFile(this.jbossClientFile, this.jbossClient);
                }
            }
            catch (ConfigurationException ce) {
                Exceptions.printStackTrace((Throwable)ce);
            }
        }
        return this.jbossClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object newValue = evt.getNewValue();
        if (evt.getPropertyName() == "modified" && evt.getNewValue() == Boolean.FALSE) {
            if (evt.getSource() == this.deploymentDescriptorDO) {
                CarDeploymentConfiguration carDeploymentConfiguration = this;
                synchronized (carDeploymentConfiguration) {
                    this.jbossClient = null;
                }
            }
        } else if (evt.getOldValue() == null) {
            if (newValue instanceof org.netbeans.modules.j2ee.dd.api.common.ResourceRef) {
                org.netbeans.modules.j2ee.dd.api.common.ResourceRef resourceRef = (org.netbeans.modules.j2ee.dd.api.common.ResourceRef)newValue;
                try {
                    String resType = resourceRef.getResType();
                    if ("javax.sql.DataSource".equals(resType)) {
                        this.addResReference(resourceRef.getResRefName());
                    } else if ("javax.mail.Session".equals(resType)) {
                        this.addMailReference(resourceRef.getResRefName());
                    } else if ("javax.jms.ConnectionFactory".equals(resType)) {
                        this.addConnectionFactoryReference(resourceRef.getResRefName());
                    }
                }
                catch (ConfigurationException ce) {
                    Exceptions.printStackTrace((Throwable)ce);
                }
            } else if (newValue instanceof org.netbeans.modules.j2ee.dd.api.common.EjbRef) {
                org.netbeans.modules.j2ee.dd.api.common.EjbRef ejbRef = (org.netbeans.modules.j2ee.dd.api.common.EjbRef)newValue;
                try {
                    String ejbRefType = ejbRef.getEjbRefType();
                    if ("Session".equals(ejbRefType) || "Entity".equals(ejbRefType)) {
                        this.addEjbReference(ejbRef.getEjbRefName());
                    }
                }
                catch (ConfigurationException ce) {
                    Exceptions.printStackTrace((Throwable)ce);
                }
            } else if (newValue instanceof ServiceRef) {
                ServiceRef serviceRef = (ServiceRef)newValue;
                try {
                    this.addServiceReference(serviceRef.getServiceRefName());
                }
                catch (ConfigurationException ce) {
                    Exceptions.printStackTrace((Throwable)ce);
                }
            }
        }
    }

    public void save(OutputStream os) throws ConfigurationException {
        JbossClient jbossClientDD = this.getJbossClient();
        if (jbossClientDD == null) {
            String msg = NbBundle.getMessage(CarDeploymentConfiguration.class, (String)"MSG_cannotSaveNotParseableConfFile", (Object)this.jbossClientFile.getAbsolutePath());
            throw new ConfigurationException(msg);
        }
        try {
            jbossClientDD.write(os);
        }
        catch (IOException ioe) {
            String msg = NbBundle.getMessage(CarDeploymentConfiguration.class, (String)"MSG_CannotUpdateFile", (Object)this.jbossClientFile.getAbsolutePath());
            throw new ConfigurationException(msg, (Throwable)ioe);
        }
    }

    private JbossClient generateJbossClient() {
        JbossClient jbossClientDD = new JbossClient();
        return jbossClientDD;
    }

    private void addResReference(final String name) throws ConfigurationException {
        this.modifyJbossClient(new JbossClientModifier(){
            final /* synthetic */ CarDeploymentConfiguration this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void modify(JbossClient modifiedJbossClient) {
                ResourceRef[] resourceRefs = modifiedJbossClient.getResourceRef();
                for (int i = 0; i < resourceRefs.length; ++i) {
                    String rrn = resourceRefs[i].getResRefName();
                    if (!name.equals(rrn)) continue;
                    return;
                }
                ResourceRef newRR = new ResourceRef();
                newRR.setResRefName(name);
                newRR.setJndiName("java:/" + name);
                modifiedJbossClient.addResourceRef(newRR);
            }
        });
    }

    private void addMailReference(final String name) throws ConfigurationException {
        this.modifyJbossClient(new JbossClientModifier(){
            final /* synthetic */ CarDeploymentConfiguration this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void modify(JbossClient modifiedJbossClient) {
                ResourceRef[] resourceRefs = modifiedJbossClient.getResourceRef();
                for (int i = 0; i < resourceRefs.length; ++i) {
                    String rrn = resourceRefs[i].getResRefName();
                    if (!name.equals(rrn)) continue;
                    return;
                }
                ResourceRef newRR = new ResourceRef();
                newRR.setResRefName(name);
                newRR.setJndiName("java:Mail");
                modifiedJbossClient.addResourceRef(newRR);
            }
        });
    }

    private void addConnectionFactoryReference(final String name) throws ConfigurationException {
        this.modifyJbossClient(new JbossClientModifier(){
            final /* synthetic */ CarDeploymentConfiguration this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void modify(JbossClient modifiedJbossClient) {
                ResourceRef[] resourceRefs = modifiedJbossClient.getResourceRef();
                for (int i = 0; i < resourceRefs.length; ++i) {
                    String rrn = resourceRefs[i].getResRefName();
                    if (!name.equals(rrn)) continue;
                    return;
                }
                ResourceRef newRR = new ResourceRef();
                newRR.setResRefName(name);
                newRR.setJndiName("ConnectionFactory");
                modifiedJbossClient.addResourceRef(newRR);
            }
        });
    }

    private void addEjbReference(final String name) throws ConfigurationException {
        this.modifyJbossClient(new JbossClientModifier(){
            final /* synthetic */ CarDeploymentConfiguration this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void modify(JbossClient modifiedJbossClient) {
                EjbRef[] ejbRefs = modifiedJbossClient.getEjbRef();
                for (int i = 0; i < ejbRefs.length; ++i) {
                    String ern = ejbRefs[i].getEjbRefName();
                    if (!name.equals(ern)) continue;
                    return;
                }
                EjbRef newER = new EjbRef();
                newER.setEjbRefName(name);
                newER.setJndiName(name);
                modifiedJbossClient.addEjbRef(newER);
            }
        });
    }

    private void setJndiName(final String jndiName) throws ConfigurationException {
        this.modifyJbossClient(new JbossClientModifier(){
            final /* synthetic */ CarDeploymentConfiguration this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void modify(JbossClient modifiedJbossClient) {
                modifiedJbossClient.setJndiName(jndiName);
            }
        });
    }

    private void addServiceReference(final String name) throws ConfigurationException {
        this.modifyJbossClient(new JbossClientModifier(){
            final /* synthetic */ CarDeploymentConfiguration this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void modify(JbossClient modifiedJbossClient) {
                String[] serviceRefs = modifiedJbossClient.getServiceRef();
                for (int i = 0; i < serviceRefs.length; ++i) {
                    String srn = serviceRefs[i];
                    if (!name.equals(srn)) continue;
                    return;
                }
                modifiedJbossClient.addServiceRef(name);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modifyJbossClient(JbossClientModifier modifier) throws ConfigurationException {
        assert (this.deploymentDescriptorDO != null) : "DataObject has not been initialized yet";
        try {
            SaveCookie cookie;
            EditorCookie editor = (EditorCookie)this.deploymentDescriptorDO.getCookie(EditorCookie.class);
            StyledDocument doc = editor.getDocument();
            if (doc == null) {
                doc = editor.openDocument();
            }
            JbossClient newJbossClient = null;
            try {
                byte[] docString = doc.getText(0, doc.getLength()).getBytes();
                newJbossClient = JbossClient.createGraph(new ByteArrayInputStream(docString));
            }
            catch (RuntimeException e) {
                JbossClient oldJbossClient = this.getJbossClient();
                if (oldJbossClient == null) {
                    String msg = NbBundle.getMessage(CarDeploymentConfiguration.class, (String)"MSG_jbossXmlCannotParse", (Object)this.jbossClientFile.getAbsolutePath());
                    throw new ConfigurationException(msg);
                }
                NotifyDescriptor.Confirmation notDesc = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(CarDeploymentConfiguration.class, (String)"MSG_jbossClientXmlNotValid"), 2);
                Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)notDesc);
                if (result == NotifyDescriptor.CANCEL_OPTION) {
                    return;
                }
                newJbossClient = oldJbossClient;
            }
            modifier.modify(newJbossClient);
            boolean modified = this.deploymentDescriptorDO.isModified();
            ResourceConfigurationHelper.replaceDocument(doc, newJbossClient);
            if (!modified && (cookie = (SaveCookie)this.deploymentDescriptorDO.getCookie(SaveCookie.class)) != null) {
                cookie.save();
            }
            CarDeploymentConfiguration carDeploymentConfiguration = this;
            synchronized (carDeploymentConfiguration) {
                this.jbossClient = newJbossClient;
            }
        }
        catch (BadLocationException ble) {
            Exceptions.printStackTrace((Throwable)ble);
        }
        catch (IOException ioe) {
            String msg = NbBundle.getMessage(CarDeploymentConfiguration.class, (String)"MSG_CannotUpdateFile", (Object)this.jbossClientFile.getAbsolutePath());
            throw new ConfigurationException(msg, (Throwable)ioe);
        }
    }

    private static interface JbossClientModifier {
        public void modify(JbossClient var1);
    }
}

