/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.bz2;

import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.runtime.NFIBz2Support;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.Shape;
import java.util.Arrays;

public abstract class BZ2Object
extends PythonBuiltinObject {
    private NFIBz2Support.Pointer pointer;

    public BZ2Object(Object cls, Shape instanceShape) {
        super(cls, instanceShape);
    }

    public final void init(Object bzst, NFIBz2Support lib) {
        this.pointer = new NFIBz2Support.Pointer((Object)this, bzst, lib);
    }

    public final Object getBzs() {
        assert (this.pointer != null);
        return this.pointer.getReference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public final void markReleased() {
        if (this.pointer != null) {
            BZ2Object bZ2Object = this;
            synchronized (bZ2Object) {
                this.pointer.markReleased();
                this.pointer = null;
            }
        }
    }

    public static BZ2Compressor createCompressor(Object cls, Shape instanceShape) {
        return new BZ2Compressor(cls, instanceShape);
    }

    public static BZ2Decompressor createDecompressor(Object cls, Shape instanceShape) {
        return new BZ2Decompressor(cls, instanceShape);
    }

    public static class BZ2Compressor
    extends BZ2Object {
        private boolean flushed = false;

        public BZ2Compressor(Object cls, Shape instanceShape) {
            super(cls, instanceShape);
        }

        public boolean isFlushed() {
            return this.flushed;
        }

        public void setFlushed() {
            this.flushed = true;
        }
    }

    public static class BZ2Decompressor
    extends BZ2Object {
        private boolean eof = false;
        private byte[] unusedData = PythonUtils.EMPTY_BYTE_ARRAY;
        private boolean needsInput = true;
        private byte[] inputBuffer = null;
        private int inputBufferSize = 0;
        private int bzsAvailInReal = 0;
        private byte[] nextIn = null;
        private int nextInIndex = 0;

        public BZ2Decompressor(Object cls, Shape instanceShape) {
            super(cls, instanceShape);
        }

        public boolean isEOF() {
            return this.eof;
        }

        public void setEOF() {
            this.eof = true;
        }

        public byte[] getUnusedData() {
            return this.unusedData;
        }

        public void setUnusedData() {
            this.unusedData = Arrays.copyOfRange(this.nextIn, this.getNextInIndex(), this.getNextInIndex() + this.getBzsAvailInReal());
        }

        public boolean needsInput() {
            return this.needsInput;
        }

        public void setNeedsInput(boolean needsInput) {
            this.needsInput = needsInput;
        }

        public byte[] getInputBuffer() {
            return this.inputBuffer;
        }

        public void setInputBuffer(byte[] inputBuffer) {
            this.inputBuffer = inputBuffer;
        }

        public void createInputBuffer(int size) {
            this.inputBuffer = new byte[size];
            this.inputBufferSize = size;
        }

        public void discardInputBuffer() {
            this.inputBuffer = null;
            this.inputBufferSize = 0;
        }

        public void resizeInputBuffer(int size) {
            assert (size >= this.inputBufferSize);
            byte[] tmp = new byte[size];
            if (this.inputBuffer != null && this.getBzsAvailInReal() != 0) {
                PythonUtils.arraycopy(this.inputBuffer, 0, tmp, 0, this.inputBuffer.length);
            }
            this.inputBuffer = tmp;
            this.inputBufferSize = size;
        }

        public int getInputBufferSize() {
            return this.inputBufferSize;
        }

        public void setInputBufferSize(int inputBufferSize) {
            this.inputBufferSize = inputBufferSize;
        }

        public byte[] getNextIn() {
            return this.nextIn;
        }

        public void setNextIn(byte[] in) {
            assert (in != null);
            this.nextIn = in;
        }

        public void clearNextIn() {
            this.nextIn = null;
        }

        public int getNextInIndex() {
            return this.nextInIndex;
        }

        public void setNextInIndex(int nextInIndex) {
            this.nextInIndex = nextInIndex;
        }

        public void setNextInIndex(long nextInIndex) throws OverflowException {
            this.nextInIndex = PInt.intValueExact(nextInIndex);
        }

        public int getBzsAvailInReal() {
            return this.bzsAvailInReal;
        }

        public void incBzsAvailInReal(int size) {
            this.bzsAvailInReal += size;
        }

        public void setBzsAvailInReal(int bzsAvailInReal) {
            this.bzsAvailInReal = bzsAvailInReal;
        }

        public void setBzsAvailInReal(long bzsAvailInReal) throws OverflowException {
            this.bzsAvailInReal = PInt.intValueExact(bzsAvailInReal);
        }
    }
}

