/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.object;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.ExtAllocator;
import com.oracle.truffle.api.object.ExtLayout;
import com.oracle.truffle.api.object.ExtLocation;
import com.oracle.truffle.api.object.ExtLocations;
import com.oracle.truffle.api.object.LayoutStrategy;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.LocationImpl;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.ShapeImpl;

abstract class ExtLayoutStrategy
extends LayoutStrategy {
    protected ExtLayoutStrategy() {
    }

    protected static boolean assertLocationInRange(ShapeImpl shape, Location location) {
        final ExtLayout layout = (ExtLayout)shape.getLayout();
        if (location instanceof LocationImpl) {
            ((LocationImpl)location).accept(new LocationImpl.LocationVisitor(){

                @Override
                public void visitPrimitiveField(int index, int count) {
                    assert (index + count <= layout.getPrimitiveFieldCount());
                }

                @Override
                public void visitObjectField(int index, int count) {
                    assert (index + count <= layout.getObjectFieldCount());
                }

                @Override
                public void visitPrimitiveArray(int index, int count) {
                }

                @Override
                public void visitObjectArray(int index, int count) {
                }
            });
        }
        return true;
    }

    @Override
    protected Location createLocationForValue(ShapeImpl shape, Object value, int putFlags) {
        return ((ExtAllocator)shape.allocator()).locationForValue(value, putFlags);
    }

    @Override
    protected int getLocationOrdinal(Location location) {
        return ExtLocations.getLocationOrdinal((ExtLocation)location);
    }

    @Override
    protected ShapeImpl removeProperty(ShapeImpl shape, Property property) {
        if (property.getLocation() instanceof ExtLocations.InstanceLocation) {
            ((ExtLocations.InstanceLocation)property.getLocation()).maybeInvalidateFinalAssumption();
        }
        return super.removeProperty(shape, property);
    }

    @Override
    protected ShapeImpl defineProperty(ShapeImpl oldShape, Object key, Object value, int propertyFlags, Property existing, int putFlags) {
        return super.defineProperty(oldShape, key, value, propertyFlags, existing, putFlags);
    }

    @Override
    protected ShapeImpl definePropertyGeneralize(ShapeImpl oldShape, Property oldProperty, Object value, int putFlags) {
        return super.definePropertyGeneralize(oldShape, oldProperty, value, putFlags);
    }

    @Override
    protected abstract boolean updateShape(DynamicObject var1);

    private static void ensureSameTypeOrMoreGeneral(Location generalLocation, Location specificLocation) {
        if (generalLocation == specificLocation) {
            return;
        }
        if (generalLocation instanceof ExtLocations.AbstractObjectLocation) {
            ExtLocations.AbstractObjectLocation objLocGen = (ExtLocations.AbstractObjectLocation)generalLocation;
            if (specificLocation instanceof ExtLocations.AbstractObjectLocation) {
                ExtLocations.TypeAssumption assumSpe;
                ExtLocations.AbstractObjectLocation objLocSpe = (ExtLocations.AbstractObjectLocation)specificLocation;
                ExtLocations.TypeAssumption assumGen = objLocGen.getTypeAssumption();
                if (assumGen != (assumSpe = objLocSpe.getTypeAssumption()) && (!assumGen.type.isAssignableFrom(assumSpe.type) || assumGen.nonNull && !assumSpe.nonNull)) {
                    objLocGen.mergeTypeAssumption(assumSpe);
                }
            }
        }
    }

    @Override
    protected void ensureSameTypeOrMoreGeneral(Property generalProperty, Property specificProperty) {
        super.ensureSameTypeOrMoreGeneral(generalProperty, specificProperty);
        ExtLayoutStrategy.ensureSameTypeOrMoreGeneral(generalProperty.getLocation(), specificProperty.getLocation());
    }
}

