
use builtin;
use str;

set edit:completion:arg-completer[teamtype] = {|@words|
    fn spaces {|n|
        builtin:repeat $n ' ' | str:join ''
    }
    fn cand {|text desc|
        edit:complex-candidate $text &display=$text' '(spaces (- 14 (wcswidth $text)))$desc
    }
    var command = 'teamtype'
    for word $words[1..-1] {
        if (str:has-prefix $word '-') {
            break
        }
        set command = $command';'$word
    }
    var completions = [
        &'teamtype'= {
            cand --directory 'The shared directory. Defaults to current directory'
            cand -h 'Print help'
            cand --help 'Print help'
            cand -V 'Print version'
            cand --version 'Print version'
            cand share 'Share a directory with a new peer'
            cand join 'Join a shared directory via a join code, or connect to the most recent one'
            cand client 'Open a JSON-RPC connection to the Teamtype daemon on stdin/stdout. Used by text editor plugins'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'teamtype;share'= {
            cand --directory 'The shared directory. Defaults to current directory'
            cand --init 'Re-initialize the history of the shared directory. You will loose previous history'
            cand --no-join-code 'Do not generate a join code. To prevent unintended sharing or simply if you want to keep Magic Wormhole out of the loop'
            cand --show-secret-address 'Print the secret address. Useful for sharing with multiple people'
            cand --sync-vcs 'EXPERIMENTAL: Also synchronize version-control directories like .git/ or .jj/, which are normally ignored. For Git, this will synchronize all branches, commits, etc. as well as your .git/config. This means that new commits will immediately appear at all peers, you can change branches together, etc'
            cand -h 'Print help'
            cand --help 'Print help'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'teamtype;join'= {
            cand --directory 'The shared directory. Defaults to current directory'
            cand --sync-vcs 'EXPERIMENTAL: Also synchronize version-control directories like .git/ or .jj/, which are normally ignored. For Git, this will synchronize all branches, commits, etc. as well as your .git/config. This means that new commits will immediately appear at all peers, you can change branches together, etc'
            cand -h 'Print help'
            cand --help 'Print help'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'teamtype;client'= {
            cand --directory 'The shared directory. Defaults to current directory'
            cand -h 'Print help'
            cand --help 'Print help'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'teamtype;help'= {
            cand share 'Share a directory with a new peer'
            cand join 'Join a shared directory via a join code, or connect to the most recent one'
            cand client 'Open a JSON-RPC connection to the Teamtype daemon on stdin/stdout. Used by text editor plugins'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'teamtype;help;share'= {
        }
        &'teamtype;help;join'= {
        }
        &'teamtype;help;client'= {
        }
        &'teamtype;help;help'= {
        }
    ]
    $completions[$command]
}
