/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.DeclarationFormattingContext;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandBuilder;
import io.sf.carte.doc.style.css.parser.SyntaxParser;
import io.sf.carte.doc.style.css.property.ColorIdentifiers;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.doc.style.css.property.ValueList;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.util.Locale;
import java.util.Set;

class BackgroundBuilder
extends ShorthandBuilder {
    private static CSSValueSyntax lengthPercentage = new SyntaxParser().parseSyntax("<length-percentage>");
    private StyleValue bgimage;
    private StyleValue bgposition;
    private StyleValue bgsize;
    private StyleValue bgrepeat;
    private StyleValue bgattachment;
    private StyleValue bgclip;
    private StyleValue bgorigin;
    private boolean appended = false;

    BackgroundBuilder(BaseCSSStyleDeclaration parentStyle) {
        super("background", parentStyle);
    }

    @Override
    protected int getMinimumSetSize() {
        return 8;
    }

    @Override
    int appendShorthandSet(StringBuilder buf, Set<String> declaredSet, boolean important) {
        buf.append(this.getShorthandName()).append(':');
        this.bgimage = this.getCSSValue("background-image");
        this.bgposition = this.computeMultipleSubproperty("background-image", "background-position");
        this.bgsize = this.computeMultipleSubproperty("background-image", "background-size");
        this.bgrepeat = this.computeMultipleSubproperty("background-image", "background-repeat");
        this.bgattachment = this.computeMultipleSubproperty("background-image", "background-attachment");
        this.bgclip = this.computeMultipleSubproperty("background-image", "background-clip");
        this.bgorigin = this.computeMultipleSubproperty("background-image", "background-origin");
        CSSValue.CssType type = this.bgimage.getCssValueType();
        if (type == CSSValue.CssType.LIST && ((ValueList)this.bgimage).isCommaSeparated()) {
            if (!this.appendLayeredBackground(buf, declaredSet, ((ValueList)this.bgimage).getLength())) {
                return 1;
            }
        } else {
            byte inheritcheck = this.checkForInherit();
            if (inheritcheck == 1) {
                buf.append("inherit");
                this.appendPriority(buf, important);
                return 0;
            }
            if (inheritcheck == 2) {
                return 1;
            }
            byte check = this.checkForRevert();
            if (check == 1) {
                buf.append("revert");
                this.appendPriority(buf, important);
                return 0;
            }
            if (check == 2) {
                return 1;
            }
            if (!this.appendBackgroundImage(buf, this.bgimage)) {
                return 1;
            }
            if (!this.appendSingleLayer(buf, declaredSet)) {
                return 1;
            }
            if (!this.appended) {
                buf.append("none");
            }
        }
        this.appendPriority(buf, important);
        return 0;
    }

    private StyleValue computeMultipleSubproperty(String masterProperty, String propertyName) {
        return this.getParentStyle().computeBoundProperty(masterProperty, propertyName, this.getCSSValue(propertyName));
    }

    private byte checkForInherit() {
        return this.checkForInherit(this.bgimage, this.bgposition, this.bgsize, this.bgrepeat, this.bgattachment, this.bgclip, this.bgorigin, this.getCSSValue("background-color"));
    }

    private byte checkForInherit(StyleValue bimg, StyleValue bpos, StyleValue bsize, StyleValue brepeat, StyleValue battach, StyleValue bclip, StyleValue borigin, StyleValue bcolor) {
        byte check = this.checkForInherit(bimg, bpos, bsize, brepeat, battach, bclip, borigin);
        if (check == 2) {
            return 2;
        }
        if (this.isInherit(bcolor) ? check == 0 : check == 1) {
            return 2;
        }
        return check;
    }

    private byte checkForInherit(StyleValue bimg, StyleValue bpos, StyleValue bsize, StyleValue brepeat, StyleValue battach, StyleValue bclip, StyleValue borigin) {
        int count = 0;
        if (this.isInherit(bimg)) {
            count = (byte)(count + 1);
        }
        if (this.isInherit(bpos)) {
            count = (byte)(count + 1);
        }
        if (this.isInherit(bsize)) {
            count = (byte)(count + 1);
        }
        if (this.isInherit(brepeat)) {
            count = (byte)(count + 1);
        }
        if (this.isInherit(battach)) {
            count = (byte)(count + 1);
        }
        if (this.isInherit(bclip)) {
            count = (byte)(count + 1);
        }
        if (this.isInherit(borigin)) {
            count = (byte)(count + 1);
        }
        switch (count) {
            case 0: {
                return 0;
            }
            case 7: {
                return 1;
            }
        }
        return 2;
    }

    private byte checkForInherit(int layerIdx, int lastIndex) {
        if (layerIdx != lastIndex) {
            return this.checkForInherit(((ValueList)this.bgimage).item(layerIdx), ((ValueList)this.bgposition).item(layerIdx), ((ValueList)this.bgsize).item(layerIdx), ((ValueList)this.bgrepeat).item(layerIdx), ((ValueList)this.bgattachment).item(layerIdx), ((ValueList)this.bgclip).item(layerIdx), ((ValueList)this.bgorigin).item(layerIdx));
        }
        return this.checkForInherit(((ValueList)this.bgimage).item(layerIdx), ((ValueList)this.bgposition).item(layerIdx), ((ValueList)this.bgsize).item(layerIdx), ((ValueList)this.bgrepeat).item(layerIdx), ((ValueList)this.bgattachment).item(layerIdx), ((ValueList)this.bgclip).item(layerIdx), ((ValueList)this.bgorigin).item(layerIdx), this.getCSSValue("background-color"));
    }

    private byte checkForRevert() {
        return this.checkForCssKeyword(CSSValue.Type.REVERT);
    }

    private byte checkForCssKeyword(CSSValue.Type keyword) {
        int ucount = 0;
        if (BackgroundBuilder.isCssValueOfType(keyword, this.bgposition)) {
            ucount = (byte)(ucount + 1);
        }
        if (BackgroundBuilder.isCssValueOfType(keyword, this.bgsize)) {
            ucount = (byte)(ucount + 1);
        }
        if (BackgroundBuilder.isCssValueOfType(keyword, this.bgrepeat)) {
            ucount = (byte)(ucount + 1);
        }
        if (BackgroundBuilder.isCssValueOfType(keyword, this.bgattachment)) {
            ucount = (byte)(ucount + 1);
        }
        if (BackgroundBuilder.isCssValueOfType(keyword, this.bgclip)) {
            ucount = (byte)(ucount + 1);
        }
        if (BackgroundBuilder.isCssValueOfType(keyword, this.bgorigin)) {
            ucount = (byte)(ucount + 1);
        }
        if (BackgroundBuilder.isCssValueOfType(keyword, this.getCSSValue("background-color"))) {
            ucount = (byte)(ucount + 1);
        }
        switch (ucount) {
            case 0: {
                return 0;
            }
            case 7: {
                return 1;
            }
        }
        return 2;
    }

    private byte checkForRevert(int layerIdx, int lastIndex) {
        return this.checkForCssKeyword(CSSValue.Type.REVERT, layerIdx, lastIndex);
    }

    private byte checkForCssKeyword(CSSValue.Type keyword, int layerIdx, int lastIndex) {
        int fullset;
        int ucount = 0;
        if (BackgroundBuilder.isCssValueOfType(keyword, ((ValueList)this.bgposition).item(layerIdx))) {
            ucount = (byte)(ucount + 1);
        }
        if (BackgroundBuilder.isCssValueOfType(keyword, ((ValueList)this.bgsize).item(layerIdx))) {
            ucount = (byte)(ucount + 1);
        }
        if (BackgroundBuilder.isCssValueOfType(keyword, ((ValueList)this.bgrepeat).item(layerIdx))) {
            ucount = (byte)(ucount + 1);
        }
        if (BackgroundBuilder.isCssValueOfType(keyword, ((ValueList)this.bgattachment).item(layerIdx))) {
            ucount = (byte)(ucount + 1);
        }
        if (BackgroundBuilder.isCssValueOfType(keyword, ((ValueList)this.bgclip).item(layerIdx))) {
            ucount = (byte)(ucount + 1);
        }
        if (BackgroundBuilder.isCssValueOfType(keyword, ((ValueList)this.bgorigin).item(layerIdx))) {
            ucount = (byte)(ucount + 1);
        }
        if (layerIdx != lastIndex) {
            fullset = 6;
        } else {
            fullset = 7;
            if (BackgroundBuilder.isCssValueOfType(keyword, this.getCSSValue("background-color"))) {
                ucount = (byte)(ucount + 1);
            }
        }
        if (ucount == 0) {
            return 0;
        }
        if (ucount == fullset) {
            return 1;
        }
        return 2;
    }

    private static boolean isRevertValue(StyleValue cssValue) {
        return BackgroundBuilder.isCssValueOfType(CSSValue.Type.REVERT, cssValue);
    }

    private void appendText(StringBuilder buf, String text) {
        if (this.appended) {
            buf.append(' ');
        } else {
            this.appended = true;
        }
        buf.append(text);
    }

    private boolean appendLayeredBackground(StringBuilder buf, Set<String> declaredSet, int listlen) {
        int szm1 = listlen - 1;
        if (!this.appendLayer(buf, declaredSet, 0, szm1)) {
            return false;
        }
        for (int i = 1; i <= szm1; ++i) {
            this.appended = false;
            buf.append(',');
            if (this.appendLayer(buf, declaredSet, i, szm1)) continue;
            return false;
        }
        return true;
    }

    private boolean appendLayer(StringBuilder buf, Set<String> declaredSet, int index, int lastIndex) {
        StyleValue clip;
        StyleValue origin;
        StyleValue sizeval;
        byte check = this.checkForInherit(index, lastIndex);
        if (check == 1) {
            this.appendText(buf, "inherit");
            return true;
        }
        if (check == 2) {
            return false;
        }
        check = this.checkForRevert(index, lastIndex);
        if (check == 1) {
            this.appendText(buf, "revert");
            return true;
        }
        if (check == 2) {
            return false;
        }
        if (declaredSet.contains("background-image") && !this.appendBackgroundImage(buf, ((ValueList)this.bgimage).item(index))) {
            return false;
        }
        ValueList list = (ValueList)this.bgposition;
        StyleValue posval = declaredSet.contains("background-position") ? list.item(index) : null;
        if (!this.appendBackgroundPositionSize(buf, posval, sizeval = declaredSet.contains("background-size") ? ((ValueList)this.bgsize).item(index) : null)) {
            return false;
        }
        if (declaredSet.contains("background-repeat") && !this.appendBackgroundRepeat(buf, ((ValueList)this.bgrepeat).item(index))) {
            return false;
        }
        if (declaredSet.contains("background-attachment") && !this.appendBackgroundAttachment(buf, (list = (ValueList)this.bgattachment).item(index))) {
            return false;
        }
        boolean bcset = declaredSet.contains("background-clip");
        if ((declaredSet.contains("background-origin") || bcset) && !this.appendBackgroundOriginClip(buf, origin = ((ValueList)this.bgorigin).item(index), clip = bcset ? ((ValueList)this.bgclip).item(index) : null)) {
            return false;
        }
        if (declaredSet.contains("background-color") && index == lastIndex && !this.appendBackgroundColor(buf, this.getCSSValue("background-color"))) {
            return false;
        }
        int buflen = buf.length();
        if (buflen == 11 || buf.charAt(buflen - 1) == ',') {
            buf.append("none");
        }
        return true;
    }

    private boolean appendSingleLayer(StringBuilder buf, Set<String> declaredSet) {
        StyleValue clip;
        StyleValue origin;
        StyleValue sizeval;
        StyleValue posval = declaredSet.contains("background-position") ? this.valueOrFirstItem(this.bgposition) : null;
        if (!this.appendBackgroundPositionSize(buf, posval, sizeval = declaredSet.contains("background-size") ? this.valueOrFirstItem(this.bgsize) : null)) {
            return false;
        }
        if (declaredSet.contains("background-repeat") && !this.appendBackgroundRepeat(buf, this.valueOrFirstItem(this.bgrepeat))) {
            return false;
        }
        if (declaredSet.contains("background-attachment") && !this.appendBackgroundAttachment(buf, this.valueOrFirstItem(this.bgattachment))) {
            return false;
        }
        boolean bcset = declaredSet.contains("background-clip");
        if ((declaredSet.contains("background-origin") || bcset) && !this.appendBackgroundOriginClip(buf, origin = this.valueOrFirstItem(this.bgorigin), clip = bcset ? this.valueOrFirstItem(this.bgclip) : null)) {
            return false;
        }
        if (declaredSet.contains("background-color")) {
            StyleValue value = this.getCSSValue("background-color");
            if (value.getCssValueType() == CSSValue.CssType.LIST) {
                return false;
            }
            return this.appendBackgroundColor(buf, value);
        }
        return true;
    }

    private StyleValue valueOrFirstItem(StyleValue value) {
        ValueList list;
        if (value.getCssValueType() == CSSValue.CssType.LIST && (list = (ValueList)value).isCommaSeparated()) {
            return list.item(0);
        }
        return value;
    }

    private boolean appendBackgroundImage(StringBuilder buf, StyleValue value) {
        if (!BackgroundBuilder.isRevertValue(value) && this.possibleBackgroundImage(value)) {
            this.appended = this.appendImage(buf, this.appended, value);
            return true;
        }
        return false;
    }

    private boolean possibleBackgroundImage(StyleValue value) {
        CSSValue.CssType category = value.getCssValueType();
        if (category == CSSValue.CssType.TYPED) {
            TypedValue primi = (TypedValue)value;
            CSSValue.Type type = primi.getPrimitiveType();
            if (type == CSSValue.Type.IDENT) {
                String s = primi.getStringValue();
                return "none".equalsIgnoreCase(s);
            }
            return BackgroundBuilder.isImagePrimitiveValue(primi);
        }
        return category == CSSValue.CssType.KEYWORD;
    }

    private boolean appendBackgroundPositionSize(StringBuilder buf, StyleValue posvalue, StyleValue sizevalue) {
        boolean appended = false;
        if (posvalue != null) {
            CSSValue.CssType type = posvalue.getCssValueType();
            String text = posvalue.getCssText().toLowerCase(Locale.ROOT);
            if (BackgroundBuilder.isRevertValue(posvalue)) {
                return false;
            }
            if (type == CSSValue.CssType.TYPED) {
                if ((posvalue.getPrimitiveType() != CSSValue.Type.IDENT || BackgroundBuilder.isUnknownIdentifier("background-position", posvalue)) && posvalue.matches(lengthPercentage) != CSSValueSyntax.Match.TRUE) {
                    return false;
                }
                this.appendText(buf, text);
                appended = true;
            } else if (type == CSSValue.CssType.LIST) {
                ValueList list = (ValueList)posvalue;
                if (list.isCommaSeparated() || text.indexOf(92) != -1) {
                    return false;
                }
                if (!("0% 0%".equals(text) || "left top".equals(text) || "top left".equals(text))) {
                    if (list.getLength() != 2 || !"center".equalsIgnoreCase(list.item(1).getCssText())) {
                        this.appendText(buf, text);
                    } else {
                        this.appendText(buf, list.item(0).getCssText());
                    }
                    appended = true;
                }
            } else if (type == CSSValue.CssType.PROXY) {
                return false;
            }
        }
        if (sizevalue != null) {
            if (BackgroundBuilder.isRevertValue(sizevalue) || BackgroundBuilder.isUnknownIdentifier("background-size", sizevalue) || sizevalue.getCssValueType() == CSSValue.CssType.PROXY) {
                return false;
            }
            String text = sizevalue.getMinifiedCssText().toLowerCase(Locale.ROOT);
            if (!("auto".equals(text) || "auto auto".equals(text) || "initial".equals(text) || "unset".equals(text))) {
                if (!appended) {
                    if (posvalue == null) {
                        posvalue = this.getCSSValue("background-position");
                    }
                    this.appendText(buf, posvalue.getMinifiedCssText());
                }
                buf.append('/').append(text);
                appended = true;
            }
        }
        if (appended) {
            this.appended = true;
        }
        return true;
    }

    private boolean appendBackgroundRepeat(StringBuilder buf, StyleValue value) {
        CSSValue.CssType type = value.getCssValueType();
        String text = value.getCssText().toLowerCase(Locale.ROOT);
        if (!BackgroundBuilder.isIdentOrKeyword(value) || BackgroundBuilder.isRevertValue(value) || text.indexOf(92) != -1) {
            return false;
        }
        if (type == CSSValue.CssType.TYPED) {
            if (!"repeat".equals(text)) {
                this.appendText(buf, text);
            }
        } else if (type == CSSValue.CssType.LIST) {
            ValueList list = (ValueList)value;
            if (list.isCommaSeparated()) {
                return false;
            }
            if (!"repeat repeat".equals(text)) {
                if ("no-repeat no-repeat".equals(text)) {
                    this.appendText(buf, "no-repeat");
                } else if ("space space".equals(text)) {
                    this.appendText(buf, "space");
                } else if ("round round".equals(text)) {
                    this.appendText(buf, "round");
                } else if ("repeat no-repeat".equals(text)) {
                    this.appendText(buf, "repeat-x");
                } else if ("no-repeat repeat".equals(text)) {
                    this.appendText(buf, "repeat-y");
                } else {
                    this.appendText(buf, text);
                }
            }
        }
        return true;
    }

    private boolean appendBackgroundAttachment(StringBuilder buf, StyleValue value) {
        if (BackgroundBuilder.isIdentOrKeyword(value) && !BackgroundBuilder.isRevertValue(value) && !BackgroundBuilder.isUnknownIdentifier("background-attachment", value)) {
            String text = value.getMinifiedCssText().toLowerCase(Locale.ROOT);
            if (!("scroll".equals(text) || "initial".equals(text) || "unset".equals(text))) {
                this.appendText(buf, text);
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean appendBackgroundOriginClip(StringBuilder buf, StyleValue origin, StyleValue clip) {
        String originText;
        boolean originIsInitial;
        String clipText;
        boolean clipIsInitial;
        block14: {
            block15: {
                block13: {
                    block11: {
                        block12: {
                            block10: {
                                if (clip != null) break block10;
                                clipIsInitial = true;
                                clipText = "border-box";
                                break block11;
                            }
                            if (clip.getCssValueType() != CSSValue.CssType.KEYWORD) break block12;
                            switch (clip.getPrimitiveType()) {
                                case INITIAL: 
                                case UNSET: {
                                    clipIsInitial = true;
                                    clipText = "border-box";
                                    break block11;
                                }
                                default: {
                                    return false;
                                }
                            }
                        }
                        clipText = clip.getMinifiedCssText().toLowerCase(Locale.ROOT);
                        clipIsInitial = "border-box".equals(clipText);
                    }
                    if (origin != null) break block13;
                    originIsInitial = true;
                    originText = "padding-box";
                    break block14;
                }
                if (origin.getCssValueType() != CSSValue.CssType.KEYWORD) break block15;
                switch (origin.getPrimitiveType()) {
                    case INITIAL: 
                    case UNSET: {
                        originIsInitial = true;
                        originText = "padding-box";
                        break block14;
                    }
                    default: {
                        return false;
                    }
                }
            }
            originText = origin.getMinifiedCssText().toLowerCase(Locale.ROOT);
            originIsInitial = "padding-box".equals(originText);
        }
        if (!originIsInitial || !clipIsInitial) {
            if (BackgroundBuilder.getShorthandDatabase().isIdentifierValue("background-origin", originText) && BackgroundBuilder.getShorthandDatabase().isIdentifierValue("background-clip", clipText)) {
                this.appendText(buf, originText);
                if (!originText.equals(clipText)) {
                    this.appendText(buf, clipText);
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private boolean appendBackgroundColor(StringBuilder buf, StyleValue value) {
        if (!BackgroundBuilder.isRevertValue(value) && BackgroundBuilder.isValidColor(value)) {
            String text;
            StringBuilder sb = new StringBuilder();
            BufferSimpleWriter wri = new BufferSimpleWriter(sb);
            DeclarationFormattingContext context = this.getParentStyle().getFormattingContext();
            try {
                context.writeMinifiedValue((SimpleWriter)wri, "background-color", value);
                text = sb.toString().toLowerCase(Locale.ROOT);
            }
            catch (Exception e) {
                text = value.getMinifiedCssText().toLowerCase(Locale.ROOT);
            }
            if (!("transparent".equals(text) || "rgba(0,0,0,0)".equals(text) || "rgb(0 0 0/0)".equals(text) || "initial".equals(text) || "unset".equals(text))) {
                this.appendText(buf, text);
            }
        } else {
            return false;
        }
        return true;
    }

    private static boolean isValidColor(CSSValue value) {
        CSSValue.CssType category = value.getCssValueType();
        if (category == CSSValue.CssType.TYPED) {
            CSSTypedValue primi = (CSSTypedValue)value;
            CSSValue.Type ptype = primi.getPrimitiveType();
            if (ptype == CSSValue.Type.COLOR || ptype == CSSValue.Type.COLOR_MIX) {
                return true;
            }
            if (ptype == CSSValue.Type.IDENT) {
                String s = primi.getStringValue().toLowerCase(Locale.ROOT);
                return ColorIdentifiers.getInstance().isColorIdentifier(s);
            }
        } else {
            return value.getCssValueType() == CSSValue.CssType.KEYWORD;
        }
        return false;
    }
}

