# frozen_string_literal: true

class AddNewUuidToVulnerabilityOccurrences < Gitlab::Database::Migration[2.3]
  milestone '18.5'

  disable_ddl_transaction!

  def up
    with_lock_retries do
      add_column :vulnerability_occurrences, :new_uuid, :uuid, if_not_exists: true # rubocop:disable Migration/PreventAddingColumns -- https://gitlab.com/gitlab-org/database-team/team-tasks/-/issues/543
    end
  end

  def down
    with_lock_retries do
      remove_column :vulnerability_occurrences, :new_uuid, if_exists: true
    end
  end
end
