# frozen_string_literal: true

class FinalizeHkBackfillPackagesNugetMetadataProjectId < Gitlab::Database::Migration[2.2]
  milestone '17.11'

  disable_ddl_transaction!

  restrict_gitlab_migration gitlab_schema: :gitlab_main_org

  def up
    ensure_batched_background_migration_is_finished(
      job_class_name: 'BackfillPackagesNugetMetadataProjectId',
      table_name: :packages_nuget_metadata,
      column_name: :package_id,
      job_arguments: [:project_id, :packages_packages, :project_id, :package_id],
      finalize: true
    )
  end

  def down; end
end
