---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token GitLab runner authentication token'
---

## Description

The response body contains content that matches the pattern of a GitLab Runner authentication token was identified. These tokens allow users to register or authenticate as a runner with the selected project. A malicious actor with access to this token can add a custom runner to the pipeline and possibly compromise the repository if the runner was used.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).

To revoke a runner authentication token, the runner needs to be removed and re-created:

- Sign in to your GitLab account and visit the project that created the runner registration token
- In the left-hand menu, select "Settings"
- Under the "Settings" options, select "CI/CD"
- Under the "Runners" section, find the runner with the identified token, (you can check the runner `config.toml` if you are unsure)
- Select "Remove runner"
- When prompted, select "Remove"

For more information, please see [GitLabs documentation on registering runners](https://docs.gitlab.com/runner/register/).

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.144 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
