#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 glirc
version:              2.40.1
visibility:           public
id:                   glirc-2.40.1-KTxJzwK4zbC6YZPxI6vvEV
key:                  glirc-2.40.1-KTxJzwK4zbC6YZPxI6vvEV
license:              ISC
copyright:            2016-2019 Eric Mertens
maintainer:           emertens@gmail.com
author:               Eric Mertens
homepage:             https://github.com/glguy/irc-core
synopsis:             Console IRC client
description:
    Console IRC client

    glirc is a console IRC client with an emphasis on providing
    dynamic views into the model of your IRC connections.

    <https://github.com/glguy/irc-core/wiki Documentation Wiki>

category:             Network
abi:                  bda33d94a94055c5b7a58ee9ae76e149
exposed:              True
exposed-modules:
    Client.Authentication.Ecdh Client.Authentication.Ecdsa
    Client.Authentication.Scram Client.CApi Client.CApi.Exports
    Client.CApi.Types Client.Commands Client.Commands.Arguments.Parser
    Client.Commands.Arguments.Renderer Client.Commands.Arguments.Spec
    Client.Commands.Certificate Client.Commands.Channel
    Client.Commands.Chat Client.Commands.Connection
    Client.Commands.Docs Client.Commands.Exec
    Client.Commands.Interpolation Client.Commands.Operator
    Client.Commands.Queries Client.Commands.Recognizer
    Client.Commands.TabCompletion Client.Commands.Toggles
    Client.Commands.Types Client.Commands.Window
    Client.Commands.WordCompletion Client.Commands.ZNC
    Client.Configuration Client.Configuration.Colors
    Client.Configuration.Macros Client.Configuration.Notifications
    Client.Configuration.ServerSettings Client.Configuration.Sts
    Client.Docs Client.EventLoop Client.EventLoop.Actions
    Client.EventLoop.Errors Client.EventLoop.Network Client.Hook
    Client.Hook.DroneBLRelay Client.Hook.Matterbridge
    Client.Hook.Snotice Client.Hook.Znc.Buffextras Client.Hooks
    Client.Image Client.Image.Layout Client.Image.LineWrap
    Client.Image.Message Client.Image.MircFormatting
    Client.Image.PackedImage Client.Image.Palette
    Client.Image.StatusLine Client.Image.Textbox Client.Log Client.Mask
    Client.Message Client.Network.Async Client.Network.Connect
    Client.Options Client.State Client.State.Channel
    Client.State.EditBox Client.State.EditBox.Content
    Client.State.Extensions Client.State.Focus Client.State.Network
    Client.State.Url Client.State.Window Client.UserHost Client.View
    Client.View.Cert Client.View.ChannelInfo Client.View.ChannelList
    Client.View.Digraphs Client.View.Help Client.View.IgnoreList
    Client.View.KeyMap Client.View.MaskList Client.View.Mentions
    Client.View.Messages Client.View.Palette Client.View.RtsStats
    Client.View.UrlSelection Client.View.UserList Client.View.Who
    Client.View.Windows Client.WhoReply

hidden-modules:
    ContextFilter DigraphQuote Digraphs LensUtils RtsStats StrQuote
    StrictUnit Paths_glirc Build_glirc

import-dirs:          /usr/lib/ghc-9.4.8/site-local/glirc-2.40.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/glirc-2.40.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/glirc-2.40.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/glirc
hs-libraries:         HSglirc-2.40.1-KTxJzwK4zbC6YZPxI6vvEV
include-dirs:         /usr/lib/ghc-9.4.8/site-local/glirc-2.40.1/include
includes:             include/glirc-api.h
depends:
    HsOpenSSL-0.11.7.9-2dJWTXbGJ2o2w7V8hugDcS
    async-2.2.5-JCyrUQO4ybIvbhfv5Zh73
    attoparsec-0.14.4-263Fn5MXyjqGBhD6CjKCLb base-4.17.2.1
    base64-bytestring-1.2.1.0-LNkxyXoRMflHvQaufiNrDL
    bytestring-0.11.5.3 config-schema-1.3.0.0-2osLxBjFMKS5sPVaD5my2v
    config-value-0.8.3-AwfdtSmE9Y1aqPSXDWTLH containers-0.6.7
    curve25519-0.2.8.1-HwUwCA7v43k4SK6poKq3Wx directory-1.3.7.1
    filepath-1.4.2.2 free-5.2-FO2Q20euwXcCdGr9UaAYL8
    githash-0.1.6.3-5nQf0PyKAyv5qIlWDyr7Nf
    hashable-1.4.6.0-HsdqsQ7iDyd40AcboGWr8K
    hookup-0.8-9b5plxLSbOBD4V04x3z2v5
    irc-core-2.12-ESWjv72PcdEDXlESBWvBRB
    kan-extensions-5.2.7-8DQzjHReP0qSMILtAL0Yt
    lens-5.3.2-Gri7akg07hN4ZkbavAwqWU
    network-3.1.4.0-4q2nDdk2jYz5m5sp4PhmqQ
    psqueues-0.2.8.2-EPn97RMztrUF0ZPYb3MWTl
    random-1.2.1.3-En8KGuEyE1eKrUFL64LDNm
    regex-tdfa-1.3.2.4-Ehlt0m2SBCjGyOeVQxYb9I
    semigroupoids-6.0.1-ALhEB1ekwQkFChjKmHdaGN
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q stm-2.5.1.0
    template-haskell-2.19.0.0 text-2.0.2 time-1.12.2
    transformers-0.5.6.2 typed-process-0.2.13.0-GsXd50XPYraENyqCP1rVq5
    unix-2.7.3 unordered-containers-0.2.20-DjNgsRwGYvfHy5WsKzKUzR
    vector-0.13.2.0-FmAyOUuMvM2EH0h3dDhWXJ
    vty-6.2-IBAqICm9nwD7gxtHhupznL

haddock-interfaces:   /usr/share/doc/glirc/html/glirc.haddock
haddock-html:         /usr/share/doc/glirc/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

