/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Label pixels that are connected to a seed and lie within a range of values.


ConnectedThresholdImageFilter labels pixels with ReplaceValue that are connected to an initial Seed
AND lie within a Lower and Upper threshold range.
See:
 itk::simple::ConnectedThreshold for the procedural interface

 itk::ConnectedThresholdImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkConnectedThresholdImageFilter.h
*/
public class ConnectedThresholdImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected ConnectedThresholdImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.ConnectedThresholdImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(ConnectedThresholdImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(ConnectedThresholdImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::ConnectedThresholdImageFilter::~ConnectedThresholdImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_ConnectedThresholdImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::ConnectedThresholdImageFilter::ConnectedThresholdImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  ConnectedThresholdImageFilter() {
    this(SimpleITKJNI.new_ConnectedThresholdImageFilter(), true);
  }

  /**
Self&amp; itk::simple::ConnectedThresholdImageFilter::SetSeedList(std::vector&lt; std::vector&lt; unsigned int &gt; &gt; SeedList)

Set list of image indexes for seeds.

*/
public  void setSeedList(VectorUIntList SeedList) {
    SimpleITKJNI.ConnectedThresholdImageFilter_setSeedList(swigCPtr, this, VectorUIntList.getCPtr(SeedList), SeedList);
  }

  /**
std::vector&lt; std::vector&lt; unsigned int &gt; &gt; itk::simple::ConnectedThresholdImageFilter::GetSeedList() const

Get list of seeds.

*/
public  VectorUIntList getSeedList() {
    return new VectorUIntList(SimpleITKJNI.ConnectedThresholdImageFilter_getSeedList(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::ConnectedThresholdImageFilter::AddSeed(std::vector&lt; unsigned int &gt; point)

Add SeedList point.

*/
public  void addSeed(VectorUInt32 point) {
    SimpleITKJNI.ConnectedThresholdImageFilter_addSeed(swigCPtr, this, VectorUInt32.getCPtr(point), point);
  }

  /**
Self&amp; itk::simple::ConnectedThresholdImageFilter::ClearSeeds()

Remove all SeedList points.

*/
public  void clearSeeds() {
    SimpleITKJNI.ConnectedThresholdImageFilter_clearSeeds(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ConnectedThresholdImageFilter::SetLower(double Lower)

Set Upper and Lower Threshold inputs as values

*/
public  void setLower(double Lower) {
    SimpleITKJNI.ConnectedThresholdImageFilter_setLower(swigCPtr, this, Lower);
  }

  /**
double itk::simple::ConnectedThresholdImageFilter::GetLower() const

Get Upper and Lower Threshold inputs as values.

*/
public  double getLower() {
    return SimpleITKJNI.ConnectedThresholdImageFilter_getLower(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ConnectedThresholdImageFilter::SetUpper(double Upper)

Set Upper and Lower Threshold inputs as values

*/
public  void setUpper(double Upper) {
    SimpleITKJNI.ConnectedThresholdImageFilter_setUpper(swigCPtr, this, Upper);
  }

  /**
double itk::simple::ConnectedThresholdImageFilter::GetUpper() const

Get Upper and Lower Threshold inputs as values.

*/
public  double getUpper() {
    return SimpleITKJNI.ConnectedThresholdImageFilter_getUpper(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ConnectedThresholdImageFilter::SetReplaceValue(uint8_t ReplaceValue)

Set/Get value to replace thresholded pixels. Pixels that lie * within
Lower and Upper (inclusive) will be replaced with this value. The
default is 1.

*/
public  void setReplaceValue(short ReplaceValue) {
    SimpleITKJNI.ConnectedThresholdImageFilter_setReplaceValue(swigCPtr, this, ReplaceValue);
  }

  /**
uint8_t itk::simple::ConnectedThresholdImageFilter::GetReplaceValue() const

Set/Get value to replace thresholded pixels. Pixels that lie * within
Lower and Upper (inclusive) will be replaced with this value. The
default is 1.

*/
public  short getReplaceValue() {
    return SimpleITKJNI.ConnectedThresholdImageFilter_getReplaceValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ConnectedThresholdImageFilter::SetConnectivity(ConnectivityType Connectivity)

Type of connectivity to use (fully connected OR 4(2D), 6(3D), 2*N(ND)
connectivity).

*/
public  void setConnectivity(ConnectedThresholdImageFilter.ConnectivityType Connectivity) {
    SimpleITKJNI.ConnectedThresholdImageFilter_setConnectivity(swigCPtr, this, Connectivity.swigValue());
  }

  /**
ConnectivityType itk::simple::ConnectedThresholdImageFilter::GetConnectivity() const

Type of connectivity to use (fully connected OR 4(2D), 6(3D), 2*N(ND)
connectivity).

*/
public  ConnectedThresholdImageFilter.ConnectivityType getConnectivity() {
    return ConnectedThresholdImageFilter.ConnectivityType.swigToEnum(SimpleITKJNI.ConnectedThresholdImageFilter_getConnectivity(swigCPtr, this));
  }

  /**
std::string itk::simple::ConnectedThresholdImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.ConnectedThresholdImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::ConnectedThresholdImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.ConnectedThresholdImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::ConnectedThresholdImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.ConnectedThresholdImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

  public final static class ConnectivityType {
    public final static ConnectedThresholdImageFilter.ConnectivityType FaceConnectivity = new ConnectedThresholdImageFilter.ConnectivityType("FaceConnectivity");
    public final static ConnectedThresholdImageFilter.ConnectivityType FullConnectivity = new ConnectedThresholdImageFilter.ConnectivityType("FullConnectivity");

    public final int swigValue() {
      return swigValue;
    }

    public String toString() {
      return swigName;
    }

    public static ConnectivityType swigToEnum(int swigValue) {
      if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue)
        return swigValues[swigValue];
      for (int i = 0; i < swigValues.length; i++)
        if (swigValues[i].swigValue == swigValue)
          return swigValues[i];
      throw new IllegalArgumentException("No enum " + ConnectivityType.class + " with value " + swigValue);
    }

    private ConnectivityType(String swigName) {
      this.swigName = swigName;
      this.swigValue = swigNext++;
    }

    private ConnectivityType(String swigName, int swigValue) {
      this.swigName = swigName;
      this.swigValue = swigValue;
      swigNext = swigValue+1;
    }

    private ConnectivityType(String swigName, ConnectivityType swigEnum) {
      this.swigName = swigName;
      this.swigValue = swigEnum.swigValue;
      swigNext = this.swigValue+1;
    }

    private static ConnectivityType[] swigValues = { FaceConnectivity, FullConnectivity };
    private static int swigNext = 0;
    private final int swigValue;
    private final String swigName;
  }

}
