/*
 * Decompiled with CFR 0.152.
 */
package io.github.dan2097.jnarinchi;

import io.github.dan2097.jnainchi.InchiAtom;
import io.github.dan2097.jnainchi.InchiBond;
import io.github.dan2097.jnainchi.InchiBondStereo;
import io.github.dan2097.jnainchi.InchiInput;
import io.github.dan2097.jnainchi.InchiRadical;
import io.github.dan2097.jnainchi.InchiStereo;
import io.github.dan2097.jnarinchi.ReactionComponentRole;
import java.util.ArrayList;
import java.util.List;

public class RinchiInputComponent
extends InchiInput {
    private ReactionComponentRole role = ReactionComponentRole.REAGENT;

    public ReactionComponentRole getRole() {
        return this.role;
    }

    public void setRole(ReactionComponentRole role) {
        this.role = role;
    }

    public List<InchiAtom> getConnectedAtomList(InchiAtom atom) {
        if (atom == null) {
            return null;
        }
        ArrayList<InchiAtom> list = new ArrayList<InchiAtom>();
        for (int i = 0; i < this.getBonds().size(); ++i) {
            InchiBond bond = this.getBond(i);
            if (bond.getStart() == atom) {
                list.add(bond.getEnd());
                continue;
            }
            if (bond.getEnd() != atom) continue;
            list.add(bond.getStart());
        }
        return list;
    }

    public InchiBond getBond(InchiAtom atom1, InchiAtom atom2) {
        for (int i = 0; i < this.getBonds().size(); ++i) {
            InchiBond bond = this.getBond(i);
            if ((bond.getStart() != atom1 || bond.getEnd() != atom2) && (bond.getStart() != atom2 || bond.getEnd() != atom1)) continue;
            return bond;
        }
        return null;
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("  Atoms:").append("\n");
        for (i = 0; i < this.getAtoms().size(); ++i) {
            sb.append("    ").append(this.atomToString(i)).append("\n");
        }
        if (!this.getBonds().isEmpty()) {
            sb.append("  Bonds:").append("\n");
        }
        for (i = 0; i < this.getBonds().size(); ++i) {
            sb.append("    ").append(this.bondToString(i)).append("\n");
        }
        if (!this.getStereos().isEmpty()) {
            sb.append("  Stereos:").append("\n");
        }
        for (i = 0; i < this.getStereos().size(); ++i) {
            sb.append("    ").append(this.stereoToString(i)).append("\n");
        }
        return sb.toString();
    }

    private String atomToString(int i) {
        InchiAtom atom = this.getAtom(i);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(i + 1).append(" ").append(atom.getElName());
        if (atom.getImplicitHydrogen() != 0) {
            stringBuilder.append(" H").append(atom.getImplicitHydrogen());
        } else {
            stringBuilder.append("   ");
        }
        stringBuilder.append("  ").append(atom.getX()).append("  ").append(atom.getY()).append("  ").append(atom.getZ());
        if (atom.getCharge() != 0) {
            stringBuilder.append(" ").append(atom.getCharge());
        }
        if (atom.getIsotopicMass() != 0) {
            stringBuilder.append(" iso ").append(atom.getIsotopicMass());
        }
        if (atom.getRadical() != InchiRadical.NONE) {
            stringBuilder.append("  radical ").append((Object)atom.getRadical());
        }
        return stringBuilder.toString();
    }

    private String bondToString(int i) {
        InchiBond bond = this.getBond(i);
        int atomIndex1 = this.getAtoms().indexOf(bond.getStart()) + 1;
        int atomIndex2 = this.getAtoms().indexOf(bond.getEnd()) + 1;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(atomIndex1).append(" ").append(atomIndex2).append(" ").append((Object)bond.getType());
        if (bond.getStereo() != InchiBondStereo.NONE) {
            stringBuilder.append("  stereo ").append((Object)bond.getStereo());
        }
        return stringBuilder.toString();
    }

    private String stereoToString(int atIndex) {
        InchiStereo stereo = this.getStereos().get(atIndex);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(stereo.getType().toString()).append(": ");
        switch (stereo.getType()) {
            case Tetrahedral: {
                stringBuilder.append("center ").append(this.getAtoms().indexOf(stereo.getCentralAtom()) + 1);
                stringBuilder.append(" ligands");
                for (int i = 0; i < 4; ++i) {
                    stringBuilder.append(" ").append(this.getAtoms().indexOf(stereo.getAtoms()[i]) + 1);
                }
                break;
            }
            case DoubleBond: {
                stringBuilder.append(" ");
                stringBuilder.append(this.getAtoms().indexOf(stereo.getAtoms()[0]) + 1).append(" - ");
                stringBuilder.append(this.getAtoms().indexOf(stereo.getAtoms()[1]) + 1).append(" = ");
                stringBuilder.append(this.getAtoms().indexOf(stereo.getAtoms()[2]) + 1).append(" - ");
                stringBuilder.append(this.getAtoms().indexOf(stereo.getAtoms()[3]) + 1);
                break;
            }
            case Allene: {
                stringBuilder.append(" ");
                stringBuilder.append(this.getAtoms().indexOf(stereo.getAtoms()[0]) + 1).append(" - ");
                stringBuilder.append(this.getAtoms().indexOf(stereo.getAtoms()[1]) + 1).append(" = ");
                stringBuilder.append(this.getAtoms().indexOf(stereo.getCentralAtom()) + 1).append(" = ");
                stringBuilder.append(this.getAtoms().indexOf(stereo.getAtoms()[2]) + 1).append(" - ");
                stringBuilder.append(this.getAtoms().indexOf(stereo.getAtoms()[3]) + 1);
                break;
            }
        }
        stringBuilder.append("  ").append((Object)stereo.getParity());
        return stringBuilder.toString();
    }
}

