/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.utils;

import java.io.Console;
import java.util.Optional;

public final class Prompt {
    private Prompt() {
    }

    public static boolean yesOrNo(boolean defaultValue, String prompt, String ... args) {
        String choices = defaultValue ? " (Y/n)" : " (y/N)";
        String optionalQuestionMark = prompt.matches(".*\\?\\s*$") ? " " : " ? ";
        try {
            String response;
            do {
                Optional<Console> console;
                if ((response = (console = Optional.ofNullable(System.console())).map(c -> c.readLine(prompt + choices + optionalQuestionMark, args).trim().toLowerCase()).orElse(defaultValue ? "y" : "n")).isBlank()) {
                    return defaultValue;
                }
                if (!response.equals("y") && !response.equals("yes")) continue;
                return true;
            } while (!response.equals("n") && !response.equals("no"));
            return false;
        }
        catch (Exception ignore) {
            return defaultValue;
        }
    }
}

