/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.insert;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.engine.jdbc.mutation.JdbcValueBindings;
import org.hibernate.engine.jdbc.mutation.group.PreparedStatementDetails;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.EventType;
import org.hibernate.generator.values.AbstractGeneratedValuesMutationDelegate;
import org.hibernate.generator.values.GeneratedValues;
import org.hibernate.id.PostInsertIdentityPersister;
import org.hibernate.id.insert.Binder;
import org.hibernate.id.insert.InsertGeneratedIdentifierDelegate;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;

public abstract class AbstractReturningDelegate
extends AbstractGeneratedValuesMutationDelegate
implements InsertGeneratedIdentifierDelegate {
    @Deprecated(forRemoval=true, since="6.5")
    public AbstractReturningDelegate(PostInsertIdentityPersister persister) {
        super(persister, EventType.INSERT);
    }

    public AbstractReturningDelegate(EntityPersister persister, EventType timing, boolean supportsArbitraryValues, boolean supportsRowId) {
        super(persister, timing, supportsArbitraryValues, supportsRowId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GeneratedValues performMutation(PreparedStatementDetails statementDetails, JdbcValueBindings valueBindings, Object entity, SharedSessionContractImplementor session) {
        session.getJdbcServices().getSqlStatementLogger().logStatement(statementDetails.getSqlString());
        try {
            valueBindings.beforeStatement(statementDetails);
            GeneratedValues generatedValues = this.executeAndExtractReturning(statementDetails.getSqlString(), statementDetails.getStatement(), session);
            return generatedValues;
        }
        finally {
            if (statementDetails.getStatement() != null) {
                statementDetails.releaseStatement(session);
            }
            valueBindings.afterStatement(statementDetails.getMutatingTableDetails());
            session.getJdbcCoordinator().afterStatementExecution();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final GeneratedValues performInsertReturning(String sql, SharedSessionContractImplementor session, Binder binder) {
        PreparedStatement insert = this.prepareStatement(sql, session);
        try {
            binder.bindValues(insert);
            GeneratedValues generatedValues = this.executeAndExtractReturning(sql, insert, session);
            this.releaseStatement(insert, session);
            return generatedValues;
        }
        catch (Throwable throwable) {
            try {
                this.releaseStatement(insert, session);
                throw throwable;
            }
            catch (SQLException sqle) {
                throw session.getJdbcServices().getSqlExceptionHelper().convert(sqle, "could not insert: " + MessageHelper.infoString(this.persister), sql);
            }
        }
    }

    @Deprecated(forRemoval=true, since="6.5")
    protected Object executeAndExtract(String sql, PreparedStatement preparedStatement, SharedSessionContractImplementor session) {
        GeneratedValues generatedValues = this.executeAndExtractReturning(sql, preparedStatement, session);
        return generatedValues.getGeneratedValue(this.persister.getIdentifierMapping());
    }

    protected abstract GeneratedValues executeAndExtractReturning(String var1, PreparedStatement var2, SharedSessionContractImplementor var3);

    protected void releaseStatement(PreparedStatement preparedStatement, SharedSessionContractImplementor session) {
        JdbcCoordinator jdbcCoordinator = session.getJdbcCoordinator();
        jdbcCoordinator.getLogicalConnection().getResourceRegistry().release(preparedStatement);
        jdbcCoordinator.afterStatementExecution();
    }
}

