/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity.internal;

import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.FetchNotFoundException;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.bytecode.enhance.spi.interceptor.LazyAttributeLoadingInterceptor;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.spi.EntityHolder;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.EntityUniqueKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.spi.AppliedGraph;
import org.hibernate.graph.spi.AttributeNodeImplementor;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.InitializerData;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.graph.basic.BasicResultAssembler;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.entity.internal.EntityInitializerImpl;
import org.hibernate.sql.results.graph.internal.AbstractInitializer;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.type.Type;

public class EntityDelayedFetchInitializer
extends AbstractInitializer<EntityDelayedFetchInitializerData>
implements EntityInitializer<EntityDelayedFetchInitializerData> {
    private final InitializerParent<?> parent;
    private final NavigablePath navigablePath;
    private final boolean isPartOfKey;
    private final ToOneAttributeMapping referencedModelPart;
    private final boolean selectByUniqueKey;
    private final DomainResultAssembler<?> identifierAssembler;
    private final @Nullable BasicResultAssembler<?> discriminatorAssembler;
    private final boolean keyIsEager;
    private final boolean hasLazySubInitializer;

    public EntityDelayedFetchInitializer(InitializerParent<?> parent, NavigablePath fetchedNavigable, ToOneAttributeMapping referencedModelPart, boolean selectByUniqueKey, DomainResult<?> keyResult, @Nullable BasicFetch<?> discriminatorResult, AssemblerCreationState creationState) {
        super(creationState);
        Initializer<?> initializer;
        assert (!referencedModelPart.hasNotFoundAction() || referencedModelPart.getEntityMappingType().isConcreteProxy());
        this.parent = parent;
        this.navigablePath = fetchedNavigable;
        this.isPartOfKey = Initializer.isPartOfKey(fetchedNavigable, parent);
        this.referencedModelPart = referencedModelPart;
        this.selectByUniqueKey = selectByUniqueKey;
        this.identifierAssembler = keyResult.createResultAssembler(this, creationState);
        BasicResultAssembler<?> basicResultAssembler = this.discriminatorAssembler = discriminatorResult == null ? null : (BasicResultAssembler<?>)discriminatorResult.createResultAssembler(this, creationState);
        if (this.identifierAssembler == null || (initializer = this.identifierAssembler.getInitializer()) == null) {
            this.keyIsEager = false;
            this.hasLazySubInitializer = false;
        } else {
            this.keyIsEager = initializer.isEager();
            this.hasLazySubInitializer = !initializer.isEager() || initializer.hasLazySubInitializers();
        }
    }

    @Override
    protected InitializerData createInitializerData(RowProcessingState rowProcessingState) {
        return new EntityDelayedFetchInitializerData(rowProcessingState);
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public ModelPart getInitializedPart() {
        return this.referencedModelPart;
    }

    @Override
    public void resolveFromPreviousRow(EntityDelayedFetchInitializerData data) {
        if (data.getState() == Initializer.State.UNINITIALIZED) {
            if (data.getInstance() == null) {
                data.setState(Initializer.State.MISSING);
            } else {
                Initializer<?> initializer = this.identifierAssembler.getInitializer();
                if (initializer != null) {
                    initializer.resolveFromPreviousRow(data.getRowProcessingState());
                }
                data.setState(Initializer.State.INITIALIZED);
            }
        }
    }

    @Override
    public void resolveInstance(EntityDelayedFetchInitializerData data) {
        if (data.getState() != Initializer.State.KEY_RESOLVED) {
            return;
        }
        data.setState(Initializer.State.INITIALIZED);
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        data.entityIdentifier = this.identifierAssembler.assemble(rowProcessingState);
        if (data.entityIdentifier == null) {
            data.setInstance(null);
            data.setState(Initializer.State.MISSING);
        } else {
            EntityPersister concreteDescriptor;
            SharedSessionContractImplementor session = rowProcessingState.getSession();
            EntityPersister entityPersister = this.getEntityDescriptor();
            if (this.discriminatorAssembler != null) {
                concreteDescriptor = EntityInitializerImpl.determineConcreteEntityDescriptor(rowProcessingState, this.discriminatorAssembler, entityPersister);
                if (concreteDescriptor == null) {
                    if (!this.referencedModelPart.isOptional()) {
                        throw new FetchNotFoundException(entityPersister.getEntityName(), data.entityIdentifier);
                    }
                    data.setInstance(null);
                    data.setState(Initializer.State.MISSING);
                    return;
                }
            } else {
                concreteDescriptor = entityPersister;
            }
            PersistenceContext persistenceContext = session.getPersistenceContextInternal();
            if (this.selectByUniqueKey) {
                String uniqueKeyPropertyName = this.referencedModelPart.getReferencedPropertyName();
                Type uniqueKeyPropertyType = this.referencedModelPart.getReferencedPropertyName() == null ? concreteDescriptor.getIdentifierType() : session.getFactory().getReferencedPropertyType(concreteDescriptor.getEntityName(), uniqueKeyPropertyName);
                EntityUniqueKey euk = new EntityUniqueKey(concreteDescriptor.getEntityName(), uniqueKeyPropertyName, data.entityIdentifier, uniqueKeyPropertyType, session.getFactory());
                Object instance = persistenceContext.getEntity(euk);
                if (instance == null) {
                    if (this.referencedModelPart.isLazy()) {
                        instance = LazyPropertyInitializer.UNFETCHED_PROPERTY;
                    } else {
                        PersistentAttributeInterceptable persistentAttributeInterceptable = null;
                        if (this.getParent().isEntityInitializer() && this.isLazyByGraph(rowProcessingState)) {
                            Object resolvedInstance = this.getParent().asEntityInitializer().getResolvedInstance(rowProcessingState);
                            persistentAttributeInterceptable = ManagedTypeHelper.asPersistentAttributeInterceptableOrNull(resolvedInstance);
                        }
                        if (persistentAttributeInterceptable != null) {
                            LazyAttributeLoadingInterceptor persistentAttributeInterceptor = (LazyAttributeLoadingInterceptor)persistentAttributeInterceptable.$$_hibernate_getInterceptor();
                            persistentAttributeInterceptor.addLazyFieldByGraph(this.navigablePath.getLocalName());
                            instance = LazyPropertyInitializer.UNFETCHED_PROPERTY;
                        } else {
                            instance = concreteDescriptor.loadByUniqueKey(uniqueKeyPropertyName, data.entityIdentifier, session);
                            if (instance != null) {
                                persistenceContext.addEntity(euk, instance);
                            }
                        }
                    }
                }
                if (instance != null) {
                    instance = persistenceContext.proxyFor(instance);
                }
                data.setInstance(instance);
            } else {
                Object instance;
                EntityKey entityKey = new EntityKey(data.entityIdentifier, concreteDescriptor);
                EntityHolder holder = persistenceContext.getEntityHolder(entityKey);
                if (holder != null && holder.getEntity() != null) {
                    instance = persistenceContext.proxyFor(holder, concreteDescriptor);
                } else if (this.referencedModelPart.isOptional() && this.referencedModelPart.isLazy()) {
                    instance = LazyPropertyInitializer.UNFETCHED_PROPERTY;
                } else {
                    instance = session.internalLoad(concreteDescriptor.getEntityName(), data.entityIdentifier, false, false);
                    LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(instance);
                    if (lazyInitializer != null) {
                        lazyInitializer.setUnwrap(this.referencedModelPart.isUnwrapProxy() && concreteDescriptor.isInstrumented());
                    }
                }
                data.setInstance(instance);
            }
        }
    }

    private boolean isLazyByGraph(RowProcessingState rowProcessingState) {
        AppliedGraph appliedGraph = rowProcessingState.getQueryOptions().getAppliedGraph();
        if (appliedGraph != null && appliedGraph.getSemantic() == GraphSemantic.FETCH) {
            AttributeNodeImplementor attributeNode = appliedGraph.getGraph().findAttributeNode(this.navigablePath.getLocalName());
            return attributeNode == null || attributeNode.getAttributeDescriptor() != this.getInitializedPart().asAttributeMapping();
        }
        return false;
    }

    @Override
    public void resolveInstance(Object instance, EntityDelayedFetchInitializerData data) {
        if (instance == null) {
            data.setState(Initializer.State.MISSING);
            data.entityIdentifier = null;
            data.setInstance(null);
        } else {
            data.setState(Initializer.State.INITIALIZED);
            data.setInstance(instance);
            RowProcessingState rowProcessingState = data.getRowProcessingState();
            if (this.keyIsEager) {
                data.entityIdentifier = this.getEntityDescriptor().getIdentifier(instance, rowProcessingState.getSession());
                Initializer<?> initializer = this.identifierAssembler.getInitializer();
                assert (initializer != null);
                initializer.resolveInstance(data.entityIdentifier, rowProcessingState);
            } else if (rowProcessingState.needsResolveState()) {
                this.identifierAssembler.resolveState(rowProcessingState);
            }
        }
    }

    @Override
    protected void forEachSubInitializer(BiConsumer<Initializer<?>, RowProcessingState> consumer, InitializerData data) {
        Initializer<?> initializer = this.identifierAssembler.getInitializer();
        if (initializer != null) {
            consumer.accept(initializer, data.getRowProcessingState());
        }
    }

    @Override
    public EntityPersister getEntityDescriptor() {
        return this.referencedModelPart.getEntityMappingType().getEntityPersister();
    }

    @Override
    public @Nullable InitializerParent<?> getParent() {
        return this.parent;
    }

    @Override
    public boolean isPartOfKey() {
        return this.isPartOfKey;
    }

    @Override
    public boolean isEager() {
        return this.keyIsEager;
    }

    @Override
    public boolean hasLazySubInitializers() {
        return this.hasLazySubInitializer;
    }

    @Override
    public boolean isResultInitializer() {
        return false;
    }

    @Override
    public EntityPersister getConcreteDescriptor(EntityDelayedFetchInitializerData data) {
        return this.getEntityDescriptor();
    }

    @Override
    public void resolveState(EntityDelayedFetchInitializerData data) {
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        this.identifierAssembler.resolveState(rowProcessingState);
        if (this.discriminatorAssembler != null) {
            this.discriminatorAssembler.resolveState(rowProcessingState);
        }
    }

    @Override
    public @Nullable Object getEntityIdentifier(EntityDelayedFetchInitializerData data) {
        return data.entityIdentifier;
    }

    public String toString() {
        return "EntityDelayedFetchInitializer(" + LoggingHelper.toLoggableString(this.navigablePath) + ")";
    }

    protected boolean isSelectByUniqueKey() {
        return this.selectByUniqueKey;
    }

    protected DomainResultAssembler<?> getIdentifierAssembler() {
        return this.identifierAssembler;
    }

    protected @Nullable BasicResultAssembler<?> getDiscriminatorAssembler() {
        return this.discriminatorAssembler;
    }

    public static class EntityDelayedFetchInitializerData
    extends InitializerData {
        protected @Nullable Object entityIdentifier;

        public EntityDelayedFetchInitializerData(RowProcessingState rowProcessingState) {
            super(rowProcessingState);
        }
    }
}

