/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions;

import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallAction;
import com.install4j.runtime.beans.actions.properties.TextProperties;
import com.install4j.runtime.beans.applications.Application;
import com.install4j.runtime.installer.config.ApplicationBeanConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.RunningProcessChecker;
import com.install4j.runtime.installer.helper.VariableEncoding;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.FetchLongAction;
import com.install4j.runtime.installer.helper.comm.actions.FetchObjectAction;
import com.install4j.runtime.installer.helper.launching.LaunchDescriptor;
import com.install4j.runtime.installer.helper.launching.LaunchHelper;
import com.install4j.runtime.installer.platform.win32.FolderInfo;
import com.install4j.runtime.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class UninstallPreviousAction
extends SystemInstallAction {
    public static final String PROPNAME_UPGRADE_UNINSTALL = "install4j.upgradeUninstall";
    public static final String PROPNAME_DONT_UNINSTALL_SERVICES = "install4j.dontUninstallServices";
    private File installationDirectory;
    private boolean onlyIfSameApplicationId = true;
    private boolean uninstallServices = true;
    private Map<String, String> installerVariables = new LinkedHashMap<String, String>();
    private static List<File> logFiles = new ArrayList<File>();

    public static List<File> getLogFiles() {
        return HelperCommunication.getInstance().fetchObject(ExecutionContext.UNELEVATED, new FetchObjectAction<List<File>>(){

            @Override
            protected List<File> fetchValue(Context context) throws Exception {
                return logFiles;
            }
        });
    }

    public static void setLogFiles(List<File> logFiles) {
        UninstallPreviousAction.logFiles = logFiles;
    }

    public File getInstallationDirectory() {
        return this.replaceWithTextOverride("installationDirectory", UninstallPreviousAction.replaceVariables(this.installationDirectory), File.class);
    }

    public void setInstallationDirectory(File installationDirectory) {
        this.installationDirectory = installationDirectory;
    }

    public boolean isOnlyIfSameApplicationId() {
        return this.replaceWithTextOverride("onlyIfSameApplicationId", this.onlyIfSameApplicationId);
    }

    public void setOnlyIfSameApplicationId(boolean onlyIfSameApplicationId) {
        this.onlyIfSameApplicationId = onlyIfSameApplicationId;
    }

    public boolean isUninstallServices() {
        return this.replaceWithTextOverride("uninstallServices", this.uninstallServices);
    }

    public void setUninstallServices(boolean uninstallServices) {
        this.uninstallServices = uninstallServices;
    }

    public Map<String, String> getInstallerVariables() {
        return this.replaceWithTextOverride("installerVariables", this.installerVariables, Map.class);
    }

    public void setInstallerVariables(Map<String, String> installerVariables) {
        this.installerVariables = installerVariables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean install(InstallerContext context) throws UserCanceledException {
        try {
            boolean success = true;
            ProgressInterface progressInterface = context.getProgressInterface();
            Logger.getInstance().info(this, "checking running processes");
            if (!RunningProcessChecker.checkDefaultRunningLauncher()) {
                throw new UserCanceledException();
            }
            Logger.getInstance().info(this, "checking running processes ok");
            File externalInstallationDirectory = this.getInstallationDirectory();
            File currentInstallationDirectory = context.getInstallationDirectory();
            if (Util.isMacosInstaller() && InstallerConfig.getCurrentInstance().getMacSpecificConfig().isSingleBundle()) {
                currentInstallationDirectory = new File(currentInstallationDirectory, InstallerConfig.getCurrentInstance().getMacSpecificConfig().getSingleBundleName());
            }
            File installationDirectory = externalInstallationDirectory == null || externalInstallationDirectory.getPath().trim().length() == 0 ? currentInstallationDirectory : externalInstallationDirectory;
            InstallerConfig config = InstallerConfig.getCurrentInstance();
            String oldApplicationId = InstallerUtil.getOldApplicationId(installationDirectory);
            Logger.getInstance().info(this, "previous installation id at " + installationDirectory + ": " + oldApplicationId);
            if (oldApplicationId != null && (!this.isOnlyIfSameApplicationId() || config.getApplicationId().equals(oldApplicationId))) {
                progressInterface.setStatusMessage(Messages.getString(".StatusUninstallingPrevious"));
                progressInterface.setIndeterminateProgress(true);
                File varFile = null;
                try {
                    varFile = this.writeVarFile();
                    UninstallerThread uninstallerThread = new UninstallerThread(installationDirectory, Objects.equals(currentInstallationDirectory.getCanonicalFile(), installationDirectory.getCanonicalFile()), !this.isUninstallServices(), varFile, context);
                    Logger.getInstance().info(this, "starting uninstaller");
                    uninstallerThread.start();
                    while (uninstallerThread.isAlive()) {
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (!context.isCancelling()) continue;
                        uninstallerThread.interrupt();
                    }
                    success = uninstallerThread.success;
                    Set undeletedFiles = uninstallerThread.undeletedFiles;
                    if (!success || undeletedFiles.isEmpty()) {
                        context.setVariable("sys.undeletedUninstallFiles", null);
                    } else {
                        context.setVariable("sys.undeletedUninstallFiles", undeletedFiles);
                        success = false;
                    }
                }
                finally {
                    if (varFile != null && varFile.isFile() && !varFile.delete()) {
                        varFile.deleteOnExit();
                    }
                }
                progressInterface.setIndeterminateProgress(false);
            } else {
                Logger.getInstance().info(this, "no previous installation detected, uninstaller was not started");
            }
            Logger.getInstance().info(this, "finished");
            return success;
        }
        catch (UserCanceledException e) {
            Logger.getInstance().info(this, "user cancelled");
            throw e;
        }
        catch (Throwable t) {
            Logger.getInstance().log(t);
            return false;
        }
    }

    private File writeVarFile() throws IOException {
        File varFile = null;
        if (!this.getInstallerVariables().isEmpty()) {
            TextProperties encodedResponse = new TextProperties();
            for (Map.Entry<String, String> entry : this.getInstallerVariables().entrySet()) {
                VariableEncoding.encodeVariable(encodedResponse, UninstallPreviousAction.replaceVariables(entry.getKey()), UninstallPreviousAction.replaceVariables(entry.getValue()));
            }
            varFile = File.createTempFile("i4j", ".varfile");
            try (FileOutputStream out = new FileOutputStream(varFile);){
                out.write(encodedResponse.convertToPropertiesString().getBytes());
            }
        }
        return varFile;
    }

    private static int fetchLogFiles(final File logFile) {
        return HelperCommunication.getInstance().fetchInt(ExecutionContext.UNELEVATED, new FetchLongAction(){

            @Override
            protected long fetchValue(Context context) throws Exception {
                int index = UninstallPreviousAction.getLogFiles().size();
                UninstallPreviousAction.getLogFiles().add(logFile);
                return index;
            }
        });
    }

    private static Set<String> deleteWindowsUndelFiles(final File undeletedLogFile) throws IOException {
        Logger.getInstance().info(null, "deleting remaining files from " + undeletedLogFile + ", " + undeletedLogFile.exists());
        if (undeletedLogFile.isFile() && undeletedLogFile.length() > 1L) {
            return HelperCommunication.getInstance().fetchObject(ExecutionContext.MAXIMUM, new FetchObjectAction<Set<String>>(){

                @Override
                protected Set<String> fetchValue(Context context) throws Exception {
                    ArrayList<File> undeletedFiles = new ArrayList<File>();
                    InputStreamReader unbufferedReader = UninstallPreviousAction.isUTF16LE(undeletedLogFile) ? new InputStreamReader((InputStream)new FileInputStream(undeletedLogFile), StandardCharsets.UTF_16LE) : new FileReader(undeletedLogFile);
                    BufferedReader reader = new BufferedReader(unbufferedReader);
                    if (reader.readLine() != null) {
                        String name = reader.readLine();
                        while (name != null) {
                            if (!Objects.equals(name, "")) {
                                File file = new File(name).getAbsoluteFile();
                                try {
                                    file = file.getCanonicalFile();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                                Logger.getInstance().info(null, "deleting " + file);
                                if (!file.delete() && file.exists()) {
                                    undeletedFiles.add(file);
                                    Logger.getInstance().info(null, "could not delete " + file);
                                }
                            }
                            name = reader.readLine();
                        }
                    }
                    reader.close();
                    undeletedLogFile.delete();
                    for (int i = 0; i < 3 && !undeletedFiles.isEmpty(); ++i) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        Iterator iterator2 = undeletedFiles.iterator();
                        while (iterator2.hasNext()) {
                            File file = (File)iterator2.next();
                            if (file.exists()) {
                                if (!file.delete()) continue;
                                iterator2.remove();
                                continue;
                            }
                            iterator2.remove();
                        }
                    }
                    HashSet<String> ret = new HashSet<String>();
                    for (File undeletedFile : undeletedFiles) {
                        if (!undeletedFile.isFile()) continue;
                        ret.add(undeletedFile.getAbsolutePath());
                    }
                    return ret;
                }
            });
        }
        return Collections.emptySet();
    }

    private static boolean isUTF16LE(File undeletedLogFile) throws FileNotFoundException {
        boolean ret = false;
        try (RandomAccessFile raFile = new RandomAccessFile(undeletedLogFile, "r");){
            raFile.seek(1L);
            ret = raFile.read() == 0;
        }
        catch (IOException e) {
            Logger.getInstance().log(e);
        }
        return ret;
    }

    @Override
    public boolean isRollbackSupported() {
        return false;
    }

    private class UninstallerThread
    extends Thread {
        private File installationDirectory;
        private boolean upgrade;
        private final boolean dontUninstallServices;
        private final File varFile;
        private Context context;
        private volatile Set<String> undeletedFiles;
        private volatile boolean success;

        public UninstallerThread(File installationDirectory, boolean upgrade, boolean dontUninstallServices, File varFile, Context context) {
            super("uninstaller waiting thread");
            this.undeletedFiles = Collections.emptySet();
            this.success = true;
            this.installationDirectory = installationDirectory;
            this.upgrade = upgrade;
            this.dontUninstallServices = dontUninstallServices;
            this.varFile = varFile;
            this.context = context;
        }

        private void addCommonArguments(List<String> list, File logFile) {
            list.add("-q");
            list.add("-Dinstall4j.alternativeLogfile=" + logFile.getAbsolutePath());
            list.add("-Dinstall4j.upgradeUninstall=" + this.upgrade);
            list.add("-Dinstall4j.dontUninstallServices=" + this.dontUninstallServices);
            if (Boolean.getBoolean("install4j.debugFileRemover")) {
                list.add("-Dinstall4j.debugFileRemover=true");
            }
            if (this.varFile != null) {
                list.add("-varfile");
                if (Util.isWindows()) {
                    list.add(FolderInfo.getShortPathName(this.varFile.getAbsolutePath()));
                } else {
                    list.add(this.varFile.getAbsolutePath());
                }
            }
        }

        @Override
        public void run() {
            InstallerConfig oldConfig = InstallerUtil.getOldApplicationConfig(this.installationDirectory);
            if (oldConfig == null) {
                Logger.getInstance().error(UninstallPreviousAction.this, "did not find old config");
                return;
            }
            try {
                int logFileIndex;
                block19: {
                    File logFile = File.createTempFile("i4j_log_uninstaller", ".log");
                    logFile.deleteOnExit();
                    logFileIndex = UninstallPreviousAction.fetchLogFiles(logFile);
                    if (InstallerUtil.isWindows()) {
                        File undeletedLogFile = new File("i4j_undel.log.tmp");
                        ArrayList<String> arguments = new ArrayList<String>();
                        arguments.add("-q_i4j_internal");
                        this.addCommonArguments(arguments, logFile);
                        arguments.add("-Dwindel.logfile=" + undeletedLogFile.getAbsolutePath());
                        LaunchDescriptor launchDescriptor = new LaunchDescriptor(new File(this.installationDirectory, oldConfig.getUninstallerPath() + ".exe")).arguments(arguments).workingDirectory(new File(this.installationDirectory, "..")).wait(true);
                        Integer returnValue = LaunchHelper.launchApplication(launchDescriptor);
                        Logger.getInstance().info(UninstallPreviousAction.this, "native uninstaller process returned " + returnValue);
                        if (returnValue == null || returnValue == 83) {
                            this.runJavaUninstaller(oldConfig, logFile);
                        } else {
                            this.success = returnValue == 0;
                            try {
                                Thread.sleep(2000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            this.undeletedFiles = UninstallPreviousAction.deleteWindowsUndelFiles(undeletedLogFile);
                        }
                    } else {
                        File uninstallerScript;
                        if (Util.isMacosInstaller()) {
                            File script = new File(oldConfig.getConfigFile().getParentFile(), "uninstall");
                            if (Objects.equals(oldConfig.getType(), "macos") && oldConfig.getMacSpecificConfig().isSingleBundle() && !script.isFile()) {
                                Logger.getInstance().error(UninstallPreviousAction.this, "previous single bundle installation does not support uninstallation");
                                return;
                            }
                            uninstallerScript = this.context.getBooleanVariable("sys.ext.macDisableCliUninstaller") ? null : script;
                        } else {
                            uninstallerScript = new File(this.installationDirectory, oldConfig.getUninstallerPath());
                        }
                        if (uninstallerScript != null && uninstallerScript.isFile()) {
                            Logger.getInstance().info(UninstallPreviousAction.this, "executing " + uninstallerScript);
                            ArrayList<String> command = new ArrayList<String>();
                            command.add("/bin/sh");
                            command.add(uninstallerScript.getAbsolutePath());
                            this.addCommonArguments(command, logFile);
                            Process process = new ProcessBuilder(command).directory(new File(this.installationDirectory, "..")).start();
                            try {
                                int returnValue = process.waitFor();
                                if (returnValue == 83) {
                                    this.runJavaUninstaller(oldConfig, logFile);
                                    break block19;
                                }
                                this.success = returnValue == 0;
                            }
                            catch (InterruptedException e) {
                                process.destroy();
                            }
                        } else {
                            this.runJavaUninstaller(oldConfig, logFile);
                        }
                    }
                }
                Logger.getInstance().info(UninstallPreviousAction.this, "see " + Logger.getUninstallPreviousLogFileName(logFileIndex) + " for the log file of the uninstaller");
                try {
                    Thread.sleep(1500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private void runJavaUninstaller(InstallerConfig config, File logFile) throws IOException {
            Application application;
            String vmParameters = "";
            ApplicationBeanConfig appConfig = config.getApplicationConfigById("uninstaller");
            if (appConfig != null && (application = appConfig.getOrInstantiateApplication(true)) != null) {
                vmParameters = application.getVmParameters();
            }
            File runtimeDir = Util.isMacosInstaller() && config.getMacSpecificConfig().isSingleBundle() ? config.getConfigFile().getParentFile() : new File(this.installationDirectory, ".install4j");
            String classpath = new File(runtimeDir, "i4jruntime.jar").getAbsolutePath();
            ArrayList<String> arguments = new ArrayList<String>();
            StringUtil.splitupCommandLine(arguments, vmParameters);
            arguments.add("-cp");
            arguments.add(classpath);
            arguments.add("com.install4j.runtime.installer.Uninstaller");
            this.addCommonArguments(arguments, logFile);
            LaunchDescriptor launchDescriptor = new LaunchDescriptor(new File(this.findJre(this.installationDirectory, config), "bin/java")).arguments(arguments).workingDirectory(new File(this.installationDirectory, "..")).wait(true);
            Logger.getInstance().info(UninstallPreviousAction.this, "using jre from " + launchDescriptor.getExecutable());
            Integer returnValue = LaunchHelper.launchApplication(launchDescriptor);
            Logger.getInstance().info(UninstallPreviousAction.this, "uninstaller process returned " + returnValue);
            this.success = returnValue != null && returnValue == 0;
        }

        @NotNull
        private File findJre(File installationDirectory, InstallerConfig config) {
            File javaHome;
            File folderRuntimeDir = new File(installationDirectory, ".install4j");
            if (Util.isMacosInstaller()) {
                if (config.getMacSpecificConfig().isSingleBundle()) {
                    javaHome = this.checkJre(new File(installationDirectory, "Contents/PlugIns/jre.bundle/Contents/Home/jre"));
                    if (javaHome != null) {
                        return javaHome;
                    }
                    javaHome = this.checkJre(new File(installationDirectory, "Contents/PlugIns/jre.bundle/Contents/Home"));
                } else {
                    javaHome = this.checkJre(new File(folderRuntimeDir, "jre.bundle/Contents/Home/jre"));
                    if (javaHome != null) {
                        return javaHome;
                    }
                    javaHome = this.checkJre(new File(folderRuntimeDir, "jre.bundle/Contents/Home"));
                }
            } else {
                javaHome = this.checkJre(new File(installationDirectory, "jre"));
            }
            if (javaHome != null) {
                return javaHome;
            }
            javaHome = this.checkJre(this.readFile(new File(folderRuntimeDir, "inst_jre.cfg")));
            if (javaHome != null) {
                return javaHome;
            }
            javaHome = this.checkJre(this.readFile(new File(folderRuntimeDir, "pref_jre.cfg")));
            if (javaHome != null) {
                return javaHome;
            }
            return new File(System.getProperty("java.home"));
        }

        private File checkJre(File javaHome) {
            if (javaHome != null && !new File(javaHome, "bin/java").isFile()) {
                return null;
            }
            return javaHome;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private File readFile(File cfgFile) {
            if (!cfgFile.isFile()) return null;
            try (BufferedReader reader = new BufferedReader(new FileReader(cfgFile));){
                String line = reader.readLine();
                if (line == null) return null;
                File file = new File(line);
                return file;
            }
            catch (IOException e) {
                Logger.getInstance().log(e);
            }
            return null;
        }
    }
}

