/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.applaunch;

import com.install4j.runtime.installer.helper.applaunch.CommType;
import com.install4j.runtime.installer.helper.applaunch.ProgressCommunication;
import com.install4j.runtime.installer.helper.comm.InterProcessCommunication;
import com.install4j.runtime.util.DaemonThreadFactory;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

class RemoteCommunication
extends ProgressCommunication {
    private final InterProcessCommunication communication;
    private final ExecutorService executorService = Executors.newSingleThreadExecutor(new DaemonThreadFactory("progress-comm-"));

    public RemoteCommunication(InterProcessCommunication communication) {
        this.communication = communication;
    }

    @Override
    public void exiting() {
        this.submit(new Event(CommType.EXITING, null));
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void screenActivated(String id) {
        this.submit(new Event(CommType.SHOW_SCREEN, id));
    }

    @Override
    public void actionStarted(String id) {
        this.submit(new Event(CommType.EXECUTE_ACTION, id));
    }

    @Override
    public void statusMessage(String message) {
        this.submit(new Event(CommType.STATUS_MESSAGE, message));
    }

    @Override
    public void detailMessage(String message) {
        this.submit(new Event(CommType.DETAIL_MESSAGE, message));
    }

    @Override
    public void percentCompleted(int value) {
        this.submit(new Event(CommType.PERCENTAGE_COMPLETED, value));
    }

    @Override
    public void secondaryPercentCompleted(int value) {
        this.submit(new Event(CommType.SECONDARY_PERCENTAGE_COMPLETED, value));
    }

    @Override
    public void indeterminateProgress(boolean indeterminateProgress) {
        this.submit(new Event(CommType.INDETERMINATE_PROGRESS, indeterminateProgress));
    }

    private void submit(Event event) {
        this.executorService.submit(() -> {
            if (this.communication.isConnected()) {
                try {
                    this.communication.writeDataBlock(event.getData());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    private static class Event {
        private final CommType type;
        private final Object parameter;

        public Event(CommType type, Object parameter) {
            this.type = type;
            this.parameter = parameter;
        }

        public byte[] getData() {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(byteArrayOutputStream);
            try {
                out.writeInt(this.type.ordinal());
                if (this.parameter instanceof String) {
                    out.writeUTF((String)this.parameter);
                } else if (this.parameter instanceof Integer) {
                    out.writeInt((Integer)this.parameter);
                } else if (this.parameter instanceof Boolean) {
                    out.writeBoolean((Boolean)this.parameter);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return byteArrayOutputStream.toByteArray();
        }
    }
}

