/*
 * Decompiled with CFR 0.152.
 */
package org.xmpp.component;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.component.Component;
import org.xmpp.component.ComponentException;
import org.xmpp.component.ComponentManager;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;
import org.xmpp.packet.PacketError;
import org.xmpp.packet.Presence;

public abstract class AbstractComponent
implements Component {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String NAMESPACE_DISCO_ITEMS = "http://jabber.org/protocol/disco#items";
    public static final String NAMESPACE_DISCO_INFO = "http://jabber.org/protocol/disco#info";
    public static final String NAMESPACE_XMPP_PING = "urn:xmpp:ping";
    public static final String NAMESPACE_LAST_ACTIVITY = "jabber:iq:last";
    public static final String NAMESPACE_ENTITY_TIME = "urn:xmpp:time";
    protected ComponentManager compMan = null;
    protected JID jid = null;
    private ThreadPoolExecutor executor;
    private final int maxThreadPoolSize;
    private final int maxQueueSize;
    private final boolean enforceIQResult;
    private long lastStartMillis = System.currentTimeMillis();

    public AbstractComponent() {
        this(17, 1000, true);
    }

    public AbstractComponent(int maxThreadpoolSize, int maxQueueSize, boolean enforceIQResult) {
        this.maxThreadPoolSize = maxThreadpoolSize;
        this.maxQueueSize = maxQueueSize;
        this.enforceIQResult = enforceIQResult;
    }

    @Override
    public final void initialize(JID jid, ComponentManager componentManager) throws ComponentException {
        this.compMan = componentManager;
        this.jid = jid;
        this.startExecutor();
    }

    @Override
    public final void processPacket(Packet packet) {
        block3: {
            Packet copy = packet.createCopy();
            if (this.executor == null) {
                String msg = "(serving component '" + this.getName() + "') Unable to initialize and start component before packet processing.";
                this.log.error(msg);
                throw new IllegalStateException(msg);
            }
            try {
                this.executor.execute(new PacketProcessor(copy));
            }
            catch (RejectedExecutionException ex) {
                this.log.error("(serving component '" + this.getName() + "') Unable to process packet! Is the thread pool queue exhausted? Packet dropped in component '" + this.getName() + "'. Packet that's dropped: " + packet.toXML(), (Throwable)ex);
                if (!(packet instanceof IQ) || !((IQ)packet).isRequest()) break block3;
                IQ response = IQ.createResultIQ((IQ)packet);
                response.setError(PacketError.Condition.internal_server_error);
                this.send(response);
            }
        }
    }

    private void processQueuedPacket(Packet packet) {
        if (packet instanceof IQ) {
            this.processIQ((IQ)packet);
        } else if (packet instanceof Message) {
            this.processMessage((Message)packet);
        } else if (packet instanceof Presence) {
            this.processPresence((Presence)packet);
        }
    }

    private void processIQ(IQ iq) {
        IQ response;
        block14: {
            if (this.log.isDebugEnabled()) {
                this.log.debug("(serving component '{}') Processing IQ (packetId {}): {}", new Object[]{this.getName(), iq.getID(), iq.toXML()});
            }
            response = null;
            IQ.Type type = iq.getType();
            try {
                switch (type) {
                    case get: 
                    case set: {
                        String requestID = iq.getID();
                        response = this.processIQRequest(iq);
                        if (response == null) {
                            if (!this.enforceIQResult) break;
                            response = IQ.createResultIQ(iq);
                            response.setError(PacketError.Condition.feature_not_implemented);
                            break;
                        }
                        if (!response.isResponse()) {
                            throw new IllegalStateException("Responses to IQ of type <tt>get</tt> or <tt>set</tt> can only be IQ stanza's of type <tt>error</tt> or <tt>result</tt>. The response to this packet was incorrect: " + iq.toXML() + ". The response was: " + response.toXML());
                        }
                        if (!requestID.equals(response.getID())) {
                            throw new IllegalStateException("The response to an request IQ must have the same packet ID. If this was done intentionally, #send(Packet) should have been used instead. The response to this packet was incorrect: " + iq.toXML() + ". The response was: " + response.toXML());
                        }
                        if (!this.log.isDebugEnabled()) break;
                        this.log.debug("(serving component '{}') Responding to IQ (packetId {}) with: {}", new Object[]{this.getName(), iq.getID(), response.toXML()});
                        break;
                    }
                    case result: {
                        if (this.dropStanza(iq)) {
                            return;
                        }
                        this.handleIQResult(iq);
                        break;
                    }
                    case error: {
                        if (this.dropStanza(iq)) {
                            return;
                        }
                        this.handleIQError(iq);
                    }
                }
            }
            catch (Exception ex) {
                this.log.warn("(serving component '" + this.getName() + "') Unexpected exception while processing IQ stanza: " + iq.toXML(), (Throwable)ex);
                if (!iq.isRequest()) break block14;
                response = IQ.createResultIQ(iq);
                response.setError(PacketError.Condition.internal_server_error);
            }
        }
        if (response != null) {
            this.send(response);
        }
    }

    protected boolean dropStanza(IQ iq) {
        if (this.servesLocalUsersOnly() && !this.sentByLocalEntity(iq)) {
            this.log.info("(serving component '{}') Dropping IQ stanza sent by a user from another domain: {}", (Object)this.getName(), (Object)iq.getFrom());
            if (this.log.isDebugEnabled()) {
                this.log.debug("(serving component '{}') Dropping IQ stanza sent by a user from another domain: {}", (Object)this.getName(), (Object)iq.toXML());
            }
            return true;
        }
        return false;
    }

    private void processMessage(Message message) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("(serving component '{}') Processing message stanza: {}", (Object)this.getName(), (Object)message.toXML());
        }
        if (this.servesLocalUsersOnly() && !this.sentByLocalEntity(message)) {
            this.log.info("(serving component '{}') Dropping message stanza sent by a user from another domain: {}", (Object)this.getName(), (Object)message.getFrom());
            if (this.log.isDebugEnabled()) {
                this.log.debug("(serving component '{}') Dropping message stanza sent by a user from another domain: {}", (Object)this.getName(), (Object)message.toXML());
            }
            return;
        }
        this.handleMessage(message);
    }

    private void processPresence(Presence presence) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("(serving component '{}') Processing presence stanza: {}", (Object)this.getName(), (Object)presence.toXML());
        }
        if (this.servesLocalUsersOnly() && !this.sentByLocalEntity(presence)) {
            this.log.info("(serving component '{}') Dropping presence stanza sent by a user from another domain: {}", (Object)this.getName(), (Object)presence.getFrom());
            if (this.log.isDebugEnabled()) {
                this.log.debug("(serving component '{}') Dropping presence stanza sent by a user from another domain: {}", (Object)this.getName(), (Object)presence.toXML());
            }
            return;
        }
        this.handlePresence(presence);
    }

    private IQ processIQRequest(IQ iq) throws Exception {
        this.log.debug("(serving component '{}') Processing IQ request (packetId {}).", (Object)this.getName(), (Object)iq.getID());
        Element childElement = iq.getChildElement();
        String namespace = null;
        if (childElement != null) {
            namespace = childElement.getNamespaceURI();
        }
        if (namespace == null) {
            this.log.debug("(serving component '{}') Invalid XMPP - no child element or namespace in IQ request (packetId {})", (Object)this.getName(), (Object)iq.getID());
            IQ response = IQ.createResultIQ(iq);
            response.setError(PacketError.Condition.bad_request);
            return response;
        }
        if (this.servesLocalUsersOnly() && !this.sentByLocalEntity(iq)) {
            this.log.info("(serving component '{}') Returning 'not-authorized' IQ error to a user from another domain: {}", (Object)this.getName(), (Object)iq.getFrom());
            if (this.log.isDebugEnabled()) {
                this.log.debug("(serving component '{}') Returning 'not-authorized' IQ error to a user from another domain: {}", (Object)this.getName(), (Object)iq.toXML());
            }
            IQ error = IQ.createResultIQ(iq);
            error.setError(PacketError.Condition.not_authorized);
            return error;
        }
        IQ.Type type = iq.getType();
        if (type == IQ.Type.get) {
            switch (namespace) {
                case "http://jabber.org/protocol/disco#info": {
                    this.log.trace("(serving component '{}') Calling #handleDiscoInfo() (packetId {}).", (Object)this.getName(), (Object)iq.getID());
                    return this.handleDiscoInfo(iq);
                }
                case "http://jabber.org/protocol/disco#items": {
                    this.log.trace("(serving component '{}') Calling #handleDiscoItems() (packetId {}).", (Object)this.getName(), (Object)iq.getID());
                    return this.handleDiscoItems(iq);
                }
                case "urn:xmpp:ping": {
                    this.log.trace("(serving component '{}') Calling #handlePing() (packetId {}).", (Object)this.getName(), (Object)iq.getID());
                    return this.handlePing(iq);
                }
                case "jabber:iq:last": {
                    this.log.trace("(serving component '{}') Calling #handleLastActivity() (packetId {}).", (Object)this.getName(), (Object)iq.getID());
                    return this.handleLastActivity(iq);
                }
                case "urn:xmpp:time": {
                    this.log.trace("(serving component '{}') Calling #handleEntityTime() (packetId {}).", (Object)this.getName(), (Object)iq.getID());
                    return this.handleEntityTime(iq);
                }
            }
            return this.handleIQGet(iq);
        }
        if (type == IQ.Type.set) {
            return this.handleIQSet(iq);
        }
        return null;
    }

    protected void handleIQResult(IQ iq) {
    }

    protected void handleIQError(IQ iq) {
        if (this.log.isInfoEnabled()) {
            this.log.info("(serving component '{}') IQ stanza of type <tt>error</tt> received: {}", (Object)this.getName(), (Object)iq.toXML());
        }
    }

    protected IQ handleIQGet(IQ iq) throws Exception {
        return null;
    }

    protected IQ handleIQSet(IQ iq) throws Exception {
        return null;
    }

    protected IQ handleDiscoItems(IQ iq) {
        return null;
    }

    protected IQ handleDiscoInfo(IQ iq) {
        IQ replyPacket = IQ.createResultIQ(iq);
        Element responseElement = replyPacket.setChildElement("query", NAMESPACE_DISCO_INFO);
        responseElement.addElement("identity").addAttribute("category", this.discoInfoIdentityCategory()).addAttribute("type", this.discoInfoIdentityCategoryType()).addAttribute("name", this.getName());
        responseElement.addElement("feature").addAttribute("var", NAMESPACE_DISCO_INFO);
        responseElement.addElement("feature").addAttribute("var", NAMESPACE_XMPP_PING);
        responseElement.addElement("feature").addAttribute("var", NAMESPACE_LAST_ACTIVITY);
        responseElement.addElement("feature").addAttribute("var", NAMESPACE_ENTITY_TIME);
        for (String feature : this.discoInfoFeatureNamespaces()) {
            responseElement.addElement("feature").addAttribute("var", feature);
        }
        return replyPacket;
    }

    protected IQ handlePing(IQ iq) {
        return IQ.createResultIQ(iq);
    }

    protected IQ handleLastActivity(IQ iq) {
        long uptime = (System.currentTimeMillis() - this.lastStartMillis) / 1000L;
        IQ result = IQ.createResultIQ(iq);
        result.setChildElement("query", NAMESPACE_LAST_ACTIVITY).addAttribute("seconds", Long.toString(uptime));
        return result;
    }

    protected IQ handleEntityTime(IQ iq) {
        Date now = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        SimpleDateFormat sdf_timezone = new SimpleDateFormat("Z");
        String utc = sdf.format(now);
        String tz = sdf_timezone.format(new Date());
        String tzo = new StringBuilder(tz).insert(3, ':').toString();
        IQ result = IQ.createResultIQ(iq);
        Element el = result.setChildElement("time", NAMESPACE_ENTITY_TIME);
        el.addElement("tzo").setText(tzo);
        el.addElement("utc").setText(utc);
        return result;
    }

    @Override
    public abstract String getDescription();

    @Override
    public abstract String getName();

    public String getDomain() {
        return this.jid != null ? this.jid.getDomain() : null;
    }

    public JID getJID() {
        return this.jid;
    }

    protected String discoInfoIdentityCategory() {
        return "component";
    }

    protected String discoInfoIdentityCategoryType() {
        return "generic";
    }

    protected String[] discoInfoFeatureNamespaces() {
        return new String[0];
    }

    protected void handleMessage(Message message) {
    }

    protected void handlePresence(Presence presence) {
    }

    public boolean servesLocalUsersOnly() {
        return false;
    }

    @Override
    public final void shutdown() {
        this.preComponentShutdown();
        this.closeQueue();
        this.postComponentShutdown();
    }

    private void closeQueue() {
        this.log.debug("Closing queue...");
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(2L, TimeUnit.SECONDS)) {
                List<Runnable> wasAwatingExecution = this.executor.shutdownNow();
                for (Runnable abortMe : wasAwatingExecution) {
                    IQ iq;
                    Packet packet = ((PacketProcessor)abortMe).packet;
                    if (!(packet instanceof IQ) || !(iq = (IQ)packet).isRequest()) continue;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Responding 'service unavailable' to unprocessed stanza: {}", (Object)iq.toXML());
                    }
                    IQ error = IQ.createResultIQ(iq);
                    error.setError(PacketError.Condition.service_unavailable);
                    this.send(error);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void send(Packet packet) {
        try {
            this.compMan.sendPacket(this, packet);
        }
        catch (ComponentException e) {
            this.log.warn("(serving component '" + this.getName() + "') Could not send packet!", (Throwable)e);
        }
    }

    public void preComponentShutdown() {
    }

    public void postComponentShutdown() {
    }

    @Override
    public void start() {
        this.preComponentStart();
        this.lastStartMillis = System.currentTimeMillis();
        this.startExecutor();
        this.postComponentStart();
    }

    private void startExecutor() {
        if (this.executor == null || this.executor.isShutdown()) {
            this.executor = new ThreadPoolExecutor(this.maxThreadPoolSize, this.maxThreadPoolSize, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(this.maxQueueSize));
        }
    }

    public void preComponentStart() {
    }

    public void postComponentStart() {
    }

    private boolean sentByLocalEntity(Packet packet) {
        JID from = packet.getFrom();
        if (from == null) {
            return true;
        }
        String fromDomain = from.getDomain();
        return fromDomain.equals(this.getDomain()) || this.getDomain().endsWith("." + fromDomain);
    }

    private class PacketProcessor
    implements Runnable {
        private final Packet packet;

        public PacketProcessor(Packet packet) {
            this.packet = packet;
        }

        @Override
        public void run() {
            AbstractComponent.this.processQueuedPacket(this.packet);
        }
    }
}

