/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.request.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.opensearch.index.query.InnerHitBuilder;
import org.opensearch.protobufs.InnerHits;
import org.opensearch.protobufs.ScriptField;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.fetch.subphase.FieldAndFormat;
import org.opensearch.transport.grpc.proto.request.common.FetchSourceContextProtoUtils;
import org.opensearch.transport.grpc.proto.request.search.CollapseBuilderProtoUtils;
import org.opensearch.transport.grpc.proto.request.search.FieldAndFormatProtoUtils;
import org.opensearch.transport.grpc.proto.request.search.HighlightBuilderProtoUtils;
import org.opensearch.transport.grpc.proto.request.search.SearchSourceBuilderProtoUtils;
import org.opensearch.transport.grpc.proto.request.search.sort.SortBuilderProtoUtils;

public class InnerHitsBuilderProtoUtils {
    private InnerHitsBuilderProtoUtils() {
    }

    protected static InnerHitBuilder fromProto(List<InnerHits> innerHits) throws IOException {
        InnerHitBuilder innerHitBuilder = new InnerHitBuilder();
        for (InnerHits innerHit : innerHits) {
            ArrayList<FieldAndFormat> fieldAndFormatList;
            if (innerHit.hasName()) {
                innerHitBuilder.setName(innerHit.getName());
            }
            if (innerHit.hasIgnoreUnmapped()) {
                innerHitBuilder.setIgnoreUnmapped(innerHit.getIgnoreUnmapped());
            }
            if (innerHit.hasFrom()) {
                innerHitBuilder.setFrom(innerHit.getFrom());
            }
            if (innerHit.hasSize()) {
                innerHitBuilder.setSize(innerHit.getSize());
            }
            if (innerHit.hasExplain()) {
                innerHitBuilder.setExplain(innerHit.getExplain());
            }
            if (innerHit.hasVersion()) {
                innerHitBuilder.setVersion(innerHit.getVersion());
            }
            if (innerHit.hasSeqNoPrimaryTerm()) {
                innerHitBuilder.setSeqNoAndPrimaryTerm(innerHit.getSeqNoPrimaryTerm());
            }
            if (innerHit.hasTrackScores()) {
                innerHitBuilder.setTrackScores(innerHit.getTrackScores());
            }
            if (innerHit.getStoredFieldsCount() > 0) {
                innerHitBuilder.setStoredFieldNames((List)innerHit.getStoredFieldsList());
            }
            if (innerHit.getDocvalueFieldsCount() > 0) {
                fieldAndFormatList = new ArrayList<FieldAndFormat>();
                for (org.opensearch.protobufs.FieldAndFormat fieldAndFormat : innerHit.getDocvalueFieldsList()) {
                    fieldAndFormatList.add(FieldAndFormatProtoUtils.fromProto(fieldAndFormat));
                }
                innerHitBuilder.setDocValueFields(fieldAndFormatList);
            }
            if (innerHit.getFieldsCount() > 0) {
                fieldAndFormatList = new ArrayList();
                for (org.opensearch.protobufs.FieldAndFormat fieldAndFormat : innerHit.getFieldsList()) {
                    fieldAndFormatList.add(FieldAndFormatProtoUtils.fromProto(fieldAndFormat));
                }
                innerHitBuilder.setFetchFields(fieldAndFormatList);
            }
            if (innerHit.getScriptFieldsCount() > 0) {
                HashSet<SearchSourceBuilder.ScriptField> scriptFields = new HashSet<SearchSourceBuilder.ScriptField>();
                for (Map.Entry entry : innerHit.getScriptFieldsMap().entrySet()) {
                    String name = (String)entry.getKey();
                    ScriptField scriptFieldProto = (ScriptField)entry.getValue();
                    SearchSourceBuilder.ScriptField scriptField = SearchSourceBuilderProtoUtils.ScriptFieldProtoUtils.fromProto(name, scriptFieldProto);
                    scriptFields.add(scriptField);
                }
                innerHitBuilder.setScriptFields(scriptFields);
            }
            if (innerHit.getSortCount() > 0) {
                innerHitBuilder.setSorts(SortBuilderProtoUtils.fromProto(innerHit.getSortList()));
            }
            if (innerHit.hasSource()) {
                innerHitBuilder.setFetchSourceContext(FetchSourceContextProtoUtils.fromProto(innerHit.getSource()));
            }
            if (innerHit.hasHighlight()) {
                innerHitBuilder.setHighlightBuilder(HighlightBuilderProtoUtils.fromProto(innerHit.getHighlight()));
            }
            if (!innerHit.hasCollapse()) continue;
            innerHitBuilder.setInnerCollapse(CollapseBuilderProtoUtils.fromProto(innerHit.getCollapse()));
        }
        return innerHitBuilder;
    }
}

