/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.response.document.bulk;

import java.io.IOException;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.index.get.GetResult;
import org.opensearch.protobufs.ErrorCause;
import org.opensearch.protobufs.Item;
import org.opensearch.protobufs.NullValue;
import org.opensearch.protobufs.ResponseItem;
import org.opensearch.transport.grpc.proto.response.document.common.DocWriteResponseProtoUtils;
import org.opensearch.transport.grpc.proto.response.document.get.GetResultProtoUtils;
import org.opensearch.transport.grpc.proto.response.exceptions.opensearchexception.OpenSearchExceptionProtoUtils;
import org.opensearch.transport.grpc.util.RestToGrpcStatusConverter;

public class BulkItemResponseProtoUtils {
    private BulkItemResponseProtoUtils() {
    }

    public static Item toProto(BulkItemResponse response) throws IOException {
        ResponseItem.Builder responseItemBuilder;
        Item.Builder itemBuilder = Item.newBuilder();
        if (!response.isFailed()) {
            DocWriteResponse docResponse = response.getResponse();
            responseItemBuilder = DocWriteResponseProtoUtils.toProto(docResponse);
            grpcStatusCode = RestToGrpcStatusConverter.getGrpcStatusCode(docResponse.status());
            responseItemBuilder.setStatus(grpcStatusCode);
        } else {
            BulkItemResponse.Failure failure = response.getFailure();
            responseItemBuilder = ResponseItem.newBuilder();
            responseItemBuilder.setIndex(failure.getIndex());
            if (response.getId().isEmpty()) {
                responseItemBuilder.setId(ResponseItem.Id.newBuilder().setNullValue(NullValue.NULL_VALUE_NULL).build());
            } else {
                responseItemBuilder.setId(ResponseItem.Id.newBuilder().setString(response.getId()).build());
            }
            grpcStatusCode = RestToGrpcStatusConverter.getGrpcStatusCode(failure.getStatus());
            responseItemBuilder.setStatus(grpcStatusCode);
            ErrorCause errorCause = OpenSearchExceptionProtoUtils.generateThrowableProto(failure.getCause());
            responseItemBuilder.setError(errorCause);
        }
        switch (response.getOpType()) {
            case CREATE: {
                ResponseItem responseItem = responseItemBuilder.build();
                itemBuilder.setCreate(responseItem);
                break;
            }
            case INDEX: {
                ResponseItem responseItem = responseItemBuilder.build();
                itemBuilder.setIndex(responseItem);
                break;
            }
            case UPDATE: {
                GetResult getResult;
                UpdateResponse updateResponse = (UpdateResponse)response.getResponse();
                if (updateResponse != null && (getResult = updateResponse.getGetResult()) != null) {
                    responseItemBuilder = GetResultProtoUtils.toProto(getResult, responseItemBuilder);
                }
                ResponseItem responseItem = responseItemBuilder.build();
                itemBuilder.setUpdate(responseItem);
                break;
            }
            case DELETE: {
                ResponseItem responseItem = responseItemBuilder.build();
                itemBuilder.setDelete(responseItem);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Invalid op type: " + String.valueOf(response.getOpType()));
            }
        }
        return itemBuilder.build();
    }
}

