/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.params.DsaParameterGenerationParameters;
import org.bouncycastle.crypto.internal.params.DsaParameters;
import org.bouncycastle.crypto.internal.params.DsaValidationParameters;
import org.bouncycastle.math.internal.Primes;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Hex;

class DsaParametersGenerator {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private Digest digest;
    private int L;
    private int N;
    private int certainty;
    private int iterations;
    private SecureRandom random;
    private int usageIndex;

    public DsaParametersGenerator(Digest digest) {
        this.digest = digest;
    }

    public void init(DsaParameterGenerationParameters dsaParameterGenerationParameters) {
        int n = dsaParameterGenerationParameters.getL();
        int n2 = dsaParameterGenerationParameters.getN();
        if (n < 1024 || n > 3072 || n % 1024 != 0) {
            throw new IllegalArgumentException("L values must be between 1024 and 3072 and a multiple of 1024");
        }
        if (n == 1024 && n2 != 160) {
            throw new IllegalArgumentException("N must be 160 for L = 1024");
        }
        if (n == 2048 && n2 != 224 && n2 != 256) {
            throw new IllegalArgumentException("N must be 224 or 256 for L = 2048");
        }
        if (n == 3072 && n2 != 256) {
            throw new IllegalArgumentException("N must be 256 for L = 3072");
        }
        if (this.digest.getDigestSize() * 8 < n2) {
            throw new IllegalStateException("Digest output size too small for value of N");
        }
        this.L = n;
        this.N = n2;
        this.certainty = dsaParameterGenerationParameters.getCertainty();
        this.iterations = Math.max(DsaParametersGenerator.getMinimumIterations(n), (this.certainty + 1) / 2);
        this.random = dsaParameterGenerationParameters.getRandom();
        this.usageIndex = dsaParameterGenerationParameters.getUsageIndex();
    }

    public DsaParameters generateParameters() {
        return this.generateParameters_FIPS186_3();
    }

    private static BigInteger calculateGenerator_FIPS186_2(BigInteger bigInteger, BigInteger bigInteger2, SecureRandom secureRandom) {
        BigInteger bigInteger3;
        BigInteger bigInteger4;
        BigInteger bigInteger5 = bigInteger.subtract(ONE).divide(bigInteger2);
        BigInteger bigInteger6 = bigInteger.subtract(TWO);
        while ((bigInteger4 = (bigInteger3 = BigIntegers.createRandomInRange(TWO, bigInteger6, secureRandom)).modPow(bigInteger5, bigInteger)).bitLength() <= 1) {
        }
        return bigInteger4;
    }

    /*
     * Unable to fully structure code
     */
    private DsaParameters generateParameters_FIPS186_3() {
        var1_1 = this.digest;
        var2_2 = var1_1.getDigestSize() * 8;
        var3_3 = this.N;
        var4_4 = new byte[var3_3 / 8];
        var5_5 = (this.L - 1) / var2_2;
        var6_6 = new byte[this.L / 8];
        var7_7 = new byte[var1_1.getDigestSize()];
        block0: while (true) {
            this.random.nextBytes(var4_4);
            DsaParametersGenerator.hash(var1_1, var4_4, var7_7, 0);
            var8_8 = new BigInteger(1, var7_7).mod(DsaParametersGenerator.ONE.shiftLeft(this.N - 1));
            var9_9 = var8_8.setBit(0).setBit(this.N - 1);
            if (!this.isProbablePrime(var9_9)) continue;
            var10_10 = Arrays.clone(var4_4);
            var11_11 = 4 * this.L;
            var12_12 = 0;
            while (true) {
                if (var12_12 < var11_11) ** break;
                continue block0;
                for (var13_14 = 1; var13_14 <= var5_5; ++var13_14) {
                    DsaParametersGenerator.inc(var10_10);
                    DsaParametersGenerator.hash(var1_1, var10_10, var6_6, var6_6.length - var13_14 * var7_7.length);
                }
                var13_14 = var6_6.length - var5_5 * var7_7.length;
                DsaParametersGenerator.inc(var10_10);
                DsaParametersGenerator.hash(var1_1, var10_10, var7_7, 0);
                System.arraycopy(var7_7, var7_7.length - var13_14, var6_6, 0, var13_14);
                var6_6[0] = (byte)(var6_6[0] | -128);
                var13_13 = new BigInteger(1, var6_6);
                var14_15 = var13_13.mod(var9_9.shiftLeft(1));
                var15_16 = var13_13.subtract(var14_15.subtract(DsaParametersGenerator.ONE));
                if (var15_16.bitLength() == this.L && this.isProbablePrime(var15_16)) {
                    if (this.usageIndex >= 0 && (var16_17 = DsaParametersGenerator.calculateGenerator_FIPS186_3_Verifiable(var1_1, var15_16, var9_9, var4_4, this.usageIndex)) != null) {
                        return new DsaParameters(var15_16, var9_9, var16_17, new DsaValidationParameters(var4_4, var12_12, this.usageIndex));
                    }
                    var16_17 = DsaParametersGenerator.calculateGenerator_FIPS186_3_Unverifiable(var15_16, var9_9, this.random);
                    return new DsaParameters(var15_16, var9_9, var16_17, new DsaValidationParameters(var4_4, var12_12));
                }
                ++var12_12;
            }
            break;
        }
    }

    private boolean isProbablePrime(BigInteger bigInteger) {
        return !Primes.hasAnySmallFactors(bigInteger) && Primes.isMRProbablePrime(bigInteger, this.random, this.iterations);
    }

    static BigInteger calculateGenerator_FIPS186_3_Unverifiable(BigInteger bigInteger, BigInteger bigInteger2, SecureRandom secureRandom) {
        return DsaParametersGenerator.calculateGenerator_FIPS186_2(bigInteger, bigInteger2, secureRandom);
    }

    static BigInteger calculateGenerator_FIPS186_3_Verifiable(Digest digest, BigInteger bigInteger, BigInteger bigInteger2, byte[] byArray, int n) {
        if ((n & 0xFF) != n) {
            throw new IllegalArgumentException("Usage index must be in range 0 to 255");
        }
        BigInteger bigInteger3 = bigInteger.subtract(ONE).divide(bigInteger2);
        byte[] byArray2 = Hex.decode("6767656E");
        byte[] byArray3 = new byte[byArray.length + byArray2.length + 1 + 2];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        byArray3[byArray3.length - 3] = (byte)n;
        byte[] byArray4 = new byte[digest.getDigestSize()];
        for (int i = 1; i < 65536; ++i) {
            DsaParametersGenerator.inc(byArray3);
            DsaParametersGenerator.hash(digest, byArray3, byArray4, 0);
            BigInteger bigInteger4 = new BigInteger(1, byArray4);
            BigInteger bigInteger5 = bigInteger4.modPow(bigInteger3, bigInteger);
            if (bigInteger5.compareTo(TWO) < 0) continue;
            return bigInteger5;
        }
        return null;
    }

    private static void hash(Digest digest, byte[] byArray, byte[] byArray2, int n) {
        digest.update(byArray, 0, byArray.length);
        digest.doFinal(byArray2, n);
    }

    private static int getMinimumIterations(int n) {
        return n <= 1024 ? 40 : 48 + 8 * ((n - 1) / 1024);
    }

    private static void inc(byte[] byArray) {
        for (int i = byArray.length - 1; i >= 0; --i) {
            byte by;
            byArray[i] = by = (byte)(byArray[i] + 1 & 0xFF);
            if (by != 0) break;
        }
    }
}

