/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.SecurityGroupVpcAssociationState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SecurityGroupVpcAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SecurityGroupVpcAssociation> {
    private static final SdkField<String> GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupId").getter(SecurityGroupVpcAssociation.getter(SecurityGroupVpcAssociation::groupId)).setter(SecurityGroupVpcAssociation.setter(Builder::groupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").unmarshallLocationName("groupId").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(SecurityGroupVpcAssociation.getter(SecurityGroupVpcAssociation::vpcId)).setter(SecurityGroupVpcAssociation.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").unmarshallLocationName("vpcId").build()}).build();
    private static final SdkField<String> VPC_OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcOwnerId").getter(SecurityGroupVpcAssociation.getter(SecurityGroupVpcAssociation::vpcOwnerId)).setter(SecurityGroupVpcAssociation.setter(Builder::vpcOwnerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcOwnerId").unmarshallLocationName("vpcOwnerId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(SecurityGroupVpcAssociation.getter(SecurityGroupVpcAssociation::stateAsString)).setter(SecurityGroupVpcAssociation.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<String> STATE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateReason").getter(SecurityGroupVpcAssociation.getter(SecurityGroupVpcAssociation::stateReason)).setter(SecurityGroupVpcAssociation.setter(Builder::stateReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason").unmarshallLocationName("stateReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_ID_FIELD, VPC_ID_FIELD, VPC_OWNER_ID_FIELD, STATE_FIELD, STATE_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SecurityGroupVpcAssociation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String groupId;
    private final String vpcId;
    private final String vpcOwnerId;
    private final String state;
    private final String stateReason;

    private SecurityGroupVpcAssociation(BuilderImpl builder) {
        this.groupId = builder.groupId;
        this.vpcId = builder.vpcId;
        this.vpcOwnerId = builder.vpcOwnerId;
        this.state = builder.state;
        this.stateReason = builder.stateReason;
    }

    public final String groupId() {
        return this.groupId;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final String vpcOwnerId() {
        return this.vpcOwnerId;
    }

    public final SecurityGroupVpcAssociationState state() {
        return SecurityGroupVpcAssociationState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String stateReason() {
        return this.stateReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityGroupVpcAssociation)) {
            return false;
        }
        SecurityGroupVpcAssociation other = (SecurityGroupVpcAssociation)obj;
        return Objects.equals(this.groupId(), other.groupId()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.vpcOwnerId(), other.vpcOwnerId()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stateReason(), other.stateReason());
    }

    public final String toString() {
        return ToString.builder((String)"SecurityGroupVpcAssociation").add("GroupId", (Object)this.groupId()).add("VpcId", (Object)this.vpcId()).add("VpcOwnerId", (Object)this.vpcOwnerId()).add("State", (Object)this.stateAsString()).add("StateReason", (Object)this.stateReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupId": {
                return Optional.ofNullable(clazz.cast(this.groupId()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "VpcOwnerId": {
                return Optional.ofNullable(clazz.cast(this.vpcOwnerId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StateReason": {
                return Optional.ofNullable(clazz.cast(this.stateReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("GroupId", GROUP_ID_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        map.put("VpcOwnerId", VPC_OWNER_ID_FIELD);
        map.put("State", STATE_FIELD);
        map.put("StateReason", STATE_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SecurityGroupVpcAssociation, T> g) {
        return obj -> g.apply((SecurityGroupVpcAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String groupId;
        private String vpcId;
        private String vpcOwnerId;
        private String state;
        private String stateReason;

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityGroupVpcAssociation model) {
            this.groupId(model.groupId);
            this.vpcId(model.vpcId);
            this.vpcOwnerId(model.vpcOwnerId);
            this.state(model.state);
            this.stateReason(model.stateReason);
        }

        public final String getGroupId() {
            return this.groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getVpcOwnerId() {
            return this.vpcOwnerId;
        }

        public final void setVpcOwnerId(String vpcOwnerId) {
            this.vpcOwnerId = vpcOwnerId;
        }

        @Override
        public final Builder vpcOwnerId(String vpcOwnerId) {
            this.vpcOwnerId = vpcOwnerId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(SecurityGroupVpcAssociationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStateReason() {
            return this.stateReason;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public SecurityGroupVpcAssociation build() {
            return new SecurityGroupVpcAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SecurityGroupVpcAssociation> {
        public Builder groupId(String var1);

        public Builder vpcId(String var1);

        public Builder vpcOwnerId(String var1);

        public Builder state(String var1);

        public Builder state(SecurityGroupVpcAssociationState var1);

        public Builder stateReason(String var1);
    }
}

