/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.info;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.nodes.info.NodeInfoIngestProcessor;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class NodeInfoSearchPipelines
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, NodeInfoSearchPipelines> {
    @Nonnull
    private final List<NodeInfoIngestProcessor> requestProcessors;
    @Nonnull
    private final List<NodeInfoIngestProcessor> responseProcessors;
    public static final JsonpDeserializer<NodeInfoSearchPipelines> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeInfoSearchPipelines::setupNodeInfoSearchPipelinesDeserializer);

    private NodeInfoSearchPipelines(Builder builder) {
        this.requestProcessors = ApiTypeHelper.unmodifiable(builder.requestProcessors);
        this.responseProcessors = ApiTypeHelper.unmodifiable(builder.responseProcessors);
    }

    public static NodeInfoSearchPipelines of(Function<Builder, ObjectBuilder<NodeInfoSearchPipelines>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<NodeInfoIngestProcessor> requestProcessors() {
        return this.requestProcessors;
    }

    @Nonnull
    public final List<NodeInfoIngestProcessor> responseProcessors() {
        return this.responseProcessors;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.requestProcessors)) {
            generator.writeKey("request_processors");
            generator.writeStartArray();
            for (NodeInfoIngestProcessor item0 : this.requestProcessors) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.responseProcessors)) {
            generator.writeKey("response_processors");
            generator.writeStartArray();
            for (NodeInfoIngestProcessor item0 : this.responseProcessors) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupNodeInfoSearchPipelinesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::requestProcessors, JsonpDeserializer.arrayDeserializer(NodeInfoIngestProcessor._DESERIALIZER), "request_processors");
        op.add(Builder::responseProcessors, JsonpDeserializer.arrayDeserializer(NodeInfoIngestProcessor._DESERIALIZER), "response_processors");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.requestProcessors);
        result = 31 * result + Objects.hashCode(this.responseProcessors);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeInfoSearchPipelines other = (NodeInfoSearchPipelines)o;
        return Objects.equals(this.requestProcessors, other.requestProcessors) && Objects.equals(this.responseProcessors, other.responseProcessors);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, NodeInfoSearchPipelines> {
        @Nullable
        private List<NodeInfoIngestProcessor> requestProcessors;
        @Nullable
        private List<NodeInfoIngestProcessor> responseProcessors;

        public Builder() {
        }

        private Builder(NodeInfoSearchPipelines o) {
            this.requestProcessors = Builder._listCopy(o.requestProcessors);
            this.responseProcessors = Builder._listCopy(o.responseProcessors);
        }

        private Builder(Builder o) {
            this.requestProcessors = Builder._listCopy(o.requestProcessors);
            this.responseProcessors = Builder._listCopy(o.responseProcessors);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder requestProcessors(List<NodeInfoIngestProcessor> list) {
            this.requestProcessors = Builder._listAddAll(this.requestProcessors, list);
            return this;
        }

        @Nonnull
        public final Builder requestProcessors(NodeInfoIngestProcessor value, NodeInfoIngestProcessor ... values) {
            this.requestProcessors = Builder._listAdd(this.requestProcessors, value, values);
            return this;
        }

        @Nonnull
        public final Builder requestProcessors(Function<NodeInfoIngestProcessor.Builder, ObjectBuilder<NodeInfoIngestProcessor>> fn) {
            return this.requestProcessors(fn.apply(new NodeInfoIngestProcessor.Builder()).build(), new NodeInfoIngestProcessor[0]);
        }

        @Nonnull
        public final Builder responseProcessors(List<NodeInfoIngestProcessor> list) {
            this.responseProcessors = Builder._listAddAll(this.responseProcessors, list);
            return this;
        }

        @Nonnull
        public final Builder responseProcessors(NodeInfoIngestProcessor value, NodeInfoIngestProcessor ... values) {
            this.responseProcessors = Builder._listAdd(this.responseProcessors, value, values);
            return this;
        }

        @Nonnull
        public final Builder responseProcessors(Function<NodeInfoIngestProcessor.Builder, ObjectBuilder<NodeInfoIngestProcessor>> fn) {
            return this.responseProcessors(fn.apply(new NodeInfoIngestProcessor.Builder()).build(), new NodeInfoIngestProcessor[0]);
        }

        @Override
        @Nonnull
        public NodeInfoSearchPipelines build() {
            this._checkSingleUse();
            return new NodeInfoSearchPipelines(this);
        }
    }
}

