/*
 * Decompiled with CFR 0.152.
 */
package org.a11y.brlapi;

import java.io.File;
import org.a11y.brlapi.NativeComponent;
import org.a11y.brlapi.Parse;
import org.a11y.brlapi.SyntaxException;

public class ConnectionSettings
extends NativeComponent {
    public static final char HOST_PORT_SEPARATOR = ':';
    public static final String DEFAULT_HOST_NAME = "";
    public static final int MINIMUM_PORT_NUMBER = 0;
    public static final int MAXIMUM_PORT_NUMBER = 99;
    public static final int DEFAULT_PORT_NUMBER = 0;
    public static final String DEFAULT_SERVER_HOST = ":0";
    private String serverHost = null;
    public static final char AUTHENTICATION_SCHEME_SEPARATOR = '+';
    public static final char AUTHENTICATION_OPERAND_PREFIX = ':';
    public static final String AUTHENTICATION_SCHEME_KEYFILE = "keyfile";
    public static final String AUTHENTICATION_SCHEME_NONE = "none";
    public static final String AUTHENTICATION_KEYFILE_DIRECTORY = ConnectionSettings.getKeyfileDirectory();
    public static final String AUTHENTICATION_KEYFILE_NAME = ConnectionSettings.getKeyfileName();
    public static final String DEFAULT_AUTHENTICATION_SCHEME;
    private String authenticationScheme = null;

    public static void checkHostSpecification(String string) {
        int n = string.indexOf(58);
        if (n == 0) {
            return;
        }
        if (n < 0) {
            string = String.format("%s%c%s", string, Character.valueOf(':'), 0);
        } else {
            String string2 = string.substring(n + 1);
            if (string2.isEmpty()) {
                throw new IllegalArgumentException("missing port number");
            }
            try {
                Parse.asInt("port number", string2, 0, 99);
            }
            catch (SyntaxException syntaxException) {
                throw new IllegalArgumentException(syntaxException.getMessage());
            }
        }
    }

    public final ConnectionSettings setServerHost(String string) {
        ConnectionSettings.checkHostSpecification(string);
        this.serverHost = string;
        return this;
    }

    public final String getServerHost() {
        return this.serverHost;
    }

    private static native String getKeyfileDirectory();

    private static native String getKeyfileName();

    public static void checkAuthenticationScheme(String string) {
    }

    public final ConnectionSettings setAuthenticationScheme(String string) {
        ConnectionSettings.checkAuthenticationScheme(string);
        this.authenticationScheme = string;
        return this;
    }

    public final String getAuthenticationScheme() {
        return this.authenticationScheme;
    }

    public ConnectionSettings() {
        this.setServerHost(DEFAULT_SERVER_HOST);
        this.setAuthenticationScheme(DEFAULT_AUTHENTICATION_SCHEME);
    }

    public String toString() {
        return String.format("Server:%s Scheme:%s", this.serverHost, this.authenticationScheme);
    }

    static {
        StringBuilder stringBuilder = new StringBuilder();
        File file = new File(AUTHENTICATION_KEYFILE_DIRECTORY, AUTHENTICATION_KEYFILE_NAME);
        if (file.isFile() && file.canRead()) {
            stringBuilder.append(AUTHENTICATION_SCHEME_KEYFILE).append(':').append(file.getAbsolutePath());
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append('+');
        }
        stringBuilder.append(AUTHENTICATION_SCHEME_NONE);
        DEFAULT_AUTHENTICATION_SCHEME = stringBuilder.toString();
    }
}

