/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.util.io;

import io.sf.carte.echosvg.util.io.AbstractCharDecoder;
import java.io.IOException;
import java.io.InputStream;

public class UTF16Decoder
extends AbstractCharDecoder {
    protected boolean bigEndian;

    public UTF16Decoder(InputStream inputStream) throws IOException {
        super(inputStream);
        int n;
        int n2 = inputStream.read();
        if (n2 == -1) {
            this.endOfStreamError("UTF-16");
        }
        if ((n = inputStream.read()) == -1) {
            this.endOfStreamError("UTF-16");
        }
        int n3 = (n2 & 0xFF) << 8 | n & 0xFF;
        switch (n3) {
            case 65279: {
                this.bigEndian = true;
                break;
            }
            case 65534: {
                break;
            }
            default: {
                this.charError("UTF-16");
            }
        }
    }

    public UTF16Decoder(InputStream inputStream, boolean bl) {
        super(inputStream);
        this.bigEndian = bl;
    }

    @Override
    public int readChar() throws IOException {
        int n;
        if (this.position == this.count) {
            this.fillBuffer();
        }
        if (this.count == -1) {
            return -1;
        }
        byte by = this.buffer[this.position++];
        if (this.position == this.count) {
            this.fillBuffer();
        }
        if (this.count == -1) {
            this.endOfStreamError("UTF-16");
        }
        byte by2 = this.buffer[this.position++];
        int n2 = n = this.bigEndian ? (by & 0xFF) << 8 | by2 & 0xFF : (by2 & 0xFF) << 8 | by & 0xFF;
        if (n == 65534) {
            this.charError("UTF-16");
        }
        return n;
    }
}

