#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 crypto-api-tests
version:              0.3
visibility:           public
id:                   crypto-api-tests-0.3-AULM9xiIhqfL7JJrikEAgN
key:                  crypto-api-tests-0.3-AULM9xiIhqfL7JJrikEAgN
license:              BSD-3-Clause
copyright:            Thomas DuBuisson <thomas.dubuisson@gmail.com>
maintainer:           Thomas DuBuisson <thomas.dubuisson@gmail.com>
author:               Thomas DuBuisson <thomas.dubuisson@gmail.com>
stability:            stable
homepage:             http://trac.haskell.org/crypto-api/wiki
synopsis:             A test framework and KATs for cryptographic operations.
description:
    A test framework for hash and cipher operations using
    the crypto-api interface.  Known answer tests (KATs)
    for common cryptographic algorithms are included.
    Patches welcome (both adding KATs for more algorithms
    or property tests for classes of algorithms).

category:             Data, Cryptography
abi:                  32cfad0731c092aa1c0b3628234c7dac
exposed:              True
exposed-modules:
    Test.AES Test.Crypto Test.HMAC Test.MD5 Test.ParseNistKATs Test.SHA
    Test.TwoFish

hidden-modules:       Paths_crypto_api_tests
import-dirs:          /usr/lib/ghc-9.6.6/site-local/crypto-api-tests-0.3
library-dirs:         /usr/lib/ghc-9.6.6/site-local/crypto-api-tests-0.3
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/crypto-api-tests-0.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-crypto-api-tests
hs-libraries:         HScrypto-api-tests-0.3-AULM9xiIhqfL7JJrikEAgN
depends:
    HUnit-1.6.2.0-DydRkK1Ty562EFYgxreweA
    QuickCheck-2.15.0.1-6GEGPgW6PY5CA5PnU98uYH base-4.18.2.1
    bytestring-0.11.5.3 cereal-0.5.8.3-9zr3eQnzv374L09nXO1NoK
    crypto-api-0.13.3-7R6mWxyWT8b203JTOR7lix directory-1.3.8.5
    filepath-1.4.300.1 test-framework-0.8.2.2-EM8kiKm25FCGayYh4hhDp3
    test-framework-hunit-0.3.0.2-aLzulGsImjAFGW57e7Q25
    test-framework-quickcheck2-0.3.0.6-CnlikwfFH83Gij8cDbcvCU

haddock-interfaces:
    /usr/share/doc/haskell-crypto-api-tests/html/crypto-api-tests.haddock

haddock-html:         /usr/share/doc/haskell-crypto-api-tests/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

