/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Measures the similarity between the set of non-zero pixels of two
images.


SimilarityIndexImageFilter measures the similarity between the set non-zero pixels of two images
using the following formula: \\[ S = \\frac{2 | A \\cap B |}{|A| + |B|} \\] where $A$ and $B$ are respectively the set of non-zero pixels in the first and second
input images. Operator $|\\cdot|$ represents the size of a set and $\\cap$ represents the intersection of two sets.

The measure is derived from a reliability measure known as the kappa
statistic. $S$ is sensitive to both differences in size and in location and have
been in the literature for comparing two segmentation masks. For more
information see: "Morphometric Analysis of White Matter Lesions in MR
Images: Method and Validation", A. P. Zijdenbos, B. M. Dawant, R. A.
Margolin and A. C. Palmer, IEEE Trans. on Medical Imaging, 13(4) pp
716-724,1994

This filter requires the largest possible region of the first image
and the same corresponding region in the second image. It behaves as
filter with two input and one output. Thus it can be inserted in a
pipeline with other filters. The filter passes the first input through
unmodified.

This filter is templated over the two input image type. It assume both
image have the same number of dimensions.


See:
 itk::SimilarityIndexImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkSimilarityIndexImageFilter.h
*/
public class SimilarityIndexImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected SimilarityIndexImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.SimilarityIndexImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(SimilarityIndexImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(SimilarityIndexImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::SimilarityIndexImageFilter::~SimilarityIndexImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_SimilarityIndexImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::SimilarityIndexImageFilter::SimilarityIndexImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  SimilarityIndexImageFilter() {
    this(SimpleITKJNI.new_SimilarityIndexImageFilter(), true);
  }

  /**
double itk::simple::SimilarityIndexImageFilter::GetSimilarityIndex() const

Return the computed similarity index.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  double getSimilarityIndex() {
    return SimpleITKJNI.SimilarityIndexImageFilter_getSimilarityIndex(swigCPtr, this);
  }

  /**
std::string itk::simple::SimilarityIndexImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.SimilarityIndexImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::SimilarityIndexImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.SimilarityIndexImageFilter_toString(swigCPtr, this);
  }

  /**
void itk::simple::SimilarityIndexImageFilter::Execute(const Image &amp;image1, const Image &amp;image2)

Execute the filter on the input images

*/
public  void execute(Image image1, Image image2) {
    SimpleITKJNI.SimilarityIndexImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1, Image.getCPtr(image2), image2);
  }

}
