/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.SpotInstanceRequest;
import software.amazon.awssdk.services.ec2.model.SpotInstanceRequestListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSpotInstanceRequestsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeSpotInstanceRequestsResponse> {
    private static final SdkField<List<SpotInstanceRequest>> SPOT_INSTANCE_REQUESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SpotInstanceRequests").getter(DescribeSpotInstanceRequestsResponse.getter(DescribeSpotInstanceRequestsResponse::spotInstanceRequests)).setter(DescribeSpotInstanceRequestsResponse.setter(Builder::spotInstanceRequests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotInstanceRequestSet").unmarshallLocationName("spotInstanceRequestSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SpotInstanceRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeSpotInstanceRequestsResponse.getter(DescribeSpotInstanceRequestsResponse::nextToken)).setter(DescribeSpotInstanceRequestsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPOT_INSTANCE_REQUESTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeSpotInstanceRequestsResponse.memberNameToFieldInitializer();
    private final List<SpotInstanceRequest> spotInstanceRequests;
    private final String nextToken;

    private DescribeSpotInstanceRequestsResponse(BuilderImpl builder) {
        super(builder);
        this.spotInstanceRequests = builder.spotInstanceRequests;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSpotInstanceRequests() {
        return this.spotInstanceRequests != null && !(this.spotInstanceRequests instanceof SdkAutoConstructList);
    }

    public final List<SpotInstanceRequest> spotInstanceRequests() {
        return this.spotInstanceRequests;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSpotInstanceRequests() ? this.spotInstanceRequests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSpotInstanceRequestsResponse)) {
            return false;
        }
        DescribeSpotInstanceRequestsResponse other = (DescribeSpotInstanceRequestsResponse)((Object)obj);
        return this.hasSpotInstanceRequests() == other.hasSpotInstanceRequests() && Objects.equals(this.spotInstanceRequests(), other.spotInstanceRequests()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeSpotInstanceRequestsResponse").add("SpotInstanceRequests", this.hasSpotInstanceRequests() ? this.spotInstanceRequests() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SpotInstanceRequests": {
                return Optional.ofNullable(clazz.cast(this.spotInstanceRequests()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SpotInstanceRequestSet", SPOT_INSTANCE_REQUESTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeSpotInstanceRequestsResponse, T> g) {
        return obj -> g.apply((DescribeSpotInstanceRequestsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<SpotInstanceRequest> spotInstanceRequests = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSpotInstanceRequestsResponse model) {
            super(model);
            this.spotInstanceRequests(model.spotInstanceRequests);
            this.nextToken(model.nextToken);
        }

        public final List<SpotInstanceRequest.Builder> getSpotInstanceRequests() {
            List<SpotInstanceRequest.Builder> result = SpotInstanceRequestListCopier.copyToBuilder(this.spotInstanceRequests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSpotInstanceRequests(Collection<SpotInstanceRequest.BuilderImpl> spotInstanceRequests) {
            this.spotInstanceRequests = SpotInstanceRequestListCopier.copyFromBuilder(spotInstanceRequests);
        }

        @Override
        public final Builder spotInstanceRequests(Collection<SpotInstanceRequest> spotInstanceRequests) {
            this.spotInstanceRequests = SpotInstanceRequestListCopier.copy(spotInstanceRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spotInstanceRequests(SpotInstanceRequest ... spotInstanceRequests) {
            this.spotInstanceRequests(Arrays.asList(spotInstanceRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spotInstanceRequests(Consumer<SpotInstanceRequest.Builder> ... spotInstanceRequests) {
            this.spotInstanceRequests(Stream.of(spotInstanceRequests).map(c -> (SpotInstanceRequest)((SpotInstanceRequest.Builder)SpotInstanceRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeSpotInstanceRequestsResponse build() {
            return new DescribeSpotInstanceRequestsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSpotInstanceRequestsResponse> {
        public Builder spotInstanceRequests(Collection<SpotInstanceRequest> var1);

        public Builder spotInstanceRequests(SpotInstanceRequest ... var1);

        public Builder spotInstanceRequests(Consumer<SpotInstanceRequest.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

