/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.SnowballLanguage;
import org.opensearch.client.opensearch._types.analysis.TokenFilterBase;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinitionVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class SnowballTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant,
ToCopyableBuilder<Builder, SnowballTokenFilter> {
    @Nonnull
    private final SnowballLanguage language;
    public static final JsonpDeserializer<SnowballTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SnowballTokenFilter::setupSnowballTokenFilterDeserializer);

    private SnowballTokenFilter(Builder builder) {
        super(builder);
        this.language = ApiTypeHelper.requireNonNull(builder.language, this, "language");
    }

    public static SnowballTokenFilter of(Function<Builder, ObjectBuilder<SnowballTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.Snowball;
    }

    @Nonnull
    public final SnowballLanguage language() {
        return this.language;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "snowball");
        super.serializeInternal(generator, mapper);
        generator.writeKey("language");
        this.language.serialize(generator, mapper);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupSnowballTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        SnowballTokenFilter.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::language, SnowballLanguage._DESERIALIZER, "language");
        op.ignore("type");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.language.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnowballTokenFilter other = (SnowballTokenFilter)o;
        return this.language.equals(other.language);
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, SnowballTokenFilter> {
        private SnowballLanguage language;

        public Builder() {
        }

        private Builder(SnowballTokenFilter o) {
            super(o);
            this.language = o.language;
        }

        private Builder(Builder o) {
            super(o);
            this.language = o.language;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder language(SnowballLanguage value) {
            this.language = value;
            return this;
        }

        @Override
        @Nonnull
        public SnowballTokenFilter build() {
            this._checkSingleUse();
            return new SnowballTokenFilter(this);
        }
    }
}

