/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.transport.httpclient5;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.message.BasicHeader;
import org.opensearch.client.transport.TransportOptions;
import org.opensearch.client.transport.Version;
import org.opensearch.client.transport.httpclient5.ApacheHttpClient5Transport;
import org.opensearch.client.transport.httpclient5.HttpAsyncResponseConsumerFactory;
import org.opensearch.client.transport.httpclient5.WarningsHandler;

public class ApacheHttpClient5Options
implements TransportOptions {
    public static final ApacheHttpClient5Options DEFAULT = new Builder(Collections.emptyList(), HttpAsyncResponseConsumerFactory.HeapBufferedResponseConsumerFactory.DEFAULT, null, null).build();
    private final List<Header> headers;
    private final HttpAsyncResponseConsumerFactory httpAsyncResponseConsumerFactory;
    private final WarningsHandler warningsHandler;
    private final RequestConfig requestConfig;

    private ApacheHttpClient5Options(Builder builder) {
        this.headers = Collections.unmodifiableList(new ArrayList(builder.headers));
        this.httpAsyncResponseConsumerFactory = builder.httpAsyncResponseConsumerFactory;
        this.warningsHandler = builder.warningsHandler;
        this.requestConfig = builder.requestConfig;
    }

    public HttpAsyncResponseConsumerFactory getHttpAsyncResponseConsumerFactory() {
        return this.httpAsyncResponseConsumerFactory;
    }

    public WarningsHandler getWarningsHandler() {
        return this.warningsHandler;
    }

    public RequestConfig getRequestConfig() {
        return this.requestConfig;
    }

    @Override
    public Collection<Map.Entry<String, String>> headers() {
        return this.headers.stream().map(h -> new AbstractMap.SimpleImmutableEntry<String, String>(h.getName(), h.getValue())).collect(Collectors.toList());
    }

    @Override
    public Map<String, String> queryParameters() {
        return null;
    }

    @Override
    public Function<List<String>, Boolean> onWarnings() {
        if (this.warningsHandler == null) {
            return null;
        }
        return warnings -> this.warningsHandler.warningsShouldFailRequest((List<String>)warnings);
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this.headers, this.httpAsyncResponseConsumerFactory, this.warningsHandler, this.requestConfig);
    }

    static ApacheHttpClient5Options initialOptions() {
        String ua = String.format(Locale.ROOT, "opensearch-java/%s (Java/%s)", Version.VERSION == null ? "Unknown" : Version.VERSION.toString(), System.getProperty("java.version"));
        return new ApacheHttpClient5Options(DEFAULT.toBuilder().addHeader("User-Agent", ua).addHeader("Accept", ApacheHttpClient5Transport.JsonContentType.toString()));
    }

    static ApacheHttpClient5Options of(TransportOptions options) {
        if (options instanceof ApacheHttpClient5Options) {
            return (ApacheHttpClient5Options)options;
        }
        Builder builder = new Builder(DEFAULT.toBuilder());
        options.headers().forEach(h -> builder.addHeader((String)h.getKey(), (String)h.getValue()));
        options.queryParameters().forEach(builder::setParameter);
        builder.onWarnings(options.onWarnings());
        return builder.build();
    }

    public static class Builder
    implements TransportOptions.Builder {
        private final List<Header> headers;
        private HttpAsyncResponseConsumerFactory httpAsyncResponseConsumerFactory;
        private WarningsHandler warningsHandler;
        private RequestConfig requestConfig;

        private Builder(Builder builder) {
            this(builder.headers, builder.httpAsyncResponseConsumerFactory, builder.warningsHandler, builder.requestConfig);
        }

        private Builder(List<Header> headers, HttpAsyncResponseConsumerFactory httpAsyncResponseConsumerFactory, WarningsHandler warningsHandler, RequestConfig requestConfig) {
            this.headers = new ArrayList<Header>(headers);
            this.httpAsyncResponseConsumerFactory = httpAsyncResponseConsumerFactory;
            this.warningsHandler = warningsHandler;
            this.requestConfig = requestConfig;
        }

        @Override
        public Builder addHeader(String name, String value) {
            Objects.requireNonNull(name, "header name cannot be null");
            Objects.requireNonNull(value, "header value cannot be null");
            this.headers.add((Header)new ReqHeader(name, value));
            return this;
        }

        @Override
        public TransportOptions.Builder setParameter(String name, String value) {
            return this;
        }

        @Override
        public TransportOptions.Builder onWarnings(Function<List<String>, Boolean> listener) {
            if (listener == null) {
                this.setWarningsHandler(null);
            } else {
                this.setWarningsHandler(w -> {
                    if (w != null && !w.isEmpty()) {
                        return (Boolean)listener.apply(w);
                    }
                    return false;
                });
            }
            return this;
        }

        public void setHttpAsyncResponseConsumerFactory(HttpAsyncResponseConsumerFactory httpAsyncResponseConsumerFactory) {
            this.httpAsyncResponseConsumerFactory = Objects.requireNonNull(httpAsyncResponseConsumerFactory, "httpAsyncResponseConsumerFactory cannot be null");
        }

        public void setWarningsHandler(WarningsHandler warningsHandler) {
            this.warningsHandler = warningsHandler;
        }

        public Builder setRequestConfig(RequestConfig requestConfig) {
            this.requestConfig = requestConfig;
            return this;
        }

        @Override
        public ApacheHttpClient5Options build() {
            return new ApacheHttpClient5Options(this);
        }
    }

    static final class ReqHeader
    extends BasicHeader {
        ReqHeader(String name, String value) {
            super(name, (Object)value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof ReqHeader) {
                Header otherHeader = (Header)other;
                return Objects.equals(this.getName(), otherHeader.getName()) && Objects.equals(this.getValue(), otherHeader.getValue());
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.getName(), this.getValue());
        }
    }
}

