/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.dynamodb.itemencryptor.model;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.CryptoAction;
import software.amazon.cryptography.materialproviders.model.DBEAlgorithmSuiteId;
import software.amazon.cryptography.materialproviders.model.EncryptedDataKey;

public class ParsedHeader {
    private final Map<String, CryptoAction> attributeActionsOnEncrypt;
    private final DBEAlgorithmSuiteId algorithmSuiteId;
    private final List<EncryptedDataKey> encryptedDataKeys;
    private final Map<String, String> storedEncryptionContext;
    private final Map<String, String> encryptionContext;
    private final Map<String, AttributeValue> selectorContext;

    protected ParsedHeader(BuilderImpl builder) {
        this.attributeActionsOnEncrypt = builder.attributeActionsOnEncrypt();
        this.algorithmSuiteId = builder.algorithmSuiteId();
        this.encryptedDataKeys = builder.encryptedDataKeys();
        this.storedEncryptionContext = builder.storedEncryptionContext();
        this.encryptionContext = builder.encryptionContext();
        this.selectorContext = builder.selectorContext();
    }

    public Map<String, CryptoAction> attributeActionsOnEncrypt() {
        return this.attributeActionsOnEncrypt;
    }

    public DBEAlgorithmSuiteId algorithmSuiteId() {
        return this.algorithmSuiteId;
    }

    public List<EncryptedDataKey> encryptedDataKeys() {
        return this.encryptedDataKeys;
    }

    public Map<String, String> storedEncryptionContext() {
        return this.storedEncryptionContext;
    }

    public Map<String, String> encryptionContext() {
        return this.encryptionContext;
    }

    public Map<String, AttributeValue> selectorContext() {
        return this.selectorContext;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected Map<String, CryptoAction> attributeActionsOnEncrypt;
        protected DBEAlgorithmSuiteId algorithmSuiteId;
        protected List<EncryptedDataKey> encryptedDataKeys;
        protected Map<String, String> storedEncryptionContext;
        protected Map<String, String> encryptionContext;
        protected Map<String, AttributeValue> selectorContext;

        protected BuilderImpl() {
        }

        protected BuilderImpl(ParsedHeader model) {
            this.attributeActionsOnEncrypt = model.attributeActionsOnEncrypt();
            this.algorithmSuiteId = model.algorithmSuiteId();
            this.encryptedDataKeys = model.encryptedDataKeys();
            this.storedEncryptionContext = model.storedEncryptionContext();
            this.encryptionContext = model.encryptionContext();
            this.selectorContext = model.selectorContext();
        }

        @Override
        public Builder attributeActionsOnEncrypt(Map<String, CryptoAction> attributeActionsOnEncrypt) {
            this.attributeActionsOnEncrypt = attributeActionsOnEncrypt;
            return this;
        }

        @Override
        public Map<String, CryptoAction> attributeActionsOnEncrypt() {
            return this.attributeActionsOnEncrypt;
        }

        @Override
        public Builder algorithmSuiteId(DBEAlgorithmSuiteId algorithmSuiteId) {
            this.algorithmSuiteId = algorithmSuiteId;
            return this;
        }

        @Override
        public DBEAlgorithmSuiteId algorithmSuiteId() {
            return this.algorithmSuiteId;
        }

        @Override
        public Builder encryptedDataKeys(List<EncryptedDataKey> encryptedDataKeys) {
            this.encryptedDataKeys = encryptedDataKeys;
            return this;
        }

        @Override
        public List<EncryptedDataKey> encryptedDataKeys() {
            return this.encryptedDataKeys;
        }

        @Override
        public Builder storedEncryptionContext(Map<String, String> storedEncryptionContext) {
            this.storedEncryptionContext = storedEncryptionContext;
            return this;
        }

        @Override
        public Map<String, String> storedEncryptionContext() {
            return this.storedEncryptionContext;
        }

        @Override
        public Builder encryptionContext(Map<String, String> encryptionContext) {
            this.encryptionContext = encryptionContext;
            return this;
        }

        @Override
        public Map<String, String> encryptionContext() {
            return this.encryptionContext;
        }

        @Override
        public Builder selectorContext(Map<String, AttributeValue> selectorContext) {
            this.selectorContext = selectorContext;
            return this;
        }

        @Override
        public Map<String, AttributeValue> selectorContext() {
            return this.selectorContext;
        }

        @Override
        public ParsedHeader build() {
            if (Objects.isNull(this.attributeActionsOnEncrypt())) {
                throw new IllegalArgumentException("Missing value for required field `attributeActionsOnEncrypt`");
            }
            if (Objects.isNull(this.algorithmSuiteId())) {
                throw new IllegalArgumentException("Missing value for required field `algorithmSuiteId`");
            }
            if (Objects.isNull(this.encryptedDataKeys())) {
                throw new IllegalArgumentException("Missing value for required field `encryptedDataKeys`");
            }
            if (Objects.isNull(this.storedEncryptionContext())) {
                throw new IllegalArgumentException("Missing value for required field `storedEncryptionContext`");
            }
            if (Objects.isNull(this.encryptionContext())) {
                throw new IllegalArgumentException("Missing value for required field `encryptionContext`");
            }
            if (Objects.isNull(this.selectorContext())) {
                throw new IllegalArgumentException("Missing value for required field `selectorContext`");
            }
            return new ParsedHeader(this);
        }
    }

    public static interface Builder {
        public Builder attributeActionsOnEncrypt(Map<String, CryptoAction> var1);

        public Map<String, CryptoAction> attributeActionsOnEncrypt();

        public Builder algorithmSuiteId(DBEAlgorithmSuiteId var1);

        public DBEAlgorithmSuiteId algorithmSuiteId();

        public Builder encryptedDataKeys(List<EncryptedDataKey> var1);

        public List<EncryptedDataKey> encryptedDataKeys();

        public Builder storedEncryptionContext(Map<String, String> var1);

        public Map<String, String> storedEncryptionContext();

        public Builder encryptionContext(Map<String, String> var1);

        public Map<String, String> encryptionContext();

        public Builder selectorContext(Map<String, AttributeValue> var1);

        public Map<String, AttributeValue> selectorContext();

        public ParsedHeader build();
    }
}

