/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.snaptracer.impl.timeline;

import java.util.ArrayList;
import java.util.List;
import org.graalvm.visualvm.lib.charts.Timeline;
import org.graalvm.visualvm.lib.charts.xy.synchronous.SynchronousXYItem;
import org.graalvm.visualvm.lib.profiler.snaptracer.ProbeItemDescriptor;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.timeline.TimelineXYItem;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.timeline.items.ValueItemDescriptor;

final class TimelineModel
implements Timeline {
    private static final int STORAGE_BUFFER_STEP = 50;
    private int bufferStep;
    private int valuesCount;
    private long[] timestamps;
    private long[][] values;
    private final List<TimelineXYItem> items = new ArrayList<TimelineXYItem>();

    TimelineModel() {
        this(50);
    }

    private TimelineModel(int bufferStep) {
        this.bufferStep = bufferStep;
        this.reset();
    }

    int getItemsCount() {
        return this.items.size();
    }

    TimelineXYItem[] createItems(ProbeItemDescriptor[] itemDescriptors) {
        int itemsCount = this.values == null ? 0 : this.values.length;
        int addedItemsCount = itemDescriptors.length;
        TimelineXYItem[] itemsArr = new TimelineXYItem[addedItemsCount];
        for (int i = 0; i < addedItemsCount; ++i) {
            if (itemDescriptors[i] instanceof ValueItemDescriptor) {
                ValueItemDescriptor d = (ValueItemDescriptor)itemDescriptors[i];
                itemsArr[i] = new TimelineXYItem(d.getName(), d.getMinValue(), d.getMaxValue(), itemsCount + i){

                    public long getYValue(int valueIndex) {
                        return TimelineModel.this.values[this.getIndex()][valueIndex];
                    }
                };
            }
            this.items.add(itemsArr[i]);
        }
        this.addItemsImpl(addedItemsCount);
        return itemsArr;
    }

    void removeItems(SynchronousXYItem[] removed) {
        this.removeItemsImpl(removed.length);
        int firstRemovedIndex = ((TimelineXYItem)removed[0]).getIndex();
        for (SynchronousXYItem item : removed) {
            this.items.remove(firstRemovedIndex);
        }
        for (int i = firstRemovedIndex; i < this.items.size(); ++i) {
            this.items.get(i).setIndex(i);
        }
    }

    void addValues(long timestamp, long[] newValues) {
        long lastTimestamp;
        this.updateStorage();
        long l = lastTimestamp = this.valuesCount == 0 ? -1L : this.timestamps[this.valuesCount - 1];
        if (lastTimestamp >= timestamp) {
            timestamp = lastTimestamp + 1L;
        }
        this.timestamps[this.valuesCount] = timestamp;
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i][this.valuesCount] = newValues[i];
        }
        ++this.valuesCount;
    }

    void reset() {
        this.valuesCount = 0;
        this.timestamps = null;
        if (this.values != null) {
            if (this.values.length == 0) {
                this.values = null;
            } else {
                for (int i = 0; i < this.values.length; ++i) {
                    this.values[i] = new long[0];
                }
            }
        }
    }

    private void addItemsImpl(int addedItemsCount) {
        int newItemsCount = (this.values == null ? 0 : this.values.length) + addedItemsCount;
        this.values = new long[newItemsCount][];
        this.reset();
    }

    private void removeItemsImpl(int removedItemsCount) {
        this.values = new long[this.values.length - removedItemsCount][];
        this.reset();
    }

    public int getTimestampsCount() {
        return this.valuesCount;
    }

    public long getTimestamp(int index) {
        return this.timestamps[index];
    }

    private void updateStorage() {
        block3: {
            block2: {
                if (this.timestamps != null) break block2;
                this.timestamps = new long[this.bufferStep];
                for (int i = 0; i < this.values.length; ++i) {
                    this.values[i] = new long[this.bufferStep];
                }
                break block3;
            }
            if (this.valuesCount != this.timestamps.length) break block3;
            this.timestamps = TimelineModel.extendArray(this.timestamps, this.bufferStep);
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = TimelineModel.extendArray(this.values[i], this.bufferStep);
            }
        }
    }

    private static long[] extendArray(long[] array, int extraLength) {
        int originalLength = array.length;
        long[] newArray = new long[originalLength + extraLength];
        System.arraycopy(array, 0, newArray, 0, originalLength);
        return newArray;
    }
}

