import ts from "typescript";

//#region src/rules/types.d.ts
interface Rule {
  name: string | RegExp;
  resolve: (context: ResolveContext) => void;
}
interface ResolveContext {
  binding: ts.BindingName | undefined;
  expression: ts.CallExpression;
  typescript: typeof ts;
  match: {
    (type: "signal", node: ts.Node, accessTypes: AccessType[]): void;
    (type: TriggerType, node: ts.Node): void;
  };
}
type AccessType = `.${string}` | "()" | `.${string}()`;
type TriggerType = "accessor" | "callback" | "effect";
//#endregion
export { AccessType, ResolveContext, Rule, TriggerType };