---
stage: Plan
group: Project Management
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: Epics, issues, milestones, and labels.
title: Plan and track work
---

Plan your work by creating requirements, issues, and epics. Schedule work
with milestones and track your team's time. Learn how to save time with
quick actions, see how GitLab renders Markdown text, and learn how to
use Git to interact with GitLab.

<!-- vale gitlab_base.Spelling = NO -->

<i class="fa-youtube-play" aria-hidden="true"></i>
For a thorough demo of Plan features, see
[Multi-team planning with GitLab Ultimate](https://www.youtube.com/watch?v=KmASFwSap7c).
In this video, Gabe describes a use case of a multi-team organization that uses GitLab
with Scaled Agile Framework (SAFe).
Alternatively, to learn how to map the SAFe to what you can do in GitLab see
[SAFe without silos in GitLab](https://about.gitlab.com/blog/2025/04/08/safe-without-silos-in-gitlab/).

<!-- vale gitlab_base.Spelling = YES -->

{{< cards >}}

- [Getting started](../user/get_started/get_started_planning_work.md)
- [Tutorial: Use GitLab for scrum](../tutorials/scrum_events/_index.md)
- [Tutorial: Use GitLab for Kanban](../tutorials/kanban/_index.md)
- [Labels](../user/project/labels.md)
- [Iterations](../user/group/iterations/_index.md)
- [Milestones](../user/project/milestones/_index.md)
- [Issues](../user/project/issues/_index.md)
- [Issue boards](../user/project/issue_board.md)
- [Comments and threads](../user/discussions/_index.md)
- [Tasks](../user/tasks.md)
- [Requirements](../user/project/requirements/_index.md)
- [Time tracking](../user/project/time_tracking.md)
- [CRM](../user/crm/_index.md)
- [Wikis](../user/project/wiki/_index.md)
- [Epics](../user/group/epics/_index.md)
- [Roadmaps](../user/group/roadmap/_index.md)
- [Objectives and key results](../user/okrs.md)
- [To-Do List](../user/todos.md)
- [Keyboard shortcuts](../user/shortcuts.md)
- [Quick actions](../user/project/quick_actions.md)
- [Markdown](../user/markdown.md)

{{< /cards >}}
