/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.util.Debug;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.n3.nanoxml.XMLElement;

public class OsConstraint
implements Serializable {
    private String family;
    private String name;
    private String version;
    private String arch;

    public OsConstraint(String string, String string2, String string3, String string4) {
        this.family = string != null ? string.toLowerCase() : null;
        this.name = string2 != null ? string2.toLowerCase() : null;
        this.version = string3 != null ? string3.toLowerCase() : null;
        this.arch = string4 != null ? string4.toLowerCase() : null;
    }

    public boolean matchCurrentSystem() {
        boolean bl = true;
        String string = System.getProperty("os.name").toLowerCase();
        if (this.arch != null && this.arch.length() != 0) {
            bl = System.getProperty("os.arch").toLowerCase().equals(this.arch);
        }
        if (bl && this.version != null && this.version.length() != 0) {
            bl = System.getProperty("os.version").toLowerCase().equals(this.version);
        }
        if (bl && this.name != null && this.name.length() != 0) {
            bl = string.equals(this.name);
        }
        if (bl && this.family != null) {
            if (this.family.equals("windows")) {
                bl = string.indexOf("windows") > -1;
            } else if (this.family.equals("mac")) {
                bl = string.indexOf("mac") > -1 && !string.endsWith("x");
            } else if (this.family.equals("unix")) {
                String string2 = System.getProperty("path.separator");
                bl = string.lastIndexOf("unix") > -1 || string.lastIndexOf("linux") > -1 || string.lastIndexOf("solaris") > -1 || string.lastIndexOf("sunos") > -1 || string.lastIndexOf("aix") > -1 || string.lastIndexOf("hpux") > -1 || string.lastIndexOf("hp-ux") > -1 || string.lastIndexOf("irix") > -1 || string.lastIndexOf("bsd") > -1 || string2.equals(":") && (!string.startsWith("mac") || string.endsWith("x"));
            }
        }
        return bl && (this.family != null || this.name != null || this.version != null || this.arch != null);
    }

    public static List getOsList(XMLElement xMLElement) {
        Object object;
        ArrayList<OsConstraint> arrayList = new ArrayList<OsConstraint>();
        Iterator iterator = xMLElement.getChildrenNamed("os").iterator();
        while (iterator.hasNext()) {
            object = (XMLElement)iterator.next();
            arrayList.add(new OsConstraint(((XMLElement)object).getAttribute("family", null), ((XMLElement)object).getAttribute("name", null), ((XMLElement)object).getAttribute("version", null), ((XMLElement)object).getAttribute("arch", null)));
        }
        object = xMLElement.getAttribute("os");
        if (object != null && ((String)object).length() > 0) {
            arrayList.add(new OsConstraint((String)object, null, null, null));
        }
        return arrayList;
    }

    public static boolean oneMatchesCurrentSystem(List list) {
        if (list == null) {
            return true;
        }
        Iterator iterator = list.iterator();
        if (!iterator.hasNext()) {
            return true;
        }
        while (iterator.hasNext()) {
            OsConstraint osConstraint = (OsConstraint)iterator.next();
            Debug.trace("checking if os constraints " + osConstraint + " match current OS");
            if (!osConstraint.matchCurrentSystem()) continue;
            Debug.trace("matched current OS.");
            return true;
        }
        Debug.trace("no match with current OS!");
        return false;
    }

    public static boolean oneMatchesCurrentSystem(XMLElement xMLElement) {
        return OsConstraint.oneMatchesCurrentSystem(OsConstraint.getOsList(xMLElement));
    }

    public void setFamily(String string) {
        this.family = string.toLowerCase();
    }

    public String getFamily() {
        return this.family;
    }

    public void setName(String string) {
        this.name = string.toLowerCase();
    }

    public String getName() {
        return this.name;
    }

    public void setVersion(String string) {
        this.version = string.toLowerCase();
    }

    public String getVersion() {
        return this.version;
    }

    public void setArch(String string) {
        this.arch = string.toLowerCase();
    }

    public String getArch() {
        return this.arch;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[Os ");
        stringBuffer.append(" family " + this.family);
        stringBuffer.append(" name " + this.name);
        stringBuffer.append(" version " + this.version);
        stringBuffer.append(" arch " + this.arch);
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }
}

