#!/bin/bash
######################################################
#NetKernel Startup Script
#v1.2.1
#(C) 2002-2009, 1060 Research Limited
######################################################

#Handle spaces in filenames for OSX
SAVEIFS=$IFS
IFS=$(echo -en "\n\b")

#Main Paths
INSTALLPATH="%INSTALL%"
BOOTLOADER_JAR="%BOOTLOADER%"

#####################
#Get local path
#####################
LIB=$INSTALLPATH/lib
EXT=$INSTALLPATH/lib/ext
#####################
#system properties
#####################
PROPS=-Djava.endorsed.dirs=$LIB/endorsed
PROPS="$PROPS -Dsun.net.client.defaultConnectTimeout=20000"
PROPS="$PROPS -Dsun.net.client.defaultReadTimeout=20000"
PROPS="$PROPS -Djava.awt.headless=false"
PROPS="$PROPS -Dten60.pid=1"   #Process id must be set when using 'netkernel' daemon
#####################
#Kernel ClassPath
#####################
CP=$BOOTLOADER_JAR
#####################
#Start Server
#####################
RUN=1
while [  $RUN -eq 1 ]; do
	
	#Main Execution
	java -Xmx128m -Xms128m $PROPS -Xdebug -Xrunjdwp:transport=dt_socket,address=8000,suspend=n,server=y  -cp $CP BootLoader $INSTALLPATH
 	
 	if [  $? != 100 ]; then
 		#Normal exit - reboot not requested
		RUN=0
 	fi
done
