package org.ten60.netkernel.protocolhandler.sjar;

import java.io.IOException;
import java.lang.reflect.*;
import java.net.URL;
import java.net.URLConnection;

/** Handler for the sjar: scheme URLs
 * @author tab
 */
public class Handler extends java.net.URLStreamHandler
{
	private static Object sProvider;
	private static Method sMethod;
	private static ClassLoader sClassLoader;
	
	public static void init(ClassLoader aClassLoader) 
	{	sClassLoader=aClassLoader;
	}
	
	public Handler()
	{	try
		{	Class providerClass = sClassLoader.loadClass("com.ten60.netkernel.module.encrypted.EncryptedClassLoaderProvider");
			Field f=providerClass.getField("sInstance");
			sProvider=f.get(null);
			sMethod=providerClass.getMethod("getInstance", new Class[]{String.class});
		}
		catch (Exception e)
		{	//silent ignore
		}
	}
	
	static ClassLoader getClassLoader(String aId)
	{	ClassLoader result=null;
		try
		{	result=(ClassLoader)sMethod.invoke(sProvider, new Object[]{aId});
		}
		catch (Exception e)
		{	//silent ignore
		}
		return result;
	}
	
	protected URLConnection openConnection(URL aURL) throws IOException
	{	return new EncryptedJarURLConnection(aURL);
	}
	
	
}
