<?xml version="1.0" encoding="UTF-8" ?>
<!--
****************
(C) 2005, 1060 Research Limited. All rights reserved.
Licensed under the 1060 Public License v1.0 - http://www.1060research.com/license
1060 is a registered trademark of 1060 Research Ltd.
**********
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="html"/>

	<xsl:param name="param"/>
	
    <xsl:template match="/">

<html>
	<head >
		<title>1060 Forum Installer</title>
		<!--<link href="/introspect/pub/css_introspect.css" rel="stylesheet" type="text/css"  />-->
	</head>
	<body>
		<style type="text/css">
		</style>
		<div class="outer2">
		<table width="100%" class="roundedbox">
		<tr>
			<td colspan="2" style="padding-bottom: 5px;">
			<!--<img src="xrl:img_forum" xrl:resolve="src" valign="middle"/>-->
			<div style="font-size: 75px;">
			1060 Forum
			</div>
			<span style="float: right; font-size: 25px; color: #807bff;">Installer</span>
			</td>
		</tr>
		</table>
		<h3>JDBC Installation Notes</h3>
		<p>
		Before you begin.  You must have a MySQL database v4 or higher.  You must also provide a MySQL JDBC driver jar file
		in the <code>&lt;install&gt;/modules/mod-db/lib/</code> directory. A JDBC driver  can be downloaded from <a href="http://www.mysql.org">MySQL</a>.
		After adding the driver to the mod_db module you must <a href="/ep+name@app_ext_introspect_coldrestart">restart</a> for it to be discovered by NetKernel - when you have restarted 
		come back to this <a href="/ep+name@app_forum_installer_start">installer app</a> to complete the installation.  If you already have a suitable driver
		complete the form below to set up the DB.
		</p>
		<p>
		Installation should be quite straightforward.  If you have problems make sure your Database administrator user permissions are correct and that
		the DBA user has login permissions to the database from the machine you are installing from.  This DBA user must have GRANT permissions as the
		installer creates a new user, "forum", for the forum database.
		</p>
		<xsl:if test="$param">
			<table>
					<tr>
						<td bgcolor="red">
						<h2>Error</h2>
						<div style="color: ffffff;">
						<xsl:value-of select="$param/descendant::ex[position()=last()]/message"/>
						</div>
						<div>
						Please check your database permissions.  The DB Admin account you use must have remote access
						and GRANT permissions.  Also make sure you have a MySQL JDBC driver installed in mod_db/lib/.
						</div>
						</td>
					</tr>
			</table>
		</xsl:if>
				
		<form action="/ep+name@app_forum_installer_start" method="post" class="roundedbox">
			<table>
				<tr>
					<td align="left" height="30" valign="bottom">
					<h3>Database Installation Connection</h3>
					</td>
				</tr>
				<tr>
					<td align="right">
					<label>Hostname 
							<input name="hostname">
								<xsl:attribute name="value"><xsl:value-of select="/nvp/hostname"/></xsl:attribute>
							</input>
					</label>
					</td>
				</tr>
				<tr>
					<td align="right">
					<label>MySQL Port 
						<input name="port">
							<xsl:choose>
								<xsl:when test="/nvp/port">
									<xsl:attribute name="value"><xsl:value-of select="/nvp/port"/></xsl:attribute>
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="value">3306</xsl:attribute>
								</xsl:otherwise>
							</xsl:choose>
						</input>
					</label>	
					</td>
				</tr>
				<tr>
					<td align="right">
					<label>DB Admin Username 
						<input name="dba">
							<xsl:attribute name="value"><xsl:value-of select="/nvp/dba"/></xsl:attribute>
						</input>
					</label>
					</td>
					<td>
						<div style="font-size: 10px;">A Database admin user with permissions to create a new database and new users</div>
					</td>
				</tr>
				<tr>
					<td align="right">
					<label>DB Admin Password
						<input  type="password" name="dbapwd">
							<xsl:attribute name="value"><xsl:value-of select="/nvp/dbapwd"/></xsl:attribute>
						</input>
					</label>
					</td>
					
				</tr>
				<tr>
					<td align="left" height="30" valign="bottom">
					<h3>forum</h3>
					</td>
				</tr>
				<tr>
					<td align="right">
					<label>forum Super Password
						<input  type="password" name="superpwd">
							<xsl:attribute name="value"><xsl:value-of select="/nvp/superpwd"/></xsl:attribute>
						</input>
					</label>
					</td>
					<td>
						<div style="font-size: 10px;">This is the password that will be given to user 'super' the main administrator for forum</div>
					</td>
				</tr>
				<tr>
					<td align="right">
						<input  type="submit" value="install forum"/>
					</td>
				</tr>
			</table>
			
		</form>
		</div>
	</body>
	
</html>

    </xsl:template>

</xsl:stylesheet> 
