<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="xml"/>

    <xsl:template match="/history">
	<svg:svg
	   id="hiloworld"
	   xmlns:svg="http://www.w3.org/2000/svg"
	   xmlns:xlink="http://www.w3.org/1999/xlink"
	   width="300"
	   height="270"
	   xml:space="preserve"
	   >
	   <svg:rect
	       style="font-size:12;fill:#ffffff;fill-rule:evenodd;stroke-width:1;stroke:none;stroke-opacity:1;fill-opacity:1;"
	       id="bg"
	       width="300"
	       height="270"
	       x="0"
	       y="0"
	       />
	   <svg:rect
	       style="font-size:12;fill:#59c674;fill-rule:evenodd;stroke-width:1;stroke:none;stroke-opacity:0.8627;fill-opacity:0.2617;"
	       id="rect622"
	       width="107.418512"
	       height="216.656895"
	       x="190.313569"
	       y="39.627957"
	       transform="matrix(1,0,-1.652672e-2,0.999863,0,0)"
	       />
	   <svg:rect
	       style="font-size:12;fill:#a991c4;fill-rule:evenodd;stroke-width:1;fill-opacity:0.6916;"
	       id="frame"
	       width="200"
	       height="200"
	       x="20"
	       y="20" 
	       />

	   <svg:text
		style="fill:black;stroke:none;font-family:helvetica;font-style:normal;font-weight:bold;font-size:12px;fill-opacity:1;stroke-opacity:1;stroke-width:1pt;stroke-linejoin:miter;stroke-linecap:butt;"
	       x="10"
	       y="10"
	       id="title">
		<svg:tspan id="tspan607">Hi-Lo World Results</svg:tspan>
	   </svg:text>
	   <xsl:for-each select="turn">
		<xsl:variable name="i" select="position()-1"/>
		<xsl:if test="$i>0">
		<xsl:element name="svg:path"><xsl:attribute name="style">font-size:12;fill:none;fill-rule:evenodd;stroke:#feff4a;stroke-width:1;</xsl:attribute><xsl:attribute name="d">M <xsl:value-of select="(( //turn[$i] / x)*2)+20"/> <xsl:value-of select="(( //turn[$i] / y)*2)+20"/>  L <xsl:value-of select="(x*2)+20"/> <xsl:value-of select="(y*2)+20"/></xsl:attribute></xsl:element>
		</xsl:if>
		<svg:rect
		    style="font-size:12;fill:#a991c4;fill-rule:evenodd;stroke-width:1;fill-opacity:0.6916;"
		    id="frame"
		    width="4"
		    height="4"
		    x="20"
		    y="20" 
		><xsl:attribute name="x"><xsl:value-of select="(x*2)+18"/></xsl:attribute><xsl:attribute name="y"><xsl:value-of select="(y*2)+18"/></xsl:attribute></svg:rect>
	   </xsl:for-each>
	   <svg:text
		style="fill:black;stroke:none;font-family:helvetica;font-style:normal;font-weight:bold;font-size:12px;fill-opacity:1;stroke-opacity:1;stroke-width:1pt;stroke-linejoin:miter;stroke-linecap:butt;"
		x="207.933014"
		y="17.821243"
		id="text611">
		<svg:tspan x="230" y="35"> x, y</svg:tspan>
	    </svg:text>
	    <svg:text
		style="fill:black;stroke:none;font-family:helvetica;font-style:normal;font-weight:normal;font-size:12px;fill-opacity:1;stroke-opacity:1;stroke-width:1pt;stroke-linejoin:miter;stroke-linecap:butt;"
		x="207.933014"
		y="17.821243"
		id="text611">
		<xsl:for-each select="turn">
		<svg:tspan x="230"><xsl:attribute name="y"><xsl:value-of select="47+position()*12"/></xsl:attribute><xsl:value-of select="x"/>,<xsl:value-of select="y"/></svg:tspan>
		</xsl:for-each>
	    </svg:text>
	    <svg:g
		   id="g627"
		   transform="matrix(0.495714,0,0,0.495714,20.2086,225.5607)"><svg:defs
		   id="defs561" /><svg:g
		   id="g607"
		   transform="matrix(2.084461,0,0,2.084454,-115.3281,-114.0954)"><svg:text
		   style="fill:black;stroke:none;font-family:Luxi Sans;font-style:normal;font-weight:bold;font-size:18;fill-opacity:1;stroke-opacity:1;stroke-width:1pt;stroke-linejoin:miter;stroke-linecap:butt;text-anchor:start;writing-mode:lr;"
		   x="55.6250000"
		   y="71.7371521"
		   id="text562"
		   ><svg:tspan
		   x="55.625"
		   y="71.7371521"

		   id="tspan569">&lt;1060&gt;</svg:tspan></svg:text><svg:text
		   style="fill:#4218a0;stroke:none;font-family:Luxi Sans;font-style:normal;font-weight:bold;font-size:9.500000;fill-opacity:1.0000;stroke-opacity:1;stroke-width:1pt;stroke-linejoin:miter;stroke-linecap:butt;text-anchor:start;writing-mode:lr;"
		   x="77.5000000"
		   y="77.9111786"
		   id="text571"
		   ><svg:tspan
		   x="77.5"
		   y="77.9111786"

		   id="tspan582">research</svg:tspan></svg:text><svg:text
		   style="fill:black;stroke:none;font-family:Arial;font-style:normal;font-weight:normal;font-size:18;fill-opacity:1;stroke-opacity:1;stroke-width:1pt;stroke-linejoin:miter;stroke-linecap:butt;text-anchor:start;writing-mode:lr;"
		   x="175.278136"
		   y="101.859646"
		   id="text602"

		   transform="scale(0.600127,0.600128)"><svg:tspan
		   x="175.278137"
		   y="101.85965"

		   id="tspan605">&#174;</svg:tspan></svg:text></svg:g></svg:g>
	</svg:svg>
    </xsl:template>
</xsl:stylesheet>