<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="html"/>

    <xsl:template match="/links">
	<html>
            <head>
                <title>WS Tests</title>
            </head>
            <body>
		<h2>WS Tests</h2>
		<p>
		A set of tests for the SOAP web services module.  The module hosts some simple SOAP services, clients to the hosted services 
		and test clients to external remote services.
		</p>
		<h3>Client/Server Tests</h3>
		<ul>
		<xsl:for-each select="link">
		<xsl:if test="starts-with( name, 'expt')">
		<li>
		    <a>
			<xsl:attribute name="href">http://localhost:8080/ws-test<xsl:value-of select="ext"/></xsl:attribute>
			<xsl:value-of select="name"/>
		    </a>
		</li>
		</xsl:if>
		</xsl:for-each>
		<li><a href="http://localhost:8080/ws-test/hilo/engine">hilo world</a></li>
		</ul>
		<h3>Service Descriptions</h3>
		<ul>
		    <li><a href="/soap/test/echo?DOC">echo service</a></li>
		    <li><a href="/soap/test/ping?DOC">ping service</a></li>
		    <li><a href="/soap/test/hilo?DOC">hilo game service</a></li>
		</ul>
		<h3>Accessor Tests</h3>
		<ul>
		<xsl:for-each select="link">
		<xsl:if test="starts-with( name, 'acc')">
		<li>
		    <a>
			<xsl:attribute name="href">http://localhost:8080/ws-test<xsl:value-of select="ext"/></xsl:attribute>
			<xsl:value-of select="name"/>
		    </a>
		</li>
		</xsl:if>
		</xsl:for-each>
		</ul>
		<h3>SOAP Builder doc/lit Interop Tests</h3>
		<p>
		For test specifications see <a href="http://mssoapinterop.org/asmx/xsd/">mssoapinterop.org</a>
		</p>
		<ul>
		<xsl:for-each select="link">
		<xsl:if test="starts-with( name, 'interop')">
		<li>
		    <a>
			<xsl:attribute name="href">http://localhost:8080/ws-test<xsl:value-of select="ext"/></xsl:attribute>
			<xsl:value-of select="name"/>
		    </a>
		</li>
		</xsl:if>
		</xsl:for-each>
		</ul>
            </body>
        </html>
    </xsl:template>

</xsl:stylesheet>
