/* @generated by `generate-fortify-tests.lua "socket"` */

#define	_FORTIFY_SOURCE	2
#define	TMPFILE_SIZE	(1024 * 32)

#include <sys/param.h>
#include <sys/jail.h>
#include <sys/random.h>
#include <sys/resource.h>
#include <sys/select.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/uio.h>
#include <sys/wait.h>
#include <dirent.h>
#include <errno.h>
#include <fcntl.h>
#include <limits.h>
#include <poll.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <sysexits.h>
#include <unistd.h>
#include <wchar.h>
#include <atf-c.h>

static FILE * __unused
new_fp(size_t __len)
{
	static char fpbuf[LINE_MAX];
	FILE *fp;

	ATF_REQUIRE(__len <= sizeof(fpbuf));

	memset(fpbuf, 'A', sizeof(fpbuf) - 1);
	fpbuf[sizeof(fpbuf) - 1] = '\0';

	fp = fmemopen(fpbuf, sizeof(fpbuf), "rb");
	ATF_REQUIRE(fp != NULL);

	return (fp);
}

/*
 * Create a new symlink to use for readlink(2) style tests, we'll just use a
 * random target name to have something interesting to look at.
 */
static const char * __unused
new_symlink(size_t __len)
{
	static const char linkname[] = "link";
	char target[MAXNAMLEN];
	int error;

	ATF_REQUIRE(__len <= sizeof(target));

	arc4random_buf(target, sizeof(target));

	error = unlink(linkname);
	ATF_REQUIRE(error == 0 || errno == ENOENT);

	error = symlink(target, linkname);
	ATF_REQUIRE(error == 0);

	return (linkname);
}

/*
 * For our purposes, first descriptor will be the reader; we'll send both
 * raw data and a control message over it so that the result can be used for
 * any of our recv*() tests.
 */
static void __unused
new_socket(int sock[2])
{
	unsigned char ctrl[CMSG_SPACE(sizeof(int))] = { 0 };
	static char sockbuf[256];
	ssize_t rv;
	size_t total = 0;
	struct msghdr hdr = { 0 };
	struct cmsghdr *cmsg;
	int error, fd;

	error = socketpair(AF_UNIX, SOCK_STREAM, 0, sock);
	ATF_REQUIRE(error == 0);

	while (total != sizeof(sockbuf)) {
		rv = send(sock[1], &sockbuf[total], sizeof(sockbuf) - total, 0);

		ATF_REQUIRE_MSG(rv > 0,
		    "expected bytes sent, got %zd with %zu left (size %zu, total %zu)",
		    rv, sizeof(sockbuf) - total, sizeof(sockbuf), total);
		ATF_REQUIRE_MSG(total + (size_t)rv <= sizeof(sockbuf),
		    "%zd exceeds total %zu", rv, sizeof(sockbuf));
		total += rv;
	}

	hdr.msg_control = ctrl;
	hdr.msg_controllen = sizeof(ctrl);

	cmsg = CMSG_FIRSTHDR(&hdr);
	cmsg->cmsg_level = SOL_SOCKET;
	cmsg->cmsg_type = SCM_RIGHTS;
	cmsg->cmsg_len = CMSG_LEN(sizeof(fd));
	fd = STDIN_FILENO;
	memcpy(CMSG_DATA(cmsg), &fd, sizeof(fd));

	error = sendmsg(sock[1], &hdr, 0);
	ATF_REQUIRE(error != -1);
}

/*
 * Constructs a tmpfile that we can use for testing read(2) and friends.
 */
static int __unused
new_tmpfile(void)
{
	char buf[1024];
	ssize_t rv;
	size_t written;
	int fd;

	fd = open("tmpfile", O_RDWR | O_CREAT | O_TRUNC, 0644);
	ATF_REQUIRE(fd >= 0);

	written = 0;
	while (written < TMPFILE_SIZE) {
		rv = write(fd, buf, sizeof(buf));
		ATF_REQUIRE(rv > 0);

		written += rv;
	}

	ATF_REQUIRE_EQ(0, lseek(fd, 0, SEEK_SET));
	return (fd);
}

static void
disable_coredumps(void)
{
	struct rlimit rl = { 0 };

	if (setrlimit(RLIMIT_CORE, &rl) == -1)
		_exit(EX_OSERR);
}

/*
 * Replaces stdin with a file that we can actually read from, for tests where
 * we want a FILE * or fd that we can get data from.
 */
static void __unused
replace_stdin(void)
{
	int fd;

	fd = new_tmpfile();

	(void)dup2(fd, STDIN_FILENO);
	if (fd != STDIN_FILENO)
		close(fd);
}

ATF_TC(getpeername_before_end);
ATF_TC_HEAD(getpeername_before_end, tc)
{
}
ATF_TC_BODY(getpeername_before_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		struct sockaddr __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = sizeof(struct sockaddr) - 1;
	const size_t __idx __unused = __len - 1;
	int sock[2] = { -1, -1 };
	socklen_t socklen;
	new_socket(sock);
	socklen = __len;

	getpeername(sock[0], &__stack.__buf, &socklen);
#undef BUF

}

ATF_TC(getpeername_end);
ATF_TC_HEAD(getpeername_end, tc)
{
}
ATF_TC_BODY(getpeername_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		struct sockaddr __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = sizeof(struct sockaddr);
	const size_t __idx __unused = __len - 1;
	int sock[2] = { -1, -1 };
	socklen_t socklen;
	new_socket(sock);
	socklen = __len;

	getpeername(sock[0], &__stack.__buf, &socklen);
#undef BUF

}

ATF_TC(getpeername_heap_before_end);
ATF_TC_HEAD(getpeername_heap_before_end, tc)
{
}
ATF_TC_BODY(getpeername_heap_before_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		struct sockaddr * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (1);
	const size_t __len = sizeof(struct sockaddr) - 1;
	const size_t __idx __unused = __len - 1;
	int sock[2] = { -1, -1 };
	socklen_t socklen;
	__stack.__buf = malloc(__bufsz);
	new_socket(sock);
	socklen = __len;

	getpeername(sock[0], __stack.__buf, &socklen);
#undef BUF

}

ATF_TC(getpeername_heap_end);
ATF_TC_HEAD(getpeername_heap_end, tc)
{
}
ATF_TC_BODY(getpeername_heap_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		struct sockaddr * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (1);
	const size_t __len = sizeof(struct sockaddr);
	const size_t __idx __unused = __len - 1;
	int sock[2] = { -1, -1 };
	socklen_t socklen;
	__stack.__buf = malloc(__bufsz);
	new_socket(sock);
	socklen = __len;

	getpeername(sock[0], __stack.__buf, &socklen);
#undef BUF

}

ATF_TC(getpeername_heap_after_end);
ATF_TC_HEAD(getpeername_heap_after_end, tc)
{
}
ATF_TC_BODY(getpeername_heap_after_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		struct sockaddr * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (1);
	const size_t __len = sizeof(struct sockaddr) + 1;
	const size_t __idx __unused = __len - 1;
	pid_t __child;
	int __status;
	int sock[2] = { -1, -1 };
	socklen_t socklen;
	__child = fork();
	ATF_REQUIRE(__child >= 0);
	if (__child > 0)
		goto monitor;

	/* Child */
	disable_coredumps();
	__stack.__buf = malloc(__bufsz);
	new_socket(sock);
	socklen = __len;

	getpeername(sock[0], __stack.__buf, &socklen);
	_exit(EX_SOFTWARE);	/* Should have aborted. */

monitor:
	while (waitpid(__child, &__status, 0) != __child) {
		ATF_REQUIRE_EQ(EINTR, errno);
	}

	if (!WIFSIGNALED(__status)) {
		switch (WEXITSTATUS(__status)) {
		case EX_SOFTWARE:
			atf_tc_fail("FORTIFY_SOURCE failed to abort");
			break;
		case EX_OSERR:
			atf_tc_fail("setrlimit(2) failed");
			break;
		default:
			atf_tc_fail("child exited with status %d",
			    WEXITSTATUS(__status));
		}
	} else {
		ATF_REQUIRE_EQ(SIGABRT, WTERMSIG(__status));
	}
#undef BUF

}

ATF_TC(getsockname_before_end);
ATF_TC_HEAD(getsockname_before_end, tc)
{
}
ATF_TC_BODY(getsockname_before_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		struct sockaddr __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = sizeof(struct sockaddr) - 1;
	const size_t __idx __unused = __len - 1;
	int sock[2] = { -1, -1 };
	socklen_t socklen;
	new_socket(sock);
	socklen = __len;

	getsockname(sock[0], &__stack.__buf, &socklen);
#undef BUF

}

ATF_TC(getsockname_end);
ATF_TC_HEAD(getsockname_end, tc)
{
}
ATF_TC_BODY(getsockname_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		struct sockaddr __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = sizeof(struct sockaddr);
	const size_t __idx __unused = __len - 1;
	int sock[2] = { -1, -1 };
	socklen_t socklen;
	new_socket(sock);
	socklen = __len;

	getsockname(sock[0], &__stack.__buf, &socklen);
#undef BUF

}

ATF_TC(getsockname_heap_before_end);
ATF_TC_HEAD(getsockname_heap_before_end, tc)
{
}
ATF_TC_BODY(getsockname_heap_before_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		struct sockaddr * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (1);
	const size_t __len = sizeof(struct sockaddr) - 1;
	const size_t __idx __unused = __len - 1;
	int sock[2] = { -1, -1 };
	socklen_t socklen;
	__stack.__buf = malloc(__bufsz);
	new_socket(sock);
	socklen = __len;

	getsockname(sock[0], __stack.__buf, &socklen);
#undef BUF

}

ATF_TC(getsockname_heap_end);
ATF_TC_HEAD(getsockname_heap_end, tc)
{
}
ATF_TC_BODY(getsockname_heap_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		struct sockaddr * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (1);
	const size_t __len = sizeof(struct sockaddr);
	const size_t __idx __unused = __len - 1;
	int sock[2] = { -1, -1 };
	socklen_t socklen;
	__stack.__buf = malloc(__bufsz);
	new_socket(sock);
	socklen = __len;

	getsockname(sock[0], __stack.__buf, &socklen);
#undef BUF

}

ATF_TC(getsockname_heap_after_end);
ATF_TC_HEAD(getsockname_heap_after_end, tc)
{
}
ATF_TC_BODY(getsockname_heap_after_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		struct sockaddr * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (1);
	const size_t __len = sizeof(struct sockaddr) + 1;
	const size_t __idx __unused = __len - 1;
	pid_t __child;
	int __status;
	int sock[2] = { -1, -1 };
	socklen_t socklen;
	__child = fork();
	ATF_REQUIRE(__child >= 0);
	if (__child > 0)
		goto monitor;

	/* Child */
	disable_coredumps();
	__stack.__buf = malloc(__bufsz);
	new_socket(sock);
	socklen = __len;

	getsockname(sock[0], __stack.__buf, &socklen);
	_exit(EX_SOFTWARE);	/* Should have aborted. */

monitor:
	while (waitpid(__child, &__status, 0) != __child) {
		ATF_REQUIRE_EQ(EINTR, errno);
	}

	if (!WIFSIGNALED(__status)) {
		switch (WEXITSTATUS(__status)) {
		case EX_SOFTWARE:
			atf_tc_fail("FORTIFY_SOURCE failed to abort");
			break;
		case EX_OSERR:
			atf_tc_fail("setrlimit(2) failed");
			break;
		default:
			atf_tc_fail("child exited with status %d",
			    WEXITSTATUS(__status));
		}
	} else {
		ATF_REQUIRE_EQ(SIGABRT, WTERMSIG(__status));
	}
#undef BUF

}

ATF_TC(recv_before_end);
ATF_TC_HEAD(recv_before_end, tc)
{
}
ATF_TC_BODY(recv_before_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char __buf[42];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = 42 - 1;
	const size_t __idx __unused = __len - 1;
	int sock[2] = { -1, -1 };

	new_socket(sock);

	recv(sock[0], __stack.__buf, __len, 0);
#undef BUF

}

ATF_TC(recv_end);
ATF_TC_HEAD(recv_end, tc)
{
}
ATF_TC_BODY(recv_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char __buf[42];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = 42;
	const size_t __idx __unused = __len - 1;
	int sock[2] = { -1, -1 };

	new_socket(sock);

	recv(sock[0], __stack.__buf, __len, 0);
#undef BUF

}

ATF_TC(recv_heap_before_end);
ATF_TC_HEAD(recv_heap_before_end, tc)
{
}
ATF_TC_BODY(recv_heap_before_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (42);
	const size_t __len = 42 - 1;
	const size_t __idx __unused = __len - 1;
	int sock[2] = { -1, -1 };

	__stack.__buf = malloc(__bufsz);
	new_socket(sock);

	recv(sock[0], __stack.__buf, __len, 0);
#undef BUF

}

ATF_TC(recv_heap_end);
ATF_TC_HEAD(recv_heap_end, tc)
{
}
ATF_TC_BODY(recv_heap_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (42);
	const size_t __len = 42;
	const size_t __idx __unused = __len - 1;
	int sock[2] = { -1, -1 };

	__stack.__buf = malloc(__bufsz);
	new_socket(sock);

	recv(sock[0], __stack.__buf, __len, 0);
#undef BUF

}

ATF_TC(recv_heap_after_end);
ATF_TC_HEAD(recv_heap_after_end, tc)
{
}
ATF_TC_BODY(recv_heap_after_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (42);
	const size_t __len = 42 + 1;
	const size_t __idx __unused = __len - 1;
	pid_t __child;
	int __status;
	int sock[2] = { -1, -1 };

	__child = fork();
	ATF_REQUIRE(__child >= 0);
	if (__child > 0)
		goto monitor;

	/* Child */
	disable_coredumps();
	__stack.__buf = malloc(__bufsz);
	new_socket(sock);

	recv(sock[0], __stack.__buf, __len, 0);
	_exit(EX_SOFTWARE);	/* Should have aborted. */

monitor:
	while (waitpid(__child, &__status, 0) != __child) {
		ATF_REQUIRE_EQ(EINTR, errno);
	}

	if (!WIFSIGNALED(__status)) {
		switch (WEXITSTATUS(__status)) {
		case EX_SOFTWARE:
			atf_tc_fail("FORTIFY_SOURCE failed to abort");
			break;
		case EX_OSERR:
			atf_tc_fail("setrlimit(2) failed");
			break;
		default:
			atf_tc_fail("child exited with status %d",
			    WEXITSTATUS(__status));
		}
	} else {
		ATF_REQUIRE_EQ(SIGABRT, WTERMSIG(__status));
	}
#undef BUF

}

ATF_TC(recvfrom_before_end);
ATF_TC_HEAD(recvfrom_before_end, tc)
{
}
ATF_TC_BODY(recvfrom_before_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char __buf[42];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = 42 - 1;
	const size_t __idx __unused = __len - 1;
	int sock[2] = { -1, -1 };

	new_socket(sock);

	recvfrom(sock[0], __stack.__buf, __len, 0, NULL, NULL);
#undef BUF

}

ATF_TC(recvfrom_end);
ATF_TC_HEAD(recvfrom_end, tc)
{
}
ATF_TC_BODY(recvfrom_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char __buf[42];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = 42;
	const size_t __idx __unused = __len - 1;
	int sock[2] = { -1, -1 };

	new_socket(sock);

	recvfrom(sock[0], __stack.__buf, __len, 0, NULL, NULL);
#undef BUF

}

ATF_TC(recvfrom_heap_before_end);
ATF_TC_HEAD(recvfrom_heap_before_end, tc)
{
}
ATF_TC_BODY(recvfrom_heap_before_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (42);
	const size_t __len = 42 - 1;
	const size_t __idx __unused = __len - 1;
	int sock[2] = { -1, -1 };

	__stack.__buf = malloc(__bufsz);
	new_socket(sock);

	recvfrom(sock[0], __stack.__buf, __len, 0, NULL, NULL);
#undef BUF

}

ATF_TC(recvfrom_heap_end);
ATF_TC_HEAD(recvfrom_heap_end, tc)
{
}
ATF_TC_BODY(recvfrom_heap_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (42);
	const size_t __len = 42;
	const size_t __idx __unused = __len - 1;
	int sock[2] = { -1, -1 };

	__stack.__buf = malloc(__bufsz);
	new_socket(sock);

	recvfrom(sock[0], __stack.__buf, __len, 0, NULL, NULL);
#undef BUF

}

ATF_TC(recvfrom_heap_after_end);
ATF_TC_HEAD(recvfrom_heap_after_end, tc)
{
}
ATF_TC_BODY(recvfrom_heap_after_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (42);
	const size_t __len = 42 + 1;
	const size_t __idx __unused = __len - 1;
	pid_t __child;
	int __status;
	int sock[2] = { -1, -1 };

	__child = fork();
	ATF_REQUIRE(__child >= 0);
	if (__child > 0)
		goto monitor;

	/* Child */
	disable_coredumps();
	__stack.__buf = malloc(__bufsz);
	new_socket(sock);

	recvfrom(sock[0], __stack.__buf, __len, 0, NULL, NULL);
	_exit(EX_SOFTWARE);	/* Should have aborted. */

monitor:
	while (waitpid(__child, &__status, 0) != __child) {
		ATF_REQUIRE_EQ(EINTR, errno);
	}

	if (!WIFSIGNALED(__status)) {
		switch (WEXITSTATUS(__status)) {
		case EX_SOFTWARE:
			atf_tc_fail("FORTIFY_SOURCE failed to abort");
			break;
		case EX_OSERR:
			atf_tc_fail("setrlimit(2) failed");
			break;
		default:
			atf_tc_fail("child exited with status %d",
			    WEXITSTATUS(__status));
		}
	} else {
		ATF_REQUIRE_EQ(SIGABRT, WTERMSIG(__status));
	}
#undef BUF

}

ATF_TC(recvfrom_sockaddr_before_end);
ATF_TC_HEAD(recvfrom_sockaddr_before_end, tc)
{
}
ATF_TC_BODY(recvfrom_sockaddr_before_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		struct sockaddr __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = sizeof(struct sockaddr) - 1;
	const size_t __idx __unused = __len - 1;
	int sock[2] = { -1, -1 };
	char data[16];
	socklen_t socklen;

	new_socket(sock);
	socklen = __len;

	recvfrom(sock[0], data, sizeof(data), 0, &__stack.__buf, &socklen);
#undef BUF

}

ATF_TC(recvfrom_sockaddr_end);
ATF_TC_HEAD(recvfrom_sockaddr_end, tc)
{
}
ATF_TC_BODY(recvfrom_sockaddr_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		struct sockaddr __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = sizeof(struct sockaddr);
	const size_t __idx __unused = __len - 1;
	int sock[2] = { -1, -1 };
	char data[16];
	socklen_t socklen;

	new_socket(sock);
	socklen = __len;

	recvfrom(sock[0], data, sizeof(data), 0, &__stack.__buf, &socklen);
#undef BUF

}

ATF_TC(recvfrom_sockaddr_heap_before_end);
ATF_TC_HEAD(recvfrom_sockaddr_heap_before_end, tc)
{
}
ATF_TC_BODY(recvfrom_sockaddr_heap_before_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		struct sockaddr * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (1);
	const size_t __len = sizeof(struct sockaddr) - 1;
	const size_t __idx __unused = __len - 1;
	int sock[2] = { -1, -1 };
	char data[16];
	socklen_t socklen;

	__stack.__buf = malloc(__bufsz);
	new_socket(sock);
	socklen = __len;

	recvfrom(sock[0], data, sizeof(data), 0, __stack.__buf, &socklen);
#undef BUF

}

ATF_TC(recvfrom_sockaddr_heap_end);
ATF_TC_HEAD(recvfrom_sockaddr_heap_end, tc)
{
}
ATF_TC_BODY(recvfrom_sockaddr_heap_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		struct sockaddr * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (1);
	const size_t __len = sizeof(struct sockaddr);
	const size_t __idx __unused = __len - 1;
	int sock[2] = { -1, -1 };
	char data[16];
	socklen_t socklen;

	__stack.__buf = malloc(__bufsz);
	new_socket(sock);
	socklen = __len;

	recvfrom(sock[0], data, sizeof(data), 0, __stack.__buf, &socklen);
#undef BUF

}

ATF_TC(recvfrom_sockaddr_heap_after_end);
ATF_TC_HEAD(recvfrom_sockaddr_heap_after_end, tc)
{
}
ATF_TC_BODY(recvfrom_sockaddr_heap_after_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		struct sockaddr * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (1);
	const size_t __len = sizeof(struct sockaddr) + 1;
	const size_t __idx __unused = __len - 1;
	pid_t __child;
	int __status;
	int sock[2] = { -1, -1 };
	char data[16];
	socklen_t socklen;

	__child = fork();
	ATF_REQUIRE(__child >= 0);
	if (__child > 0)
		goto monitor;

	/* Child */
	disable_coredumps();
	__stack.__buf = malloc(__bufsz);
	new_socket(sock);
	socklen = __len;

	recvfrom(sock[0], data, sizeof(data), 0, __stack.__buf, &socklen);
	_exit(EX_SOFTWARE);	/* Should have aborted. */

monitor:
	while (waitpid(__child, &__status, 0) != __child) {
		ATF_REQUIRE_EQ(EINTR, errno);
	}

	if (!WIFSIGNALED(__status)) {
		switch (WEXITSTATUS(__status)) {
		case EX_SOFTWARE:
			atf_tc_fail("FORTIFY_SOURCE failed to abort");
			break;
		case EX_OSERR:
			atf_tc_fail("setrlimit(2) failed");
			break;
		default:
			atf_tc_fail("child exited with status %d",
			    WEXITSTATUS(__status));
		}
	} else {
		ATF_REQUIRE_EQ(SIGABRT, WTERMSIG(__status));
	}
#undef BUF

}

ATF_TC(recvmsg_msg_name_before_end);
ATF_TC_HEAD(recvmsg_msg_name_before_end, tc)
{
}
ATF_TC_BODY(recvmsg_msg_name_before_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		struct sockaddr __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = sizeof(struct sockaddr) - 1;
	const size_t __idx __unused = __len - 1;
	int sock[2] = { -1, -1 };
	struct msghdr msg;

	memset(&msg, 0, sizeof(msg));
	msg.msg_name = BUF;
	msg.msg_namelen = __len;

	recvmsg(sock[0], &msg, 0);
#undef BUF

}

ATF_TC(recvmsg_msg_name_end);
ATF_TC_HEAD(recvmsg_msg_name_end, tc)
{
}
ATF_TC_BODY(recvmsg_msg_name_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		struct sockaddr __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = sizeof(struct sockaddr);
	const size_t __idx __unused = __len - 1;
	int sock[2] = { -1, -1 };
	struct msghdr msg;

	memset(&msg, 0, sizeof(msg));
	msg.msg_name = BUF;
	msg.msg_namelen = __len;

	recvmsg(sock[0], &msg, 0);
#undef BUF

}

ATF_TC(recvmsg_msg_name_heap_before_end);
ATF_TC_HEAD(recvmsg_msg_name_heap_before_end, tc)
{
}
ATF_TC_BODY(recvmsg_msg_name_heap_before_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		struct sockaddr * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (1);
	const size_t __len = sizeof(struct sockaddr) - 1;
	const size_t __idx __unused = __len - 1;
	int sock[2] = { -1, -1 };
	struct msghdr msg;

	__stack.__buf = malloc(__bufsz);
	memset(&msg, 0, sizeof(msg));
	msg.msg_name = BUF;
	msg.msg_namelen = __len;

	recvmsg(sock[0], &msg, 0);
#undef BUF

}

ATF_TC(recvmsg_msg_name_heap_end);
ATF_TC_HEAD(recvmsg_msg_name_heap_end, tc)
{
}
ATF_TC_BODY(recvmsg_msg_name_heap_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		struct sockaddr * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (1);
	const size_t __len = sizeof(struct sockaddr);
	const size_t __idx __unused = __len - 1;
	int sock[2] = { -1, -1 };
	struct msghdr msg;

	__stack.__buf = malloc(__bufsz);
	memset(&msg, 0, sizeof(msg));
	msg.msg_name = BUF;
	msg.msg_namelen = __len;

	recvmsg(sock[0], &msg, 0);
#undef BUF

}

ATF_TC(recvmsg_msg_name_heap_after_end);
ATF_TC_HEAD(recvmsg_msg_name_heap_after_end, tc)
{
}
ATF_TC_BODY(recvmsg_msg_name_heap_after_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		struct sockaddr * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (1);
	const size_t __len = sizeof(struct sockaddr) + 1;
	const size_t __idx __unused = __len - 1;
	pid_t __child;
	int __status;
	int sock[2] = { -1, -1 };
	struct msghdr msg;

	__child = fork();
	ATF_REQUIRE(__child >= 0);
	if (__child > 0)
		goto monitor;

	/* Child */
	disable_coredumps();
	__stack.__buf = malloc(__bufsz);
	memset(&msg, 0, sizeof(msg));
	msg.msg_name = BUF;
	msg.msg_namelen = __len;

	recvmsg(sock[0], &msg, 0);
	_exit(EX_SOFTWARE);	/* Should have aborted. */

monitor:
	while (waitpid(__child, &__status, 0) != __child) {
		ATF_REQUIRE_EQ(EINTR, errno);
	}

	if (!WIFSIGNALED(__status)) {
		switch (WEXITSTATUS(__status)) {
		case EX_SOFTWARE:
			atf_tc_fail("FORTIFY_SOURCE failed to abort");
			break;
		case EX_OSERR:
			atf_tc_fail("setrlimit(2) failed");
			break;
		default:
			atf_tc_fail("child exited with status %d",
			    WEXITSTATUS(__status));
		}
	} else {
		ATF_REQUIRE_EQ(SIGABRT, WTERMSIG(__status));
	}
#undef BUF

}

ATF_TC(recvmsg_msg_iov_before_end);
ATF_TC_HEAD(recvmsg_msg_iov_before_end, tc)
{
}
ATF_TC_BODY(recvmsg_msg_iov_before_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char __buf[42];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = 42 - 1;
	const size_t __idx __unused = __len - 1;
	int sock[2] = { -1, -1 };
	struct msghdr msg;
	struct iovec iov[2];

	memset(&msg, 0, sizeof(msg));
	memset(&iov[0], 0, sizeof(iov));

	/*
	 * We position the buffer second just so that we can confirm that the
	 * fortification bits are traversing the iovec correctly.
	 */
	iov[1].iov_base = BUF;
	iov[1].iov_len = __len;

	msg.msg_iov = &iov[0];
	msg.msg_iovlen = nitems(iov);

	recvmsg(sock[0], &msg, 0);
#undef BUF

}

ATF_TC(recvmsg_msg_iov_end);
ATF_TC_HEAD(recvmsg_msg_iov_end, tc)
{
}
ATF_TC_BODY(recvmsg_msg_iov_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char __buf[42];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = 42;
	const size_t __idx __unused = __len - 1;
	int sock[2] = { -1, -1 };
	struct msghdr msg;
	struct iovec iov[2];

	memset(&msg, 0, sizeof(msg));
	memset(&iov[0], 0, sizeof(iov));

	/*
	 * We position the buffer second just so that we can confirm that the
	 * fortification bits are traversing the iovec correctly.
	 */
	iov[1].iov_base = BUF;
	iov[1].iov_len = __len;

	msg.msg_iov = &iov[0];
	msg.msg_iovlen = nitems(iov);

	recvmsg(sock[0], &msg, 0);
#undef BUF

}

ATF_TC(recvmsg_msg_iov_heap_before_end);
ATF_TC_HEAD(recvmsg_msg_iov_heap_before_end, tc)
{
}
ATF_TC_BODY(recvmsg_msg_iov_heap_before_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (42);
	const size_t __len = 42 - 1;
	const size_t __idx __unused = __len - 1;
	int sock[2] = { -1, -1 };
	struct msghdr msg;
	struct iovec iov[2];

	__stack.__buf = malloc(__bufsz);
	memset(&msg, 0, sizeof(msg));
	memset(&iov[0], 0, sizeof(iov));

	/*
	 * We position the buffer second just so that we can confirm that the
	 * fortification bits are traversing the iovec correctly.
	 */
	iov[1].iov_base = BUF;
	iov[1].iov_len = __len;

	msg.msg_iov = &iov[0];
	msg.msg_iovlen = nitems(iov);

	recvmsg(sock[0], &msg, 0);
#undef BUF

}

ATF_TC(recvmsg_msg_iov_heap_end);
ATF_TC_HEAD(recvmsg_msg_iov_heap_end, tc)
{
}
ATF_TC_BODY(recvmsg_msg_iov_heap_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (42);
	const size_t __len = 42;
	const size_t __idx __unused = __len - 1;
	int sock[2] = { -1, -1 };
	struct msghdr msg;
	struct iovec iov[2];

	__stack.__buf = malloc(__bufsz);
	memset(&msg, 0, sizeof(msg));
	memset(&iov[0], 0, sizeof(iov));

	/*
	 * We position the buffer second just so that we can confirm that the
	 * fortification bits are traversing the iovec correctly.
	 */
	iov[1].iov_base = BUF;
	iov[1].iov_len = __len;

	msg.msg_iov = &iov[0];
	msg.msg_iovlen = nitems(iov);

	recvmsg(sock[0], &msg, 0);
#undef BUF

}

ATF_TC(recvmsg_msg_iov_heap_after_end);
ATF_TC_HEAD(recvmsg_msg_iov_heap_after_end, tc)
{
}
ATF_TC_BODY(recvmsg_msg_iov_heap_after_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (42);
	const size_t __len = 42 + 1;
	const size_t __idx __unused = __len - 1;
	pid_t __child;
	int __status;
	int sock[2] = { -1, -1 };
	struct msghdr msg;
	struct iovec iov[2];

	__child = fork();
	ATF_REQUIRE(__child >= 0);
	if (__child > 0)
		goto monitor;

	/* Child */
	disable_coredumps();
	__stack.__buf = malloc(__bufsz);
	memset(&msg, 0, sizeof(msg));
	memset(&iov[0], 0, sizeof(iov));

	/*
	 * We position the buffer second just so that we can confirm that the
	 * fortification bits are traversing the iovec correctly.
	 */
	iov[1].iov_base = BUF;
	iov[1].iov_len = __len;

	msg.msg_iov = &iov[0];
	msg.msg_iovlen = nitems(iov);

	recvmsg(sock[0], &msg, 0);
	_exit(EX_SOFTWARE);	/* Should have aborted. */

monitor:
	while (waitpid(__child, &__status, 0) != __child) {
		ATF_REQUIRE_EQ(EINTR, errno);
	}

	if (!WIFSIGNALED(__status)) {
		switch (WEXITSTATUS(__status)) {
		case EX_SOFTWARE:
			atf_tc_fail("FORTIFY_SOURCE failed to abort");
			break;
		case EX_OSERR:
			atf_tc_fail("setrlimit(2) failed");
			break;
		default:
			atf_tc_fail("child exited with status %d",
			    WEXITSTATUS(__status));
		}
	} else {
		ATF_REQUIRE_EQ(SIGABRT, WTERMSIG(__status));
	}
#undef BUF

}

ATF_TC(recvmsg_msg_control_before_end);
ATF_TC_HEAD(recvmsg_msg_control_before_end, tc)
{
}
ATF_TC_BODY(recvmsg_msg_control_before_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char __buf[CMSG_SPACE(sizeof(int))];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = CMSG_SPACE(sizeof(int)) - 1;
	const size_t __idx __unused = __len - 1;
	int sock[2] = { -1, -1 };
	struct msghdr msg;

	memset(&msg, 0, sizeof(msg));

	msg.msg_control = BUF;
	msg.msg_controllen = __len;

	recvmsg(sock[0], &msg, 0);
#undef BUF

}

ATF_TC(recvmsg_msg_control_end);
ATF_TC_HEAD(recvmsg_msg_control_end, tc)
{
}
ATF_TC_BODY(recvmsg_msg_control_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char __buf[CMSG_SPACE(sizeof(int))];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = CMSG_SPACE(sizeof(int));
	const size_t __idx __unused = __len - 1;
	int sock[2] = { -1, -1 };
	struct msghdr msg;

	memset(&msg, 0, sizeof(msg));

	msg.msg_control = BUF;
	msg.msg_controllen = __len;

	recvmsg(sock[0], &msg, 0);
#undef BUF

}

ATF_TC(recvmsg_msg_control_heap_before_end);
ATF_TC_HEAD(recvmsg_msg_control_heap_before_end, tc)
{
}
ATF_TC_BODY(recvmsg_msg_control_heap_before_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (CMSG_SPACE(sizeof(int)));
	const size_t __len = CMSG_SPACE(sizeof(int)) - 1;
	const size_t __idx __unused = __len - 1;
	int sock[2] = { -1, -1 };
	struct msghdr msg;

	__stack.__buf = malloc(__bufsz);
	memset(&msg, 0, sizeof(msg));

	msg.msg_control = BUF;
	msg.msg_controllen = __len;

	recvmsg(sock[0], &msg, 0);
#undef BUF

}

ATF_TC(recvmsg_msg_control_heap_end);
ATF_TC_HEAD(recvmsg_msg_control_heap_end, tc)
{
}
ATF_TC_BODY(recvmsg_msg_control_heap_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (CMSG_SPACE(sizeof(int)));
	const size_t __len = CMSG_SPACE(sizeof(int));
	const size_t __idx __unused = __len - 1;
	int sock[2] = { -1, -1 };
	struct msghdr msg;

	__stack.__buf = malloc(__bufsz);
	memset(&msg, 0, sizeof(msg));

	msg.msg_control = BUF;
	msg.msg_controllen = __len;

	recvmsg(sock[0], &msg, 0);
#undef BUF

}

ATF_TC(recvmsg_msg_control_heap_after_end);
ATF_TC_HEAD(recvmsg_msg_control_heap_after_end, tc)
{
}
ATF_TC_BODY(recvmsg_msg_control_heap_after_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (CMSG_SPACE(sizeof(int)));
	const size_t __len = CMSG_SPACE(sizeof(int)) + 1;
	const size_t __idx __unused = __len - 1;
	pid_t __child;
	int __status;
	int sock[2] = { -1, -1 };
	struct msghdr msg;

	__child = fork();
	ATF_REQUIRE(__child >= 0);
	if (__child > 0)
		goto monitor;

	/* Child */
	disable_coredumps();
	__stack.__buf = malloc(__bufsz);
	memset(&msg, 0, sizeof(msg));

	msg.msg_control = BUF;
	msg.msg_controllen = __len;

	recvmsg(sock[0], &msg, 0);
	_exit(EX_SOFTWARE);	/* Should have aborted. */

monitor:
	while (waitpid(__child, &__status, 0) != __child) {
		ATF_REQUIRE_EQ(EINTR, errno);
	}

	if (!WIFSIGNALED(__status)) {
		switch (WEXITSTATUS(__status)) {
		case EX_SOFTWARE:
			atf_tc_fail("FORTIFY_SOURCE failed to abort");
			break;
		case EX_OSERR:
			atf_tc_fail("setrlimit(2) failed");
			break;
		default:
			atf_tc_fail("child exited with status %d",
			    WEXITSTATUS(__status));
		}
	} else {
		ATF_REQUIRE_EQ(SIGABRT, WTERMSIG(__status));
	}
#undef BUF

}

ATF_TC(recvmmsg_msgvec_before_end);
ATF_TC_HEAD(recvmmsg_msgvec_before_end, tc)
{
}
ATF_TC_BODY(recvmmsg_msgvec_before_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		struct mmsghdr __buf[2];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = 2 - 1;
	const size_t __idx __unused = __len - 1;
	int sock[2] = { -1, -1 };

	recvmmsg(sock[0], __stack.__buf, __len, 0, NULL);
#undef BUF

}

ATF_TC(recvmmsg_msgvec_end);
ATF_TC_HEAD(recvmmsg_msgvec_end, tc)
{
}
ATF_TC_BODY(recvmmsg_msgvec_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		struct mmsghdr __buf[2];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = 2;
	const size_t __idx __unused = __len - 1;
	int sock[2] = { -1, -1 };

	recvmmsg(sock[0], __stack.__buf, __len, 0, NULL);
#undef BUF

}

ATF_TC(recvmmsg_msgvec_after_end);
ATF_TC_HEAD(recvmmsg_msgvec_after_end, tc)
{
}
ATF_TC_BODY(recvmmsg_msgvec_after_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		struct mmsghdr __buf[2];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = 2 + 1;
	const size_t __idx __unused = __len - 1;
	pid_t __child;
	int __status;
	int sock[2] = { -1, -1 };

	__child = fork();
	ATF_REQUIRE(__child >= 0);
	if (__child > 0)
		goto monitor;

	/* Child */
	disable_coredumps();
	recvmmsg(sock[0], __stack.__buf, __len, 0, NULL);
	_exit(EX_SOFTWARE);	/* Should have aborted. */

monitor:
	while (waitpid(__child, &__status, 0) != __child) {
		ATF_REQUIRE_EQ(EINTR, errno);
	}

	if (!WIFSIGNALED(__status)) {
		switch (WEXITSTATUS(__status)) {
		case EX_SOFTWARE:
			atf_tc_fail("FORTIFY_SOURCE failed to abort");
			break;
		case EX_OSERR:
			atf_tc_fail("setrlimit(2) failed");
			break;
		default:
			atf_tc_fail("child exited with status %d",
			    WEXITSTATUS(__status));
		}
	} else {
		ATF_REQUIRE_EQ(SIGABRT, WTERMSIG(__status));
	}
#undef BUF

}

ATF_TC(recvmmsg_msgvec_heap_before_end);
ATF_TC_HEAD(recvmmsg_msgvec_heap_before_end, tc)
{
}
ATF_TC_BODY(recvmmsg_msgvec_heap_before_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		struct mmsghdr * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (2);
	const size_t __len = 2 - 1;
	const size_t __idx __unused = __len - 1;
	int sock[2] = { -1, -1 };

	__stack.__buf = malloc(__bufsz);

	recvmmsg(sock[0], __stack.__buf, __len, 0, NULL);
#undef BUF

}

ATF_TC(recvmmsg_msgvec_heap_end);
ATF_TC_HEAD(recvmmsg_msgvec_heap_end, tc)
{
}
ATF_TC_BODY(recvmmsg_msgvec_heap_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		struct mmsghdr * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (2);
	const size_t __len = 2;
	const size_t __idx __unused = __len - 1;
	int sock[2] = { -1, -1 };

	__stack.__buf = malloc(__bufsz);

	recvmmsg(sock[0], __stack.__buf, __len, 0, NULL);
#undef BUF

}

ATF_TC(recvmmsg_msgvec_heap_after_end);
ATF_TC_HEAD(recvmmsg_msgvec_heap_after_end, tc)
{
}
ATF_TC_BODY(recvmmsg_msgvec_heap_after_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		struct mmsghdr * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (2);
	const size_t __len = 2 + 1;
	const size_t __idx __unused = __len - 1;
	pid_t __child;
	int __status;
	int sock[2] = { -1, -1 };

	__child = fork();
	ATF_REQUIRE(__child >= 0);
	if (__child > 0)
		goto monitor;

	/* Child */
	disable_coredumps();
	__stack.__buf = malloc(__bufsz);

	recvmmsg(sock[0], __stack.__buf, __len, 0, NULL);
	_exit(EX_SOFTWARE);	/* Should have aborted. */

monitor:
	while (waitpid(__child, &__status, 0) != __child) {
		ATF_REQUIRE_EQ(EINTR, errno);
	}

	if (!WIFSIGNALED(__status)) {
		switch (WEXITSTATUS(__status)) {
		case EX_SOFTWARE:
			atf_tc_fail("FORTIFY_SOURCE failed to abort");
			break;
		case EX_OSERR:
			atf_tc_fail("setrlimit(2) failed");
			break;
		default:
			atf_tc_fail("child exited with status %d",
			    WEXITSTATUS(__status));
		}
	} else {
		ATF_REQUIRE_EQ(SIGABRT, WTERMSIG(__status));
	}
#undef BUF

}

ATF_TC(recvmmsg_msghdr_before_end);
ATF_TC_HEAD(recvmmsg_msghdr_before_end, tc)
{
}
ATF_TC_BODY(recvmmsg_msghdr_before_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char __buf[42];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = 42 - 1;
	const size_t __idx __unused = __len - 1;
	int sock[2] = { -1, -1 };
	struct mmsghdr msgvec[2];

	memset(&msgvec[0], 0, sizeof(msgvec));

	/*
	 * Same as above, make sure fortification isn't ignoring n > 1 elements
	 * of the msgvec.
	 */
	msgvec[1].msg_hdr.msg_control = BUF;
	msgvec[1].msg_hdr.msg_controllen = __len;

	recvmmsg(sock[0], &msgvec[0], nitems(msgvec), 0, NULL);
#undef BUF

}

ATF_TC(recvmmsg_msghdr_end);
ATF_TC_HEAD(recvmmsg_msghdr_end, tc)
{
}
ATF_TC_BODY(recvmmsg_msghdr_end, tc)
{
#define BUF &__stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char __buf[42];
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(__stack.__buf);
	const size_t __len = 42;
	const size_t __idx __unused = __len - 1;
	int sock[2] = { -1, -1 };
	struct mmsghdr msgvec[2];

	memset(&msgvec[0], 0, sizeof(msgvec));

	/*
	 * Same as above, make sure fortification isn't ignoring n > 1 elements
	 * of the msgvec.
	 */
	msgvec[1].msg_hdr.msg_control = BUF;
	msgvec[1].msg_hdr.msg_controllen = __len;

	recvmmsg(sock[0], &msgvec[0], nitems(msgvec), 0, NULL);
#undef BUF

}

ATF_TC(recvmmsg_msghdr_heap_before_end);
ATF_TC_HEAD(recvmmsg_msghdr_heap_before_end, tc)
{
}
ATF_TC_BODY(recvmmsg_msghdr_heap_before_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (42);
	const size_t __len = 42 - 1;
	const size_t __idx __unused = __len - 1;
	int sock[2] = { -1, -1 };
	struct mmsghdr msgvec[2];

	__stack.__buf = malloc(__bufsz);
	memset(&msgvec[0], 0, sizeof(msgvec));

	/*
	 * Same as above, make sure fortification isn't ignoring n > 1 elements
	 * of the msgvec.
	 */
	msgvec[1].msg_hdr.msg_control = BUF;
	msgvec[1].msg_hdr.msg_controllen = __len;

	recvmmsg(sock[0], &msgvec[0], nitems(msgvec), 0, NULL);
#undef BUF

}

ATF_TC(recvmmsg_msghdr_heap_end);
ATF_TC_HEAD(recvmmsg_msghdr_heap_end, tc)
{
}
ATF_TC_BODY(recvmmsg_msghdr_heap_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (42);
	const size_t __len = 42;
	const size_t __idx __unused = __len - 1;
	int sock[2] = { -1, -1 };
	struct mmsghdr msgvec[2];

	__stack.__buf = malloc(__bufsz);
	memset(&msgvec[0], 0, sizeof(msgvec));

	/*
	 * Same as above, make sure fortification isn't ignoring n > 1 elements
	 * of the msgvec.
	 */
	msgvec[1].msg_hdr.msg_control = BUF;
	msgvec[1].msg_hdr.msg_controllen = __len;

	recvmmsg(sock[0], &msgvec[0], nitems(msgvec), 0, NULL);
#undef BUF

}

ATF_TC(recvmmsg_msghdr_heap_after_end);
ATF_TC_HEAD(recvmmsg_msghdr_heap_after_end, tc)
{
}
ATF_TC_BODY(recvmmsg_msghdr_heap_after_end, tc)
{
#define BUF __stack.__buf
	struct {
		uint8_t padding_l;
		unsigned char * __buf;
		uint8_t padding_r;
	} __stack;
	const size_t __bufsz __unused = sizeof(*__stack.__buf) * (42);
	const size_t __len = 42 + 1;
	const size_t __idx __unused = __len - 1;
	pid_t __child;
	int __status;
	int sock[2] = { -1, -1 };
	struct mmsghdr msgvec[2];

	__child = fork();
	ATF_REQUIRE(__child >= 0);
	if (__child > 0)
		goto monitor;

	/* Child */
	disable_coredumps();
	__stack.__buf = malloc(__bufsz);
	memset(&msgvec[0], 0, sizeof(msgvec));

	/*
	 * Same as above, make sure fortification isn't ignoring n > 1 elements
	 * of the msgvec.
	 */
	msgvec[1].msg_hdr.msg_control = BUF;
	msgvec[1].msg_hdr.msg_controllen = __len;

	recvmmsg(sock[0], &msgvec[0], nitems(msgvec), 0, NULL);
	_exit(EX_SOFTWARE);	/* Should have aborted. */

monitor:
	while (waitpid(__child, &__status, 0) != __child) {
		ATF_REQUIRE_EQ(EINTR, errno);
	}

	if (!WIFSIGNALED(__status)) {
		switch (WEXITSTATUS(__status)) {
		case EX_SOFTWARE:
			atf_tc_fail("FORTIFY_SOURCE failed to abort");
			break;
		case EX_OSERR:
			atf_tc_fail("setrlimit(2) failed");
			break;
		default:
			atf_tc_fail("child exited with status %d",
			    WEXITSTATUS(__status));
		}
	} else {
		ATF_REQUIRE_EQ(SIGABRT, WTERMSIG(__status));
	}
#undef BUF

}

ATF_TP_ADD_TCS(tp)
{
	ATF_TP_ADD_TC(tp, getpeername_before_end);
	ATF_TP_ADD_TC(tp, getpeername_end);
	ATF_TP_ADD_TC(tp, getpeername_heap_before_end);
	ATF_TP_ADD_TC(tp, getpeername_heap_end);
	ATF_TP_ADD_TC(tp, getpeername_heap_after_end);
	ATF_TP_ADD_TC(tp, getsockname_before_end);
	ATF_TP_ADD_TC(tp, getsockname_end);
	ATF_TP_ADD_TC(tp, getsockname_heap_before_end);
	ATF_TP_ADD_TC(tp, getsockname_heap_end);
	ATF_TP_ADD_TC(tp, getsockname_heap_after_end);
	ATF_TP_ADD_TC(tp, recv_before_end);
	ATF_TP_ADD_TC(tp, recv_end);
	ATF_TP_ADD_TC(tp, recv_heap_before_end);
	ATF_TP_ADD_TC(tp, recv_heap_end);
	ATF_TP_ADD_TC(tp, recv_heap_after_end);
	ATF_TP_ADD_TC(tp, recvfrom_before_end);
	ATF_TP_ADD_TC(tp, recvfrom_end);
	ATF_TP_ADD_TC(tp, recvfrom_heap_before_end);
	ATF_TP_ADD_TC(tp, recvfrom_heap_end);
	ATF_TP_ADD_TC(tp, recvfrom_heap_after_end);
	ATF_TP_ADD_TC(tp, recvfrom_sockaddr_before_end);
	ATF_TP_ADD_TC(tp, recvfrom_sockaddr_end);
	ATF_TP_ADD_TC(tp, recvfrom_sockaddr_heap_before_end);
	ATF_TP_ADD_TC(tp, recvfrom_sockaddr_heap_end);
	ATF_TP_ADD_TC(tp, recvfrom_sockaddr_heap_after_end);
	ATF_TP_ADD_TC(tp, recvmsg_msg_name_before_end);
	ATF_TP_ADD_TC(tp, recvmsg_msg_name_end);
	ATF_TP_ADD_TC(tp, recvmsg_msg_name_heap_before_end);
	ATF_TP_ADD_TC(tp, recvmsg_msg_name_heap_end);
	ATF_TP_ADD_TC(tp, recvmsg_msg_name_heap_after_end);
	ATF_TP_ADD_TC(tp, recvmsg_msg_iov_before_end);
	ATF_TP_ADD_TC(tp, recvmsg_msg_iov_end);
	ATF_TP_ADD_TC(tp, recvmsg_msg_iov_heap_before_end);
	ATF_TP_ADD_TC(tp, recvmsg_msg_iov_heap_end);
	ATF_TP_ADD_TC(tp, recvmsg_msg_iov_heap_after_end);
	ATF_TP_ADD_TC(tp, recvmsg_msg_control_before_end);
	ATF_TP_ADD_TC(tp, recvmsg_msg_control_end);
	ATF_TP_ADD_TC(tp, recvmsg_msg_control_heap_before_end);
	ATF_TP_ADD_TC(tp, recvmsg_msg_control_heap_end);
	ATF_TP_ADD_TC(tp, recvmsg_msg_control_heap_after_end);
	ATF_TP_ADD_TC(tp, recvmmsg_msgvec_before_end);
	ATF_TP_ADD_TC(tp, recvmmsg_msgvec_end);
	ATF_TP_ADD_TC(tp, recvmmsg_msgvec_after_end);
	ATF_TP_ADD_TC(tp, recvmmsg_msgvec_heap_before_end);
	ATF_TP_ADD_TC(tp, recvmmsg_msgvec_heap_end);
	ATF_TP_ADD_TC(tp, recvmmsg_msgvec_heap_after_end);
	ATF_TP_ADD_TC(tp, recvmmsg_msghdr_before_end);
	ATF_TP_ADD_TC(tp, recvmmsg_msghdr_end);
	ATF_TP_ADD_TC(tp, recvmmsg_msghdr_heap_before_end);
	ATF_TP_ADD_TC(tp, recvmmsg_msghdr_heap_end);
	ATF_TP_ADD_TC(tp, recvmmsg_msghdr_heap_after_end);
	return (atf_no_error());
}
