#!/bin/sh

# panic: sbflush_internal: ccc 0 mb 0 mbcnt 256
# cpuid = 6
# time = 1653879149
# KDB: stack backtrace:
# db_trace_self_wrapper() at db_trace_self_wrapper+0x2b/frame 0xfffffe0694766c00
# vpanic() at vpanic+0x17f/frame 0xfffffe0694766c50
# panic() at panic+0x43/frame 0xfffffe0694766cb0
# sbrelease_internal() at sbrelease_internal+0xb9/frame 0xfffffe0694766cd0
# solisten_proto() at solisten_proto+0xb5/frame 0xfffffe0694766d30
# sctp_listen() at sctp_listen+0x2f7/frame 0xfffffe0694766da0
# solisten() at solisten+0x42/frame 0xfffffe0694766dc0
# kern_listen() at kern_listen+0x7d/frame 0xfffffe0694766e00
# amd64_syscall() at amd64_syscall+0x145/frame 0xfffffe0694766f30
# fast_syscall_common() at fast_syscall_common+0xf8/frame 0xfffffe0694766f30
# --- syscall (0, FreeBSD ELF64, nosys), rip = 0x82222e7da, rsp = 0x820d68d88, rbp = 0x820d68f00 ---
# KDB: enter: panic
# [ thread pid 12921 tid 741095 ]
# Stopped at      kdb_enter+0x32: movq    $0,0x1277ff3(%rip)
# db> x/s version
# FreeBSD 14.0-CURRENT #0 main-n255847-d46174cd8838b: Sat May 28 20:56:08 CEST 2022
# pho@mercat1.netperf.freebsd.org:/usr/src/sys/amd64/compile/PHO
# db> 

[ `uname -p` != "amd64" ] && exit 0

. ../default.cfg
cat > /tmp/syzkaller57.c <<EOF
// https://syzkaller.appspot.com/bug?id=66d47f23f24ecf5536fd47d81defdb917c307bd2
// autogenerated by syzkaller (https://github.com/google/syzkaller)
// Reported-by: syzbot+6c484f116b9dc88f7db1@syzkaller.appspotmail.com

#define _GNU_SOURCE

#include <sys/types.h>

#include <dirent.h>
#include <errno.h>
#include <pwd.h>
#include <setjmp.h>
#include <signal.h>
#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/endian.h>
#include <sys/stat.h>
#include <sys/syscall.h>
#include <sys/wait.h>
#include <time.h>
#include <unistd.h>

static __thread int skip_segv;
static __thread jmp_buf segv_env;

static void segv_handler(int sig, siginfo_t* info, void* ctx __unused)
{
  uintptr_t addr = (uintptr_t)info->si_addr;
  const uintptr_t prog_start = 1 << 20;
  const uintptr_t prog_end = 100 << 20;
  int skip = __atomic_load_n(&skip_segv, __ATOMIC_RELAXED) != 0;
  int valid = addr < prog_start || addr > prog_end;
  if (sig == SIGBUS) {
    valid = 1;
  }
  if (skip && valid) {
    _longjmp(segv_env, 1);
  }
  exit(sig);
}

static void install_segv_handler(void)
{
  struct sigaction sa;
  memset(&sa, 0, sizeof(sa));
  sa.sa_sigaction = segv_handler;
  sa.sa_flags = SA_NODEFER | SA_SIGINFO;
  sigaction(SIGSEGV, &sa, NULL);
  sigaction(SIGBUS, &sa, NULL);
}

#define NONFAILING(...)                                                        \
  ({                                                                           \
    int ok = 1;                                                                \
    __atomic_fetch_add(&skip_segv, 1, __ATOMIC_SEQ_CST);                       \
    if (_setjmp(segv_env) == 0) {                                              \
      __VA_ARGS__;                                                             \
    } else                                                                     \
      ok = 0;                                                                  \
    __atomic_fetch_sub(&skip_segv, 1, __ATOMIC_SEQ_CST);                       \
    ok;                                                                        \
  })

static void kill_and_wait(int pid, int* status)
{
  kill(pid, SIGKILL);
  while (waitpid(-1, status, 0) != pid) {
  }
}

static void sleep_ms(uint64_t ms)
{
  usleep(ms * 1000);
}

static uint64_t current_time_ms(void)
{
  struct timespec ts;
  if (clock_gettime(CLOCK_MONOTONIC, &ts))
    exit(1);
  return (uint64_t)ts.tv_sec * 1000 + (uint64_t)ts.tv_nsec / 1000000;
}

static void use_temporary_dir(void)
{
  char tmpdir_template[] = "./syzkaller.XXXXXX";
  char* tmpdir = mkdtemp(tmpdir_template);
  if (!tmpdir)
    exit(1);
  if (chmod(tmpdir, 0777))
    exit(1);
  if (chdir(tmpdir))
    exit(1);
}

static void __attribute__((noinline)) remove_dir(const char* dir)
{
  DIR* dp = opendir(dir);
  if (dp == NULL) {
    if (errno == EACCES) {
      if (rmdir(dir))
        exit(1);
      return;
    }
    exit(1);
  }
  struct dirent* ep = 0;
  while ((ep = readdir(dp))) {
    if (strcmp(ep->d_name, ".") == 0 || strcmp(ep->d_name, "..") == 0)
      continue;
    char filename[FILENAME_MAX];
    snprintf(filename, sizeof(filename), "%s/%s", dir, ep->d_name);
    struct stat st;
    if (lstat(filename, &st))
      exit(1);
    if (S_ISDIR(st.st_mode)) {
      remove_dir(filename);
      continue;
    }
    if (unlink(filename))
      exit(1);
  }
  closedir(dp);
  if (rmdir(dir))
    exit(1);
}

static void execute_one(void);

#define WAIT_FLAGS 0

static void loop(void)
{
  int iter = 0;
  for (;; iter++) {
    char cwdbuf[32];
    sprintf(cwdbuf, "./%d", iter);
    if (mkdir(cwdbuf, 0777))
      exit(1);
    int pid = fork();
    if (pid < 0)
      exit(1);
    if (pid == 0) {
      if (chdir(cwdbuf))
        exit(1);
      execute_one();
      exit(0);
    }
    int status = 0;
    uint64_t start = current_time_ms();
    for (;;) {
      if (waitpid(-1, &status, WNOHANG | WAIT_FLAGS) == pid)
        break;
      sleep_ms(1);
      if (current_time_ms() - start < 5000) {
        continue;
      }
      kill_and_wait(pid, &status);
      break;
    }
    remove_dir(cwdbuf);
  }
}

uint64_t r[1] = {0xffffffffffffffff};

void execute_one(void)
{
  intptr_t res = 0;
  res = syscall(SYS_socket, 0x1cul, 1ul, 0x84);
  if (res != -1)
    r[0] = res;
  NONFAILING(*(uint8_t*)0x20000000 = 0x1c);
  NONFAILING(*(uint8_t*)0x20000001 = 0x1c);
  NONFAILING(*(uint16_t*)0x20000002 = htobe16(0x4e22));
  NONFAILING(*(uint32_t*)0x20000004 = 0x20);
  NONFAILING(memset((void*)0x20000008, 0, 16));
  NONFAILING(*(uint32_t*)0x20000018 = 0x20);
  syscall(SYS_bind, r[0], 0x20000000ul, 0x1cul);
  NONFAILING(*(uint8_t*)0x20000180 = 0x1c);
  NONFAILING(*(uint8_t*)0x20000181 = 0x1c);
  NONFAILING(*(uint16_t*)0x20000182 = htobe16(0x4e22));
  NONFAILING(*(uint32_t*)0x20000184 = 4);
  NONFAILING(*(uint64_t*)0x20000188 = htobe64(0));
  NONFAILING(*(uint64_t*)0x20000190 = htobe64(1));
  NONFAILING(*(uint32_t*)0x20000198 = 4);
  syscall(SYS_connect, r[0], 0x20000180ul, 0x1cul);
  NONFAILING(memcpy(
      (void*)0x20000480,
      "\xa3\x1b\xe1\x78\x8e\x58\x9b\x38\x59\xf3\xbb\xdd\x7e\xf7\x51\x23\x97\x31"
      "\xb2\x90\x4a\xd0\x4e\xb7\xdc\x37\xc6\x95\xf6\x05\x5c\xa8\x36\x54\x7e\x7b"
      "\x6c\xc3\x7d\xae\x2a\xe4\x77\x08\x94\x67\x3c\x89\x65\x93\x24\x1c\x56\x3e"
      "\x08\x69\x05\x35\xeb\x3b\x7f\x19\x7d\xda\x44\x54\xb4\x42\x4f\x34\xc8\x81"
      "\x69\x4e\xac\xef\xa6\xd4\xb1\x61\x9d\xf1\x0b\x97\x7c\xd9\x82\x16\xc9\x7b"
      "\x2e\xb3\x9f\x02\xde\x0f\xae\xe7\x0b\xec\xa3\x66\x3c\x2e\x6c\xd1\xca\x02"
      "\xae\x0f\xd5\x65\xb9\x7c\x5c\xa0\xea\xfc\xa4\xc9\x13\x73\x14\x16\xba\xcc"
      "\xae\x89\xe2\x68\x77\xfc\x2a\x8c\xa3\xee\xa8\x45\xf7\xc2\xcb\x48\x93\xe5"
      "\x83\x52\x45\x26\xe3\xeb\x73\xa2\xe4\xf1\x11\xcf\x40\x5f\xef\x99\xc2\xa1"
      "\xeb\x2c\x96\x70\x56\x88\xc8\xc7\x6b\xa1\x66\xd2\x23\x20\x07\x62\x69\xd2"
      "\x1c\x52\xbb\x5e\x86\x43\x7d\x6c\x65\x44\x42\xf6\xd8\x45\xe2\xff\x77\xf9"
      "\x24\xf0\x1d\x29\xf6\xd3\x74\x83\x25\x40\x56\x50\x17\x7f\xc3\x60\xd7\xed"
      "\xb1\xfb\x7a\x74\x38\x2b\x47\x34\x93\x9c\xee\xc9\xb0\xbf\x7d\xc4\x19\xe2"
      "\x77\x49\xbc\x71\x9c\x30\x8b\x57\x0f\x13\x4d\x93\x9d\x53\xa8\x03\xc1\x3b"
      "\x5d\xc3\xbc\x20\xc4\x9e\xc1\x62\x69\xca\x92\x0f\x04\xa1\x0b\xea\xe7\x61"
      "\x79\x99\x5a\x53\x1a\x27\x40\xf0\x0b\xc5\xe8\xb5\xf0\xd8\x1c\xd2\xca\x99"
      "\x16\x70\xa8\xc5\xac\x0a\x6b\x99\x31\x0c\x90\xe2\xa5\xe0\xe3\x7c\x99\x3c"
      "\xbd\xeb\x42\xcf\x74\xe0\xa8\xea\x4e\x64\xd8\x30\x46\x6d\x6e\x83\x7f\x21"
      "\x00\x5c\xcf\x79\xfe\x19\xdd\xd5\xaf\x69\x9e\x1b\x67\xd5\x3f\x18\x4d\xe5"
      "\x2a\xec\x02\x12\x92",
      347));
  syscall(SYS_sendto, r[0], 0x20000480ul, 0x15bul, 0x20108ul, 0ul, 0ul);
  syscall(SYS_listen, r[0], 0x1f);
}
int main(void)
{
  syscall(SYS_mmap, 0x20000000ul, 0x1000000ul, 7ul, 0x1012ul, -1, 0ul);
  install_segv_handler();
  use_temporary_dir();
  loop();
  return 0;
}
EOF
mycc -o /tmp/syzkaller57 -Wall -Wextra -O0 /tmp/syzkaller57.c || exit 1

kldstat | grep -q sctp || { kldload sctp.ko && loaded=1; }
for i in `jot 3`; do
	(cd /tmp; timeout 3m ./syzkaller57) &
done
wait

rm -rf /tmp/syzkaller57 /tmp/syzkaller57.c /tmp/syzkaller57.core \
    /tmp/syzkaller.??????
[ $loaded ] && kldunload sctp.ko
exit 0
