/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.icu;

import com.ibm.icu.text.Normalizer2;
import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.charfilter.BaseCharFilter;

public final class ICUNormalizer2CharFilter
extends BaseCharFilter {
    private static final int IO_BUFFER_SIZE = 128;
    private final Normalizer2 normalizer;
    private final StringBuilder inputBuffer = new StringBuilder();
    private final StringBuilder resultBuffer = new StringBuilder();
    private boolean inputFinished;
    private boolean afterQuickCheckYes;
    private int checkedInputBoundary;
    private int charCount;
    private final char[] tmpBuffer = new char[128];

    public ICUNormalizer2CharFilter(Reader in) {
        this(in, Normalizer2.getInstance(null, "nfkc_cf", Normalizer2.Mode.COMPOSE));
    }

    public ICUNormalizer2CharFilter(Reader in, Normalizer2 normalizer) {
        super(in);
        if (normalizer == null) {
            throw new NullPointerException("normalizer == null");
        }
        this.normalizer = normalizer;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (off < 0) {
            throw new IllegalArgumentException("off < 0");
        }
        if (off >= cbuf.length) {
            throw new IllegalArgumentException("off >= cbuf.length");
        }
        if (len <= 0) {
            throw new IllegalArgumentException("len <= 0");
        }
        while (!this.inputFinished || this.inputBuffer.length() > 0 || this.resultBuffer.length() > 0) {
            int retLen;
            if (this.resultBuffer.length() > 0 && (retLen = this.outputFromResultBuffer(cbuf, off, len)) > 0) {
                return retLen;
            }
            int resLen = this.readAndNormalizeFromInput();
            if (resLen > 0 && (retLen = this.outputFromResultBuffer(cbuf, off, len)) > 0) {
                return retLen;
            }
            this.readInputToBuffer();
        }
        return -1;
    }

    private int readInputToBuffer() throws IOException {
        int len = this.input.read(this.tmpBuffer);
        if (len == -1) {
            this.inputFinished = true;
            return 0;
        }
        this.inputBuffer.append(this.tmpBuffer, 0, len);
        this.checkedInputBoundary = Math.max(this.checkedInputBoundary - 1, 0);
        if (this.normalizer.isInert(this.tmpBuffer[len - 1]) && !Character.isSurrogate(this.tmpBuffer[len - 1])) {
            return len;
        }
        return len + this.readInputToBuffer();
    }

    private int readAndNormalizeFromInput() {
        int resLen;
        if (this.inputBuffer.length() <= 0) {
            this.afterQuickCheckYes = false;
            return 0;
        }
        if (!this.afterQuickCheckYes) {
            resLen = this.readFromInputWhileSpanQuickCheckYes();
            this.afterQuickCheckYes = true;
            if (resLen > 0) {
                return resLen;
            }
        }
        if ((resLen = this.readFromIoNormalizeUptoBoundary()) > 0) {
            this.afterQuickCheckYes = false;
        }
        return resLen;
    }

    private int readFromInputWhileSpanQuickCheckYes() {
        int end = this.normalizer.spanQuickCheckYes(this.inputBuffer);
        if (end > 0) {
            this.resultBuffer.append(this.inputBuffer.subSequence(0, end));
            this.inputBuffer.delete(0, end);
            this.checkedInputBoundary = Math.max(this.checkedInputBoundary - end, 0);
            this.charCount += end;
        }
        return end;
    }

    private int readFromIoNormalizeUptoBoundary() {
        if (this.inputBuffer.length() <= 0) {
            return 0;
        }
        boolean foundBoundary = false;
        int bufLen = this.inputBuffer.length();
        while (this.checkedInputBoundary <= bufLen - 1) {
            int charLen = Character.charCount(this.inputBuffer.codePointAt(this.checkedInputBoundary));
            this.checkedInputBoundary += charLen;
            if (this.checkedInputBoundary >= bufLen || !this.normalizer.hasBoundaryBefore(this.inputBuffer.codePointAt(this.checkedInputBoundary))) continue;
            foundBoundary = true;
            break;
        }
        if (!foundBoundary && this.checkedInputBoundary >= bufLen && this.inputFinished) {
            foundBoundary = true;
            this.checkedInputBoundary = bufLen;
        }
        if (!foundBoundary) {
            return 0;
        }
        return this.normalizeInputUpto(this.checkedInputBoundary);
    }

    private int normalizeInputUpto(int length) {
        int destOrigLen = this.resultBuffer.length();
        this.normalizer.normalizeSecondAndAppend(this.resultBuffer, this.inputBuffer.subSequence(0, length));
        this.inputBuffer.delete(0, length);
        this.checkedInputBoundary = Math.max(this.checkedInputBoundary - length, 0);
        int resultLength = this.resultBuffer.length() - destOrigLen;
        this.recordOffsetDiff(length, resultLength);
        return resultLength;
    }

    private void recordOffsetDiff(int inputLength, int outputLength) {
        if (inputLength == outputLength) {
            this.charCount += outputLength;
            return;
        }
        int diff = inputLength - outputLength;
        int cumuDiff = this.getLastCumulativeDiff();
        if (diff < 0) {
            for (int i = 1; i <= -diff; ++i) {
                this.addOffCorrectMap(this.charCount + i, cumuDiff - i);
            }
        } else {
            this.addOffCorrectMap(this.charCount + outputLength, cumuDiff + diff);
        }
        this.charCount += outputLength;
    }

    private int outputFromResultBuffer(char[] cbuf, int begin, int len) {
        len = Math.min(this.resultBuffer.length(), len);
        this.resultBuffer.getChars(0, len, cbuf, begin);
        if (len > 0) {
            this.resultBuffer.delete(0, len);
        }
        return len;
    }
}

